/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sql.parser.statement.core.statement.type.ddl.index;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.shardingsphere.database.connector.core.type.DatabaseType;
import org.apache.shardingsphere.sql.parser.statement.core.segment.ddl.index.IndexNameSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.ddl.index.IndexSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.ddl.property.PropertiesSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.ddl.table.AlgorithmTypeSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.ddl.table.LockTableSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.column.ColumnSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.generic.table.SimpleTableSegment;
import org.apache.shardingsphere.sql.parser.statement.core.statement.attribute.SQLStatementAttributes;
import org.apache.shardingsphere.sql.parser.statement.core.statement.attribute.type.IndexSQLStatementAttribute;
import org.apache.shardingsphere.sql.parser.statement.core.statement.attribute.type.TableSQLStatementAttribute;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.ddl.DDLStatement;
import org.apache.shardingsphere.sql.parser.statement.core.value.identifier.IdentifierValue;

public final class CreateIndexStatement
extends DDLStatement {
    private IndexSegment index;
    private SimpleTableSegment table;
    private boolean ifNotExists;
    private Integer anonymousIndexStartIndex;
    private AlgorithmTypeSegment algorithmType;
    private LockTableSegment lockTable;
    private final Collection<ColumnSegment> columns = new LinkedList<ColumnSegment>();
    private String indexType;
    private PropertiesSegment properties;
    private String comment;
    private SQLStatementAttributes attributes;

    public CreateIndexStatement(DatabaseType databaseType) {
        super(databaseType);
    }

    public Optional<Integer> getAnonymousIndexStartIndex() {
        return Optional.ofNullable(this.anonymousIndexStartIndex);
    }

    public Optional<AlgorithmTypeSegment> getAlgorithmType() {
        return Optional.ofNullable(this.algorithmType);
    }

    public Optional<LockTableSegment> getLockTable() {
        return Optional.ofNullable(this.lockTable);
    }

    @Override
    public void buildAttributes() {
        this.attributes = new SQLStatementAttributes(new TableSQLStatementAttribute(this.table), new CreateIndexIndexSQLStatementAttribute());
    }

    @Generated
    public IndexSegment getIndex() {
        return this.index;
    }

    @Generated
    public SimpleTableSegment getTable() {
        return this.table;
    }

    @Generated
    public boolean isIfNotExists() {
        return this.ifNotExists;
    }

    @Generated
    public Collection<ColumnSegment> getColumns() {
        return this.columns;
    }

    @Generated
    public String getIndexType() {
        return this.indexType;
    }

    @Generated
    public PropertiesSegment getProperties() {
        return this.properties;
    }

    @Generated
    public String getComment() {
        return this.comment;
    }

    @Override
    @Generated
    public SQLStatementAttributes getAttributes() {
        return this.attributes;
    }

    @Generated
    public void setIndex(IndexSegment index) {
        this.index = index;
    }

    @Generated
    public void setTable(SimpleTableSegment table) {
        this.table = table;
    }

    @Generated
    public void setIfNotExists(boolean ifNotExists) {
        this.ifNotExists = ifNotExists;
    }

    @Generated
    public void setAnonymousIndexStartIndex(Integer anonymousIndexStartIndex) {
        this.anonymousIndexStartIndex = anonymousIndexStartIndex;
    }

    @Generated
    public void setAlgorithmType(AlgorithmTypeSegment algorithmType) {
        this.algorithmType = algorithmType;
    }

    @Generated
    public void setLockTable(LockTableSegment lockTable) {
        this.lockTable = lockTable;
    }

    @Generated
    public void setIndexType(String indexType) {
        this.indexType = indexType;
    }

    @Generated
    public void setProperties(PropertiesSegment properties) {
        this.properties = properties;
    }

    @Generated
    public void setComment(String comment) {
        this.comment = comment;
    }

    @Generated
    public void setAttributes(SQLStatementAttributes attributes) {
        this.attributes = attributes;
    }

    private class CreateIndexIndexSQLStatementAttribute
    implements IndexSQLStatementAttribute {
        private static final String UNDERLINE = "_";
        private static final String GENERATED_LOGIC_INDEX_NAME_SUFFIX = "idx";

        private CreateIndexIndexSQLStatementAttribute() {
        }

        @Override
        public Collection<IndexSegment> getIndexes() {
            if (null != CreateIndexStatement.this.index) {
                return Collections.singleton(CreateIndexStatement.this.index);
            }
            if (!CreateIndexStatement.this.getAnonymousIndexStartIndex().isPresent()) {
                return Collections.emptyList();
            }
            int anonymousIndexStartIndex = CreateIndexStatement.this.getAnonymousIndexStartIndex().get();
            IndexNameSegment anonymousIndexNameSegment = new IndexNameSegment(anonymousIndexStartIndex, anonymousIndexStartIndex, new IdentifierValue(this.getGeneratedLogicIndexName(CreateIndexStatement.this.columns)));
            return Collections.singleton(new IndexSegment(anonymousIndexStartIndex, anonymousIndexStartIndex, anonymousIndexNameSegment));
        }

        private String getGeneratedLogicIndexName(Collection<ColumnSegment> columns) {
            return columns.stream().map(each -> each.getIdentifier().getValue() + UNDERLINE).collect(Collectors.joining("", "", GENERATED_LOGIC_INDEX_NAME_SUFFIX));
        }

        @Override
        public Collection<ColumnSegment> getIndexColumns() {
            return CreateIndexStatement.this.columns;
        }
    }
}

