/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sql.parser.statement.core.statement.type.ddl.index;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.Optional;
import lombok.Generated;
import org.apache.shardingsphere.database.connector.core.type.DatabaseType;
import org.apache.shardingsphere.sql.parser.statement.core.segment.ddl.index.IndexSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.column.ColumnSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.generic.table.SimpleTableSegment;
import org.apache.shardingsphere.sql.parser.statement.core.statement.attribute.SQLStatementAttributes;
import org.apache.shardingsphere.sql.parser.statement.core.statement.attribute.type.IndexSQLStatementAttribute;
import org.apache.shardingsphere.sql.parser.statement.core.statement.attribute.type.TableSQLStatementAttribute;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.ddl.DDLStatement;

public final class AlterIndexStatement
extends DDLStatement {
    private IndexSegment index;
    private IndexSegment renameIndex;
    private SimpleTableSegment simpleTable;
    private SQLStatementAttributes attributes;

    public AlterIndexStatement(DatabaseType databaseType) {
        super(databaseType);
    }

    public Optional<IndexSegment> getIndex() {
        return Optional.ofNullable(this.index);
    }

    public Optional<IndexSegment> getRenameIndex() {
        return Optional.ofNullable(this.renameIndex);
    }

    public Optional<SimpleTableSegment> getSimpleTable() {
        return Optional.ofNullable(this.simpleTable);
    }

    @Override
    public void buildAttributes() {
        this.attributes = new SQLStatementAttributes(new TableSQLStatementAttribute(this.simpleTable), new AlterIndexIndexSQLStatementAttribute());
    }

    @Generated
    public void setIndex(IndexSegment index) {
        this.index = index;
    }

    @Generated
    public void setRenameIndex(IndexSegment renameIndex) {
        this.renameIndex = renameIndex;
    }

    @Generated
    public void setSimpleTable(SimpleTableSegment simpleTable) {
        this.simpleTable = simpleTable;
    }

    @Generated
    public void setAttributes(SQLStatementAttributes attributes) {
        this.attributes = attributes;
    }

    @Override
    @Generated
    public SQLStatementAttributes getAttributes() {
        return this.attributes;
    }

    private class AlterIndexIndexSQLStatementAttribute
    implements IndexSQLStatementAttribute {
        private AlterIndexIndexSQLStatementAttribute() {
        }

        @Override
        public Collection<IndexSegment> getIndexes() {
            LinkedList<IndexSegment> result = new LinkedList<IndexSegment>();
            if (AlterIndexStatement.this.getIndex().isPresent()) {
                result.add(AlterIndexStatement.this.getIndex().get());
            }
            AlterIndexStatement.this.getRenameIndex().ifPresent(result::add);
            return result;
        }

        @Override
        public Collection<ColumnSegment> getIndexColumns() {
            return Collections.emptyList();
        }
    }
}

