/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sql.parser.statement.core.statement.attribute;

import java.util.Arrays;
import java.util.Collection;
import java.util.Optional;
import org.apache.shardingsphere.sql.parser.statement.core.statement.attribute.SQLStatementAttribute;

public final class SQLStatementAttributes {
    private final Collection<SQLStatementAttribute> attributes;

    public SQLStatementAttributes(SQLStatementAttribute ... attributes) {
        this.attributes = Arrays.asList(attributes);
    }

    public <T extends SQLStatementAttribute> Optional<T> findAttribute(Class<T> attributeClass) {
        for (SQLStatementAttribute each : this.attributes) {
            if (!attributeClass.isAssignableFrom(each.getClass())) continue;
            return Optional.of(each);
        }
        return Optional.empty();
    }

    public <T extends SQLStatementAttribute> T getAttribute(Class<T> attributeClass) {
        return (T)((SQLStatementAttribute)this.findAttribute(attributeClass).orElseThrow(() -> new IllegalStateException(String.format("Can not find SQL statement attribute: %s", attributeClass))));
    }
}

