/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sql.parser.statement.core.segment.generic.bound;

import lombok.Generated;
import org.apache.shardingsphere.sql.parser.statement.core.enums.TableSourceType;
import org.apache.shardingsphere.sql.parser.statement.core.segment.generic.bound.TableSegmentBoundInfo;
import org.apache.shardingsphere.sql.parser.statement.core.value.identifier.IdentifierValue;

public final class ColumnSegmentBoundInfo {
    private final TableSegmentBoundInfo tableBoundInfo;
    private final IdentifierValue originalTable;
    private final IdentifierValue originalColumn;
    private final TableSourceType tableSourceType;

    public ColumnSegmentBoundInfo(IdentifierValue originalColumn) {
        this(null, null, originalColumn, TableSourceType.PHYSICAL_TABLE);
    }

    public ColumnSegmentBoundInfo(TableSegmentBoundInfo tableBoundInfo, IdentifierValue originalTable, IdentifierValue originalColumn, TableSourceType tableSourceType) {
        this.tableBoundInfo = null == tableBoundInfo ? new TableSegmentBoundInfo(null, null) : tableBoundInfo;
        this.originalTable = null == originalTable ? new IdentifierValue("") : originalTable;
        this.originalColumn = null == originalColumn ? new IdentifierValue("") : originalColumn;
        this.tableSourceType = tableSourceType;
    }

    public IdentifierValue getOriginalDatabase() {
        return this.tableBoundInfo.getOriginalDatabase();
    }

    public IdentifierValue getOriginalSchema() {
        return this.tableBoundInfo.getOriginalSchema();
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        if (null != this.getOriginalDatabase()) {
            result.append(this.getOriginalDatabase().getValue()).append(".");
        }
        if (null != this.getOriginalSchema()) {
            result.append(this.getOriginalSchema().getValue()).append(".");
        }
        if (null != this.originalTable) {
            result.append(this.originalTable.getValue()).append(".");
        }
        if (null != this.originalColumn) {
            result.append(this.originalColumn.getValue());
        }
        return result.toString();
    }

    @Generated
    public TableSegmentBoundInfo getTableBoundInfo() {
        return this.tableBoundInfo;
    }

    @Generated
    public IdentifierValue getOriginalTable() {
        return this.originalTable;
    }

    @Generated
    public IdentifierValue getOriginalColumn() {
        return this.originalColumn;
    }

    @Generated
    public TableSourceType getTableSourceType() {
        return this.tableSourceType;
    }
}

