/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sql.parser.statement.core.segment.dml.expr.complex;

import java.util.Collection;
import java.util.LinkedList;
import java.util.Optional;
import lombok.Generated;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.column.ColumnSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.expr.subquery.SubquerySegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.generic.AliasSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.generic.table.TableSegment;
import org.apache.shardingsphere.sql.parser.statement.core.value.identifier.IdentifierValue;

public final class CommonTableExpressionSegment
implements TableSegment {
    private final int startIndex;
    private final int stopIndex;
    private AliasSegment aliasSegment;
    private final SubquerySegment subquery;
    private final Collection<ColumnSegment> columns = new LinkedList<ColumnSegment>();

    @Override
    public Optional<String> getAliasName() {
        return this.getAlias().map(IdentifierValue::getValue);
    }

    @Override
    public Optional<IdentifierValue> getAlias() {
        return Optional.of(this.aliasSegment).map(AliasSegment::getIdentifier);
    }

    @Override
    public Optional<AliasSegment> getAliasSegment() {
        return Optional.ofNullable(this.aliasSegment);
    }

    @Override
    public void setAlias(AliasSegment alias) {
        this.aliasSegment = alias;
    }

    @Generated
    public CommonTableExpressionSegment(int startIndex, int stopIndex, AliasSegment aliasSegment, SubquerySegment subquery) {
        this.startIndex = startIndex;
        this.stopIndex = stopIndex;
        this.aliasSegment = aliasSegment;
        this.subquery = subquery;
    }

    @Override
    @Generated
    public int getStartIndex() {
        return this.startIndex;
    }

    @Override
    @Generated
    public int getStopIndex() {
        return this.stopIndex;
    }

    @Generated
    public SubquerySegment getSubquery() {
        return this.subquery;
    }

    @Generated
    public Collection<ColumnSegment> getColumns() {
        return this.columns;
    }
}

