/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sql.parser.statement.core.segment.dml.column;

import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.expr.ExpressionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.generic.OwnerAvailable;
import org.apache.shardingsphere.sql.parser.statement.core.segment.generic.OwnerSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.generic.ParenthesesSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.generic.bound.ColumnSegmentBoundInfo;
import org.apache.shardingsphere.sql.parser.statement.core.value.identifier.IdentifierValue;

public final class ColumnSegment
implements ExpressionSegment,
OwnerAvailable {
    private final int startIndex;
    private final int stopIndex;
    private final IdentifierValue identifier;
    private List<IdentifierValue> nestedObjectAttributes;
    private OwnerSegment owner;
    private ColumnSegmentBoundInfo columnBoundInfo;
    private ColumnSegmentBoundInfo otherUsingColumnBoundInfo;
    private boolean isVariable;
    private ParenthesesSegment leftParentheses;
    private ParenthesesSegment rightParentheses;

    public ColumnSegment(int startIndex, int stopIndex, IdentifierValue identifier) {
        this.startIndex = startIndex;
        this.stopIndex = stopIndex;
        this.identifier = identifier;
        this.columnBoundInfo = new ColumnSegmentBoundInfo(identifier);
    }

    public String getQualifiedName() {
        String column = this.identifier.getValueWithQuoteCharacters();
        if (null != this.nestedObjectAttributes && !this.nestedObjectAttributes.isEmpty()) {
            column = String.join((CharSequence)".", column, this.nestedObjectAttributes.stream().map(IdentifierValue::getValueWithQuoteCharacters).collect(Collectors.joining(".")));
        }
        return null == this.owner ? column : String.join((CharSequence)".", this.owner.getIdentifier().getValueWithQuoteCharacters(), column);
    }

    public String getExpression() {
        String column = this.identifier.getValue();
        if (null != this.nestedObjectAttributes && !this.nestedObjectAttributes.isEmpty()) {
            column = String.join((CharSequence)".", column, this.nestedObjectAttributes.stream().map(IdentifierValue::getValue).collect(Collectors.joining(".")));
        }
        return null == this.owner ? column : String.join((CharSequence)".", this.owner.getIdentifier().getValue(), column);
    }

    public Optional<ParenthesesSegment> getLeftParentheses() {
        return Optional.ofNullable(this.leftParentheses);
    }

    public Optional<ParenthesesSegment> getRightParentheses() {
        return Optional.ofNullable(this.rightParentheses);
    }

    @Override
    public Optional<OwnerSegment> getOwner() {
        return Optional.ofNullable(this.owner);
    }

    @Override
    public String getText() {
        return this.getExpression();
    }

    @Override
    @Generated
    public int getStartIndex() {
        return this.startIndex;
    }

    @Override
    @Generated
    public int getStopIndex() {
        return this.stopIndex;
    }

    @Generated
    public IdentifierValue getIdentifier() {
        return this.identifier;
    }

    @Generated
    public List<IdentifierValue> getNestedObjectAttributes() {
        return this.nestedObjectAttributes;
    }

    @Generated
    public ColumnSegmentBoundInfo getColumnBoundInfo() {
        return this.columnBoundInfo;
    }

    @Generated
    public ColumnSegmentBoundInfo getOtherUsingColumnBoundInfo() {
        return this.otherUsingColumnBoundInfo;
    }

    @Generated
    public boolean isVariable() {
        return this.isVariable;
    }

    @Generated
    public void setNestedObjectAttributes(List<IdentifierValue> nestedObjectAttributes) {
        this.nestedObjectAttributes = nestedObjectAttributes;
    }

    @Override
    @Generated
    public void setOwner(OwnerSegment owner) {
        this.owner = owner;
    }

    @Generated
    public void setColumnBoundInfo(ColumnSegmentBoundInfo columnBoundInfo) {
        this.columnBoundInfo = columnBoundInfo;
    }

    @Generated
    public void setOtherUsingColumnBoundInfo(ColumnSegmentBoundInfo otherUsingColumnBoundInfo) {
        this.otherUsingColumnBoundInfo = otherUsingColumnBoundInfo;
    }

    @Generated
    public void setVariable(boolean isVariable) {
        this.isVariable = isVariable;
    }

    @Generated
    public void setLeftParentheses(ParenthesesSegment leftParentheses) {
        this.leftParentheses = leftParentheses;
    }

    @Generated
    public void setRightParentheses(ParenthesesSegment rightParentheses) {
        this.rightParentheses = rightParentheses;
    }
}

