/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sql.parser.statement.core.extractor;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import lombok.Generated;
import org.apache.shardingsphere.sql.parser.statement.core.extractor.SubqueryExtractor;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.expr.ExpressionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.expr.subquery.SubquerySegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.predicate.WhereSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.generic.table.JoinTableSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.generic.table.TableSegment;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.dml.SelectStatement;

public final class WhereExtractor {
    public static Collection<WhereSegment> extractJoinWhereSegments(SelectStatement selectStatement) {
        return selectStatement.getFrom().map(WhereExtractor::extractJoinWhereSegments).orElseGet(Collections::emptyList);
    }

    private static Collection<WhereSegment> extractJoinWhereSegments(TableSegment tableSegment) {
        if (!(tableSegment instanceof JoinTableSegment) || null == ((JoinTableSegment)tableSegment).getCondition()) {
            return Collections.emptyList();
        }
        JoinTableSegment joinTableSegment = (JoinTableSegment)tableSegment;
        LinkedList<WhereSegment> result = new LinkedList<WhereSegment>();
        result.add(WhereExtractor.generateWhereSegment(joinTableSegment));
        result.addAll(WhereExtractor.extractJoinWhereSegments(joinTableSegment.getLeft()));
        result.addAll(WhereExtractor.extractJoinWhereSegments(joinTableSegment.getRight()));
        return result;
    }

    private static WhereSegment generateWhereSegment(JoinTableSegment joinTableSegment) {
        ExpressionSegment expressionSegment = joinTableSegment.getCondition();
        return new WhereSegment(expressionSegment.getStartIndex(), expressionSegment.getStopIndex(), expressionSegment);
    }

    public static Collection<WhereSegment> extractSubqueryWhereSegments(SelectStatement selectStatement) {
        LinkedList<WhereSegment> result = new LinkedList<WhereSegment>();
        for (SubquerySegment each : SubqueryExtractor.extractSubquerySegments(selectStatement, false)) {
            each.getSelect().getWhere().ifPresent(result::add);
            result.addAll(WhereExtractor.extractJoinWhereSegments(each.getSelect()));
        }
        return result;
    }

    @Generated
    private WhereExtractor() {
    }
}

