/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sql.parser.statement.doris.dal.show;

import java.util.Optional;
import lombok.Generated;
import org.apache.shardingsphere.database.connector.core.type.DatabaseType;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dal.FromTableSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.generic.DatabaseSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.generic.table.SimpleTableSegment;
import org.apache.shardingsphere.sql.parser.statement.core.statement.attribute.SQLStatementAttribute;
import org.apache.shardingsphere.sql.parser.statement.core.statement.attribute.SQLStatementAttributes;
import org.apache.shardingsphere.sql.parser.statement.core.statement.attribute.type.AllowNotUseDatabaseSQLStatementAttribute;
import org.apache.shardingsphere.sql.parser.statement.core.statement.attribute.type.DatabaseSelectRequiredSQLStatementAttribute;
import org.apache.shardingsphere.sql.parser.statement.core.statement.attribute.type.TableSQLStatementAttribute;
import org.apache.shardingsphere.sql.parser.statement.core.statement.attribute.type.TablelessDataSourceBroadcastRouteSQLStatementAttribute;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.dal.DALStatement;

public final class DorisShowQueryStatsStatement
extends DALStatement {
    private final DatabaseSegment database;
    private final FromTableSegment fromTable;
    private final boolean all;
    private final boolean verbose;
    private SQLStatementAttributes attributes;

    public DorisShowQueryStatsStatement(DatabaseType databaseType, DatabaseSegment database, FromTableSegment fromTable, boolean all, boolean verbose) {
        super(databaseType);
        this.database = database;
        this.fromTable = fromTable;
        this.all = all;
        this.verbose = verbose;
    }

    public Optional<DatabaseSegment> getDatabase() {
        return Optional.ofNullable(this.database);
    }

    public Optional<FromTableSegment> getFromTable() {
        return Optional.ofNullable(this.fromTable);
    }

    public Optional<SimpleTableSegment> getTable() {
        return null == this.fromTable ? Optional.empty() : Optional.ofNullable(this.fromTable.getTable());
    }

    public void buildAttributes() {
        String databaseName = null == this.database ? null : this.database.getIdentifier().getValue();
        SimpleTableSegment table = null == this.fromTable ? null : this.fromTable.getTable();
        this.attributes = new SQLStatementAttributes(new SQLStatementAttribute[]{new DatabaseSelectRequiredSQLStatementAttribute(), new TableSQLStatementAttribute(table), new TablelessDataSourceBroadcastRouteSQLStatementAttribute(), new AllowNotUseDatabaseSQLStatementAttribute(true, databaseName)});
    }

    @Generated
    public boolean isAll() {
        return this.all;
    }

    @Generated
    public boolean isVerbose() {
        return this.verbose;
    }

    @Generated
    public SQLStatementAttributes getAttributes() {
        return this.attributes;
    }
}

