/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.spi.type.ordered;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import lombok.Generated;
import org.apache.shardingsphere.infra.spi.ShardingSphereServiceLoader;
import org.apache.shardingsphere.infra.spi.annotation.SingletonSPI;
import org.apache.shardingsphere.infra.spi.type.ordered.OrderedSPI;

public final class OrderedSPILoader {
    private static final ClassValue<OrderedSPIRegistry<?>> REGISTRY = new ClassValue<OrderedSPIRegistry<?>>(){

        @Override
        protected OrderedSPIRegistry<?> computeValue(Class<?> clazz) {
            return null != clazz.getAnnotation(SingletonSPI.class) ? new CachedSingletonOrderedSPIRegistry(clazz) : new NoCachePrototypeOrderedSPIRegistry(clazz);
        }
    };

    public static <T extends OrderedSPI<?>> Map<Class<?>, T> getServicesByClass(Class<T> serviceInterface, Collection<Class<?>> types) {
        return REGISTRY.get(serviceInterface).getServicesByClass(types);
    }

    public static <K, V extends OrderedSPI<?>> Map<K, V> getServices(Class<V> serviceInterface, Collection<K> types) {
        return REGISTRY.get(serviceInterface).getServices(types);
    }

    public static <K, V extends OrderedSPI<?>> Map<K, V> getServices(Class<V> serviceInterface, Collection<K> types, Comparator<Integer> orderComparator) {
        ArrayList orderServices = new ArrayList(REGISTRY.get(serviceInterface).getServices(types).entrySet());
        orderServices.sort((e1, e2) -> orderComparator.compare(((OrderedSPI)e1.getValue()).getOrder(), ((OrderedSPI)e2.getValue()).getOrder()));
        LinkedHashMap result = new LinkedHashMap(orderServices.size(), 1.0f);
        for (Map.Entry entry : orderServices) {
            result.put(entry.getKey(), (OrderedSPI)entry.getValue());
        }
        return result;
    }

    public static <T extends OrderedSPI<?>> Collection<T> getServices(Class<T> serviceInterface) {
        return REGISTRY.get(serviceInterface).getOrderedServices();
    }

    @Generated
    private OrderedSPILoader() {
    }

    private static interface OrderedSPIRegistry<T extends OrderedSPI<?>> {
        public Collection<T> getOrderedServices();

        public Map<Class<?>, T> getServicesByClass(Collection<Class<?>> var1);

        public <K> Map<K, T> getServices(Collection<K> var1);
    }

    private static final class NoCachePrototypeOrderedSPIRegistry<T extends OrderedSPI<?>>
    implements OrderedSPIRegistry<T> {
        private final Class<T> serviceInterface;

        NoCachePrototypeOrderedSPIRegistry(Class<?> serviceInterface) {
            this.serviceInterface = serviceInterface;
        }

        @Override
        public Collection<T> getOrderedServices() {
            return this.loadOrderedServices();
        }

        @Override
        public Map<Class<?>, T> getServicesByClass(Collection<Class<?>> types) {
            Set<Object> typeClasses = types instanceof Set ? (Set<Object>)types : new HashSet(types);
            LinkedHashMap result = new LinkedHashMap(types.size(), 1.0f);
            for (OrderedSPI each : this.loadOrderedServices()) {
                if (!typeClasses.contains(each.getTypeClass())) continue;
                result.put(each.getTypeClass(), each);
            }
            return result;
        }

        @Override
        public <K> Map<K, T> getServices(Collection<K> types) {
            HashMap<Class, List> classTypeMap = new HashMap<Class, List>(types.size(), 1.0f);
            HashSet typeClasses = new HashSet(types.size(), 1.0f);
            for (K each : types) {
                classTypeMap.computeIfAbsent(each.getClass(), clazz -> new LinkedList()).add(each);
                typeClasses.add(each.getClass());
            }
            LinkedHashMap result = new LinkedHashMap(types.size(), 1.0f);
            for (OrderedSPI each : this.loadOrderedServices()) {
                if (!typeClasses.contains(each.getTypeClass())) continue;
                for (Object type : (List)classTypeMap.get(each.getTypeClass())) {
                    result.put(type, each);
                }
            }
            return result;
        }

        private Collection<T> loadOrderedServices() {
            TreeMap result = new TreeMap(Comparator.naturalOrder());
            for (OrderedSPI each : ShardingSphereServiceLoader.getServiceInstances(this.serviceInterface)) {
                Preconditions.checkArgument((!result.containsKey(each.getOrder()) ? 1 : 0) != 0, (String)"Found same order `%s` with `%s` and `%s`", (Object)each.getOrder(), result.get(each.getOrder()), (Object)each);
                result.put(each.getOrder(), each);
            }
            return result.values();
        }
    }

    private static final class CachedSingletonOrderedSPIRegistry<T extends OrderedSPI<?>>
    implements OrderedSPIRegistry<T> {
        private final Collection<T> orderedServices;
        private final Map<Class<?>, T> singleTypeClassToService;
        private final Map<Set<Class<?>>, Map<Class<?>, T>> multiTypeClassToServices = new ConcurrentHashMap();
        private final Map<Collection<?>, Map<?, T>> multiObjectToServices = new ConcurrentHashMap();

        CachedSingletonOrderedSPIRegistry(Class<?> serviceInterface) {
            TreeMap orderServices = new TreeMap(Comparator.naturalOrder());
            for (Object each : ShardingSphereServiceLoader.getServiceInstances(serviceInterface)) {
                Preconditions.checkArgument((!orderServices.containsKey(((OrderedSPI)each).getOrder()) ? 1 : 0) != 0, (String)"Found same order `%s` with `%s` and `%s`", (Object)((OrderedSPI)each).getOrder(), orderServices.get(((OrderedSPI)each).getOrder()), each);
                orderServices.put(((OrderedSPI)each).getOrder(), (OrderedSPI)each);
            }
            this.orderedServices = orderServices.values();
            this.singleTypeClassToService = new HashMap(this.orderedServices.size(), 1.0f);
            for (Object each : this.orderedServices) {
                this.singleTypeClassToService.put(each.getTypeClass(), each);
            }
        }

        @Override
        public Collection<T> getOrderedServices() {
            return this.orderedServices;
        }

        @Override
        public Map<Class<?>, T> getServicesByClass(Collection<Class<?>> types) {
            if (1 == types.size()) {
                Class<?> type = types.iterator().next();
                OrderedSPI service = (OrderedSPI)this.singleTypeClassToService.get(type);
                return null == service ? Collections.emptyMap() : Collections.singletonMap(type, service);
            }
            Set<Object> typeClasses = types instanceof Set ? (Set<Object>)types : new HashSet(types);
            Map result = this.multiTypeClassToServices.get(typeClasses);
            if (null == result) {
                result = this.multiTypeClassToServices.computeIfAbsent(typeClasses, this::computeServicesByClass);
            }
            return result;
        }

        private Map<Class<?>, T> computeServicesByClass(Set<Class<?>> types) {
            LinkedHashMap result = new LinkedHashMap(types.size(), 1.0f);
            for (OrderedSPI each : this.orderedServices) {
                if (!types.contains(each.getTypeClass())) continue;
                result.put(each.getTypeClass(), each);
            }
            return result;
        }

        @Override
        public <K> Map<K, T> getServices(Collection<K> types) {
            if (1 == types.size()) {
                K type = types.iterator().next();
                OrderedSPI service = (OrderedSPI)this.singleTypeClassToService.get(type.getClass());
                return null == service ? Collections.emptyMap() : Collections.singletonMap(type, service);
            }
            Map result = this.multiObjectToServices.get(types);
            if (null == result) {
                result = this.multiObjectToServices.computeIfAbsent(types, t -> this.computeServicesByObject((Collection<Object>)t));
            }
            return result;
        }

        private Map<Object, T> computeServicesByObject(Collection<Object> types) {
            HashMap<Class, List> classTypeMap = new HashMap<Class, List>(types.size(), 1.0f);
            HashSet typeClasses = new HashSet(types.size(), 1.0f);
            for (Object each : types) {
                classTypeMap.computeIfAbsent(each.getClass(), clazz -> new LinkedList()).add(each);
                typeClasses.add(each.getClass());
            }
            LinkedHashMap result = new LinkedHashMap(types.size(), 1.0f);
            for (OrderedSPI each : this.orderedServices) {
                if (!typeClasses.contains(each.getTypeClass())) continue;
                for (Object type : (List)classTypeMap.get(each.getTypeClass())) {
                    result.put(type, each);
                }
            }
            return result;
        }
    }
}

