/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.spi;

import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.LinkedList;
import java.util.ServiceLoader;
import org.apache.shardingsphere.infra.spi.ShardingSphereSPI;
import org.apache.shardingsphere.infra.spi.annotation.SingletonSPI;

class RegisteredShardingSphereSPI<T extends ShardingSphereSPI> {
    private final Class<T> serviceInterface;
    private final Collection<T> services;

    RegisteredShardingSphereSPI(Class<T> serviceInterface) {
        this.serviceInterface = serviceInterface;
        this.validate();
        this.services = this.load();
    }

    private void validate() {
        Preconditions.checkNotNull(this.serviceInterface, (Object)"SPI interface is null.");
        Preconditions.checkArgument((boolean)this.serviceInterface.isInterface(), (String)"SPI `%s` is not an interface.", this.serviceInterface);
    }

    private Collection<T> load() {
        LinkedList<ShardingSphereSPI> result = new LinkedList<ShardingSphereSPI>();
        for (ShardingSphereSPI each : ServiceLoader.load(this.serviceInterface)) {
            result.add(each);
        }
        return result;
    }

    Collection<T> getServiceInstances() {
        return null == this.serviceInterface.getAnnotation(SingletonSPI.class) ? this.createNewServiceInstances() : this.getSingletonServiceInstances();
    }

    private Collection<T> createNewServiceInstances() {
        LinkedList<ShardingSphereSPI> result = new LinkedList<ShardingSphereSPI>();
        for (T each : this.services) {
            result.add((ShardingSphereSPI)each.getClass().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
        }
        return result;
    }

    private Collection<T> getSingletonServiceInstances() {
        return this.services;
    }
}

