/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sql.parser.engine.clickhouse.visitor.statement;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import lombok.Generated;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.misc.Interval;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.TerminalNode;
import org.apache.shardingsphere.database.connector.core.type.DatabaseType;
import org.apache.shardingsphere.sql.parser.api.ASTNode;
import org.apache.shardingsphere.sql.parser.autogen.ClickHouseStatementBaseVisitor;
import org.apache.shardingsphere.sql.parser.autogen.ClickHouseStatementParser;
import org.apache.shardingsphere.sql.parser.statement.core.enums.AggregationType;
import org.apache.shardingsphere.sql.parser.statement.core.enums.OrderDirection;
import org.apache.shardingsphere.sql.parser.statement.core.enums.ParameterMarkerType;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.column.ColumnSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.expr.BetweenExpression;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.expr.BinaryOperationExpression;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.expr.ExpressionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.expr.FunctionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.expr.InExpression;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.expr.IntervalExpression;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.expr.IntervalUnit;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.expr.ListExpression;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.expr.NotExpression;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.expr.complex.CommonExpressionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.expr.simple.LiteralExpressionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.expr.simple.ParameterMarkerExpressionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.expr.subquery.SubqueryExpressionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.expr.subquery.SubquerySegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.item.AggregationDistinctProjectionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.item.AggregationProjectionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.item.ExpressionProjectionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.order.OrderBySegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.order.item.ColumnOrderByItemSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.order.item.IndexOrderByItemSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.order.item.OrderByItemSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.generic.DataTypeLengthSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.generic.DataTypeSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.generic.OwnerSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.generic.ParameterMarkerSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.generic.table.SimpleTableSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.generic.table.TableNameSegment;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.dml.SelectStatement;
import org.apache.shardingsphere.sql.parser.statement.core.util.SQLUtils;
import org.apache.shardingsphere.sql.parser.statement.core.value.collection.CollectionValue;
import org.apache.shardingsphere.sql.parser.statement.core.value.identifier.IdentifierValue;
import org.apache.shardingsphere.sql.parser.statement.core.value.keyword.KeywordValue;
import org.apache.shardingsphere.sql.parser.statement.core.value.literal.impl.BooleanLiteralValue;
import org.apache.shardingsphere.sql.parser.statement.core.value.literal.impl.NullLiteralValue;
import org.apache.shardingsphere.sql.parser.statement.core.value.literal.impl.NumberLiteralValue;
import org.apache.shardingsphere.sql.parser.statement.core.value.literal.impl.OtherLiteralValue;
import org.apache.shardingsphere.sql.parser.statement.core.value.literal.impl.StringLiteralValue;
import org.apache.shardingsphere.sql.parser.statement.core.value.parametermarker.ParameterMarkerValue;

public abstract class ClickHouseStatementVisitor
extends ClickHouseStatementBaseVisitor<ASTNode> {
    private final DatabaseType databaseType;
    private final Collection<ParameterMarkerSegment> parameterMarkerSegments = new LinkedList<ParameterMarkerSegment>();

    @Override
    public final ASTNode visitParameterMarker(ClickHouseStatementParser.ParameterMarkerContext ctx) {
        return new ParameterMarkerValue(Integer.valueOf(this.parameterMarkerSegments.size()), ParameterMarkerType.QUESTION);
    }

    @Override
    public final ASTNode visitLiterals(ClickHouseStatementParser.LiteralsContext ctx) {
        if (null != ctx.stringLiterals()) {
            return (ASTNode)this.visit((ParseTree)ctx.stringLiterals());
        }
        if (null != ctx.numberLiterals()) {
            return (ASTNode)this.visit((ParseTree)ctx.numberLiterals());
        }
        if (null != ctx.hexadecimalLiterals()) {
            return (ASTNode)this.visit((ParseTree)ctx.hexadecimalLiterals());
        }
        if (null != ctx.bitValueLiterals()) {
            return (ASTNode)this.visit((ParseTree)ctx.bitValueLiterals());
        }
        if (null != ctx.booleanLiterals()) {
            return (ASTNode)this.visit((ParseTree)ctx.booleanLiterals());
        }
        if (null != ctx.nullValueLiterals()) {
            return (ASTNode)this.visit((ParseTree)ctx.nullValueLiterals());
        }
        throw new IllegalStateException("Literals must have string, number, dateTime, hex, bit, boolean or null.");
    }

    @Override
    public final ASTNode visitStringLiterals(ClickHouseStatementParser.StringLiteralsContext ctx) {
        return new StringLiteralValue(ctx.getText());
    }

    @Override
    public final ASTNode visitNumberLiterals(ClickHouseStatementParser.NumberLiteralsContext ctx) {
        return new NumberLiteralValue(ctx.getText());
    }

    @Override
    public final ASTNode visitHexadecimalLiterals(ClickHouseStatementParser.HexadecimalLiteralsContext ctx) {
        return new OtherLiteralValue(ctx.getText());
    }

    @Override
    public final ASTNode visitBitValueLiterals(ClickHouseStatementParser.BitValueLiteralsContext ctx) {
        return new OtherLiteralValue(ctx.getText());
    }

    @Override
    public final ASTNode visitBooleanLiterals(ClickHouseStatementParser.BooleanLiteralsContext ctx) {
        return new BooleanLiteralValue(ctx.getText());
    }

    @Override
    public final ASTNode visitNullValueLiterals(ClickHouseStatementParser.NullValueLiteralsContext ctx) {
        return new NullLiteralValue(ctx.getText());
    }

    @Override
    public final ASTNode visitIdentifier(ClickHouseStatementParser.IdentifierContext ctx) {
        ClickHouseStatementParser.UnreservedWordContext unreservedWord = ctx.unreservedWord();
        return null == unreservedWord ? new IdentifierValue(ctx.getText()) : (ASTNode)this.visit((ParseTree)unreservedWord);
    }

    @Override
    public final ASTNode visitUnreservedWord(ClickHouseStatementParser.UnreservedWordContext ctx) {
        return new IdentifierValue(ctx.getText());
    }

    @Override
    public final ASTNode visitSchemaName(ClickHouseStatementParser.SchemaNameContext ctx) {
        return (ASTNode)this.visit((ParseTree)ctx.identifier());
    }

    @Override
    public final ASTNode visitTableName(ClickHouseStatementParser.TableNameContext ctx) {
        SimpleTableSegment result = new SimpleTableSegment(new TableNameSegment(ctx.name().getStart().getStartIndex(), ctx.name().getStop().getStopIndex(), (IdentifierValue)this.visit((ParseTree)ctx.name())));
        ClickHouseStatementParser.OwnerContext owner = ctx.owner();
        if (null != owner) {
            result.setOwner(new OwnerSegment(owner.getStart().getStartIndex(), owner.getStop().getStopIndex(), (IdentifierValue)this.visit((ParseTree)owner.identifier())));
        }
        return result;
    }

    @Override
    public final ASTNode visitColumnName(ClickHouseStatementParser.ColumnNameContext ctx) {
        ColumnSegment result = new ColumnSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), (IdentifierValue)this.visit((ParseTree)ctx.name()));
        ClickHouseStatementParser.OwnerContext owner = ctx.owner();
        if (null != owner) {
            result.setOwner(new OwnerSegment(owner.getStart().getStartIndex(), owner.getStop().getStopIndex(), (IdentifierValue)this.visit((ParseTree)owner.identifier())));
        }
        return result;
    }

    @Override
    public final ASTNode visitTableNames(ClickHouseStatementParser.TableNamesContext ctx) {
        CollectionValue result = new CollectionValue();
        for (ClickHouseStatementParser.TableNameContext each : ctx.tableName()) {
            result.getValue().add((SimpleTableSegment)this.visit((ParseTree)each));
        }
        return result;
    }

    @Override
    public final ASTNode visitColumnNames(ClickHouseStatementParser.ColumnNamesContext ctx) {
        CollectionValue result = new CollectionValue();
        for (ClickHouseStatementParser.ColumnNameContext each : ctx.columnName()) {
            result.getValue().add((ColumnSegment)this.visit((ParseTree)each));
        }
        return result;
    }

    @Override
    public final ASTNode visitExpr(ClickHouseStatementParser.ExprContext ctx) {
        if (null != ctx.booleanPrimary()) {
            return (ASTNode)this.visit((ParseTree)ctx.booleanPrimary());
        }
        if (null != ctx.LP_()) {
            return (ASTNode)this.visit((ParseTree)ctx.expr(0));
        }
        if (null != ctx.andOperator()) {
            return this.createBinaryOperationExpression(ctx, ctx.andOperator().getText());
        }
        if (null != ctx.orOperator()) {
            return this.createBinaryOperationExpression(ctx, ctx.orOperator().getText());
        }
        return new NotExpression(ctx.start.getStartIndex(), ctx.stop.getStopIndex(), (ExpressionSegment)this.visit((ParseTree)ctx.expr(0)), Boolean.valueOf(false));
    }

    private ASTNode createBinaryOperationExpression(ClickHouseStatementParser.ExprContext ctx, String operator) {
        ExpressionSegment left = (ExpressionSegment)this.visit((ParseTree)ctx.expr(0));
        ExpressionSegment right = (ExpressionSegment)this.visit((ParseTree)ctx.expr(1));
        String text = ctx.start.getInputStream().getText(new Interval(ctx.start.getStartIndex(), ctx.stop.getStopIndex()));
        return new BinaryOperationExpression(ctx.start.getStartIndex(), ctx.stop.getStopIndex(), left, right, operator, text);
    }

    @Override
    public final ASTNode visitBooleanPrimary(ClickHouseStatementParser.BooleanPrimaryContext ctx) {
        if (null != ctx.IS()) {
            String rightText = "";
            if (null != ctx.NOT()) {
                rightText = rightText + ctx.start.getInputStream().getText(new Interval(ctx.NOT().getSymbol().getStartIndex(), ctx.NOT().getSymbol().getStopIndex())) + " ";
            }
            Token operatorToken = null;
            if (null != ctx.NULL()) {
                operatorToken = ctx.NULL().getSymbol();
            }
            if (null != ctx.TRUE()) {
                operatorToken = ctx.TRUE().getSymbol();
            }
            if (null != ctx.FALSE()) {
                operatorToken = ctx.FALSE().getSymbol();
            }
            int startIndex = null == operatorToken ? ctx.IS().getSymbol().getStopIndex() + 2 : operatorToken.getStartIndex();
            rightText = rightText + ctx.start.getInputStream().getText(new Interval(startIndex, ctx.stop.getStopIndex()));
            LiteralExpressionSegment right = new LiteralExpressionSegment(ctx.IS().getSymbol().getStopIndex() + 2, ctx.stop.getStopIndex(), (Object)rightText);
            String text = ctx.start.getInputStream().getText(new Interval(ctx.start.getStartIndex(), ctx.stop.getStopIndex()));
            ExpressionSegment left = (ExpressionSegment)this.visit((ParseTree)ctx.booleanPrimary());
            String operator = "IS";
            return new BinaryOperationExpression(ctx.start.getStartIndex(), ctx.stop.getStopIndex(), left, (ExpressionSegment)right, operator, text);
        }
        if (null != ctx.comparisonOperator() || null != ctx.SAFE_EQ_()) {
            return this.createCompareSegment(ctx);
        }
        return (ASTNode)this.visit((ParseTree)ctx.predicate());
    }

    private ASTNode createCompareSegment(ClickHouseStatementParser.BooleanPrimaryContext ctx) {
        ExpressionSegment left = (ExpressionSegment)this.visit((ParseTree)ctx.booleanPrimary());
        ExpressionSegment right = null != ctx.predicate() ? (ExpressionSegment)this.visit((ParseTree)ctx.predicate()) : (ExpressionSegment)this.visit((ParseTree)ctx.subquery());
        String operator = null == ctx.SAFE_EQ_() ? ctx.comparisonOperator().getText() : ctx.SAFE_EQ_().getText();
        String text = ctx.start.getInputStream().getText(new Interval(ctx.start.getStartIndex(), ctx.stop.getStopIndex()));
        return new BinaryOperationExpression(ctx.start.getStartIndex(), ctx.stop.getStopIndex(), left, right, operator, text);
    }

    @Override
    public final ASTNode visitPredicate(ClickHouseStatementParser.PredicateContext ctx) {
        if (null != ctx.IN()) {
            return this.createInSegment(ctx);
        }
        if (null != ctx.BETWEEN()) {
            return this.createBetweenSegment(ctx);
        }
        if (null != ctx.LIKE()) {
            return this.createBinaryOperationExpressionFromLike(ctx);
        }
        return (ASTNode)this.visit((ParseTree)ctx.bitExpr(0));
    }

    private BinaryOperationExpression createBinaryOperationExpressionFromLike(ClickHouseStatementParser.PredicateContext ctx) {
        ExpressionSegment left = (ExpressionSegment)this.visit((ParseTree)ctx.bitExpr(0));
        ListExpression right = new ListExpression(ctx.simpleExpr((int)0).start.getStartIndex(), ctx.simpleExpr().get((int)(ctx.simpleExpr().size() - 1)).stop.getStopIndex());
        for (ClickHouseStatementParser.SimpleExprContext each : ctx.simpleExpr()) {
            right.getItems().add((ExpressionSegment)this.visit((ParseTree)each));
        }
        String operator = null == ctx.NOT() ? "LIKE" : "NOT LIKE";
        String text = ctx.start.getInputStream().getText(new Interval(ctx.start.getStartIndex(), ctx.stop.getStopIndex()));
        return new BinaryOperationExpression(ctx.start.getStartIndex(), ctx.stop.getStopIndex(), left, (ExpressionSegment)right, operator, text);
    }

    private InExpression createInSegment(ClickHouseStatementParser.PredicateContext ctx) {
        ListExpression right;
        ExpressionSegment left = (ExpressionSegment)this.visit((ParseTree)ctx.bitExpr(0));
        if (null != ctx.subquery()) {
            right = new SubqueryExpressionSegment(new SubquerySegment(ctx.subquery().start.getStartIndex(), ctx.subquery().stop.getStopIndex(), (SelectStatement)this.visit((ParseTree)ctx.subquery()), this.getOriginalText(ctx.subquery())));
        } else {
            ListExpression listExpression = new ListExpression(ctx.LP_().getSymbol().getStartIndex(), ctx.RP_().getSymbol().getStopIndex());
            for (ClickHouseStatementParser.ExprContext each : ctx.expr()) {
                listExpression.getItems().add((ExpressionSegment)this.visit((ParseTree)each));
            }
            right = listExpression;
        }
        boolean not = null != ctx.NOT();
        return new InExpression(ctx.start.getStartIndex(), ctx.stop.getStopIndex(), left, (ExpressionSegment)right, not);
    }

    private BetweenExpression createBetweenSegment(ClickHouseStatementParser.PredicateContext ctx) {
        ExpressionSegment left = (ExpressionSegment)this.visit((ParseTree)ctx.bitExpr(0));
        ExpressionSegment between = (ExpressionSegment)this.visit((ParseTree)ctx.bitExpr(1));
        ExpressionSegment and = (ExpressionSegment)this.visit((ParseTree)ctx.predicate());
        return new BetweenExpression(ctx.start.getStartIndex(), ctx.stop.getStopIndex(), left, between, and, null != ctx.NOT());
    }

    @Override
    public final ASTNode visitBitExpr(ClickHouseStatementParser.BitExprContext ctx) {
        if (null != ctx.simpleExpr()) {
            return this.createExpressionSegment((ASTNode)this.visit((ParseTree)ctx.simpleExpr()), ctx);
        }
        ExpressionSegment left = (ExpressionSegment)this.visit(ctx.getChild(0));
        ExpressionSegment right = (ExpressionSegment)this.visit(ctx.getChild(2));
        String operator = ctx.getChild(1).getText();
        String text = ctx.start.getInputStream().getText(new Interval(ctx.start.getStartIndex(), ctx.stop.getStopIndex()));
        return new BinaryOperationExpression(ctx.start.getStartIndex(), ctx.stop.getStopIndex(), left, right, operator, text);
    }

    private ASTNode createExpressionSegment(ASTNode astNode, ParserRuleContext context) {
        if (astNode instanceof StringLiteralValue) {
            return new LiteralExpressionSegment(context.start.getStartIndex(), context.stop.getStopIndex(), (Object)((StringLiteralValue)astNode).getValue());
        }
        if (astNode instanceof NumberLiteralValue) {
            return new LiteralExpressionSegment(context.start.getStartIndex(), context.stop.getStopIndex(), (Object)((NumberLiteralValue)astNode).getValue());
        }
        if (astNode instanceof BooleanLiteralValue) {
            return new LiteralExpressionSegment(context.start.getStartIndex(), context.stop.getStopIndex(), (Object)((BooleanLiteralValue)astNode).getValue());
        }
        if (astNode instanceof ParameterMarkerValue) {
            ParameterMarkerValue parameterMarker = (ParameterMarkerValue)astNode;
            ParameterMarkerExpressionSegment segment = new ParameterMarkerExpressionSegment(context.start.getStartIndex(), context.stop.getStopIndex(), parameterMarker.getValue().intValue(), parameterMarker.getType());
            this.parameterMarkerSegments.add((ParameterMarkerSegment)segment);
            return segment;
        }
        if (astNode instanceof SubquerySegment) {
            return new SubqueryExpressionSegment((SubquerySegment)astNode);
        }
        if (astNode instanceof OtherLiteralValue) {
            return new CommonExpressionSegment(context.getStart().getStartIndex(), context.getStop().getStopIndex(), ((OtherLiteralValue)astNode).getValue());
        }
        return astNode;
    }

    @Override
    public final ASTNode visitSimpleExpr(ClickHouseStatementParser.SimpleExprContext ctx) {
        int startIndex = ctx.getStart().getStartIndex();
        int stopIndex = ctx.getStop().getStopIndex();
        if (null != ctx.subquery()) {
            return new SubquerySegment(startIndex, stopIndex, (SelectStatement)this.visit((ParseTree)ctx.subquery()), this.getOriginalText(ctx.subquery()));
        }
        if (null != ctx.parameterMarker()) {
            ParameterMarkerValue parameterMarker = (ParameterMarkerValue)this.visit((ParseTree)ctx.parameterMarker());
            ParameterMarkerExpressionSegment segment = new ParameterMarkerExpressionSegment(startIndex, stopIndex, parameterMarker.getValue().intValue(), parameterMarker.getType());
            this.parameterMarkerSegments.add((ParameterMarkerSegment)segment);
            return segment;
        }
        if (null != ctx.literals()) {
            return SQLUtils.createLiteralExpression((ASTNode)((ASTNode)this.visit((ParseTree)ctx.literals())), (int)startIndex, (int)stopIndex, (String)ctx.literals().start.getInputStream().getText(new Interval(startIndex, stopIndex)));
        }
        if (null != ctx.intervalExpression()) {
            return (ASTNode)this.visit((ParseTree)ctx.intervalExpression());
        }
        if (null != ctx.functionCall()) {
            return (ASTNode)this.visit((ParseTree)ctx.functionCall());
        }
        if (null != ctx.columnName()) {
            return (ASTNode)this.visit((ParseTree)ctx.columnName());
        }
        return new CommonExpressionSegment(startIndex, stopIndex, ctx.getText());
    }

    @Override
    public final ASTNode visitIntervalExpression(ClickHouseStatementParser.IntervalExpressionContext ctx) {
        IntervalUnit intervalUnit = IntervalUnit.valueOf((String)ctx.intervalUnit().getText().toUpperCase());
        return new IntervalExpression(ctx.INTERVAL().getSymbol().getStartIndex(), ctx.getStop().getStopIndex(), (ExpressionSegment)this.visit((ParseTree)ctx.expr()), intervalUnit, this.getOriginalText(ctx));
    }

    @Override
    public final ASTNode visitFunctionCall(ClickHouseStatementParser.FunctionCallContext ctx) {
        if (null != ctx.aggregationFunction()) {
            return (ASTNode)this.visit((ParseTree)ctx.aggregationFunction());
        }
        if (null != ctx.specialFunction()) {
            return (ASTNode)this.visit((ParseTree)ctx.specialFunction());
        }
        if (null != ctx.regularFunction()) {
            return (ASTNode)this.visit((ParseTree)ctx.regularFunction());
        }
        throw new IllegalStateException("FunctionCallContext must have aggregationFunction, regularFunction or specialFunction.");
    }

    @Override
    public final ASTNode visitAggregationFunction(ClickHouseStatementParser.AggregationFunctionContext ctx) {
        String aggregationType = ctx.aggregationFunctionName().getText();
        return AggregationType.isAggregationType((String)aggregationType) ? this.createAggregationSegment(ctx, aggregationType) : new ExpressionProjectionSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), this.getOriginalText(ctx));
    }

    private ASTNode createAggregationSegment(ClickHouseStatementParser.AggregationFunctionContext ctx, String aggregationType) {
        AggregationType type = AggregationType.valueOf((String)aggregationType.toUpperCase());
        if (null != ctx.distinct()) {
            AggregationDistinctProjectionSegment result = new AggregationDistinctProjectionSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), type, this.getOriginalText(ctx), this.getDistinctExpression(ctx));
            result.getParameters().addAll(this.getExpressions(ctx));
            return result;
        }
        AggregationProjectionSegment result = new AggregationProjectionSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), type, this.getOriginalText(ctx));
        result.getParameters().addAll(this.getExpressions(ctx));
        return result;
    }

    private Collection<ExpressionSegment> getExpressions(ClickHouseStatementParser.AggregationFunctionContext ctx) {
        return null == ctx.expr() ? Collections.emptyList() : (Collection)ctx.expr().stream().map(each -> (ExpressionSegment)this.visit((ParseTree)each)).collect(Collectors.toList());
    }

    private String getDistinctExpression(ClickHouseStatementParser.AggregationFunctionContext ctx) {
        return IntStream.range(3, ctx.getChildCount() - 1).mapToObj(i -> ctx.getChild(i).getText()).collect(Collectors.joining());
    }

    @Override
    public final ASTNode visitSpecialFunction(ClickHouseStatementParser.SpecialFunctionContext ctx) {
        return null != ctx.castFunction() ? (ASTNode)this.visit((ParseTree)ctx.castFunction()) : new FunctionSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), ctx.getChild(0).getChild(0).getText(), this.getOriginalText(ctx));
    }

    @Override
    public final ASTNode visitCastFunction(ClickHouseStatementParser.CastFunctionContext ctx) {
        FunctionSegment result = new FunctionSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), ctx.CAST().getText(), this.getOriginalText(ctx));
        ASTNode exprSegment = (ASTNode)this.visit((ParseTree)ctx.expr());
        if (exprSegment instanceof ColumnSegment) {
            result.getParameters().add((ColumnSegment)exprSegment);
        } else if (exprSegment instanceof LiteralExpressionSegment) {
            result.getParameters().add((LiteralExpressionSegment)exprSegment);
        }
        result.getParameters().add((DataTypeSegment)this.visit((ParseTree)ctx.dataType()));
        return result;
    }

    @Override
    public final ASTNode visitRegularFunction(ClickHouseStatementParser.RegularFunctionContext ctx) {
        FunctionSegment result = new FunctionSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), ctx.regularFunctionName().getText(), this.getOriginalText(ctx));
        result.getParameters().addAll(ctx.expr().stream().map(each -> (ExpressionSegment)this.visit((ParseTree)each)).collect(Collectors.toList()));
        return result;
    }

    @Override
    public final ASTNode visitDataTypeName(ClickHouseStatementParser.DataTypeNameContext ctx) {
        return new KeywordValue(IntStream.range(0, ctx.getChildCount()).mapToObj(i -> ctx.getChild(i).getText()).collect(Collectors.joining(" ")));
    }

    @Override
    public final ASTNode visitOrderByClause(ClickHouseStatementParser.OrderByClauseContext ctx) {
        return new OrderBySegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), (Collection)ctx.orderByItem().stream().map(each -> (OrderByItemSegment)this.visit((ParseTree)each)).collect(Collectors.toList()));
    }

    @Override
    public final ASTNode visitOrderByItem(ClickHouseStatementParser.OrderByItemContext ctx) {
        OrderDirection orderDirection;
        OrderDirection orderDirection2 = orderDirection = null == ctx.DESC() ? OrderDirection.ASC : OrderDirection.DESC;
        if (null != ctx.columnName()) {
            return new ColumnOrderByItemSegment((ColumnSegment)this.visit((ParseTree)ctx.columnName()), orderDirection, null);
        }
        return new IndexOrderByItemSegment(ctx.numberLiterals().getStart().getStartIndex(), ctx.numberLiterals().getStop().getStopIndex(), SQLUtils.getExactlyNumber((String)ctx.numberLiterals().getText(), (int)10).intValue(), orderDirection, null);
    }

    @Override
    public final ASTNode visitDataType(ClickHouseStatementParser.DataTypeContext ctx) {
        DataTypeSegment result = new DataTypeSegment();
        result.setDataTypeName(((KeywordValue)this.visit((ParseTree)ctx.dataTypeName())).getValue());
        result.setStartIndex(ctx.start.getStartIndex());
        result.setStopIndex(ctx.stop.getStopIndex());
        if (null != ctx.dataTypeLength()) {
            result.setDataLength((DataTypeLengthSegment)this.visit((ParseTree)ctx.dataTypeLength()));
        }
        return result;
    }

    @Override
    public final ASTNode visitDataTypeLength(ClickHouseStatementParser.DataTypeLengthContext ctx) {
        DataTypeLengthSegment result = new DataTypeLengthSegment();
        result.setStartIndex(ctx.start.getStartIndex());
        result.setStopIndex(ctx.stop.getStartIndex());
        List<TerminalNode> numbers = ctx.NUMBER_();
        if (1 == numbers.size()) {
            result.setPrecision(Integer.parseInt(numbers.get(0).getText()));
        }
        if (2 == numbers.size()) {
            result.setPrecision(Integer.parseInt(numbers.get(0).getText()));
            result.setScale(Integer.parseInt(numbers.get(1).getText()));
        }
        return result;
    }

    protected String getOriginalText(ParserRuleContext ctx) {
        return ctx.start.getInputStream().getText(new Interval(ctx.start.getStartIndex(), ctx.stop.getStopIndex()));
    }

    @Generated
    public ClickHouseStatementVisitor(DatabaseType databaseType) {
        this.databaseType = databaseType;
    }

    @Generated
    protected DatabaseType getDatabaseType() {
        return this.databaseType;
    }

    @Generated
    protected Collection<ParameterMarkerSegment> getParameterMarkerSegments() {
        return this.parameterMarkerSegments;
    }
}

