/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.mode.repository.cluster.core.lock;

import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import lombok.Generated;
import org.apache.shardingsphere.mode.repository.cluster.ClusterPersistRepository;
import org.apache.shardingsphere.mode.repository.cluster.core.lock.type.DefaultDistributedLock;
import org.apache.shardingsphere.mode.repository.cluster.core.lock.type.props.DefaultLockTypedProperties;
import org.apache.shardingsphere.mode.repository.cluster.lock.DistributedLock;

public final class DistributedLockHolder {
    private static final Map<String, DistributedLock> LOCKS = new ConcurrentHashMap<String, DistributedLock>();

    public static DistributedLock getDistributedLock(String lockKey, ClusterPersistRepository repository) {
        return LOCKS.computeIfAbsent(lockKey, key -> DistributedLockHolder.loadDistributedLock(lockKey, repository));
    }

    private static DistributedLock loadDistributedLock(String lockKey, ClusterPersistRepository repository) {
        return repository.getDistributedLock(lockKey).orElseGet(() -> new DefaultDistributedLock(lockKey, repository, new DefaultLockTypedProperties(new Properties())));
    }

    @Generated
    private DistributedLockHolder() {
    }
}

