/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sqlfederation.executor.enumerable.implementor;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.calcite.linq4j.AbstractEnumerable;
import org.apache.calcite.linq4j.Enumerable;
import org.apache.calcite.linq4j.Enumerator;
import org.apache.shardingsphere.database.connector.core.metadata.database.metadata.option.table.DialectDriverQuerySystemCatalogOption;
import org.apache.shardingsphere.database.connector.core.metadata.database.system.SystemDatabase;
import org.apache.shardingsphere.database.connector.core.type.DatabaseType;
import org.apache.shardingsphere.database.connector.core.type.DatabaseTypeRegistry;
import org.apache.shardingsphere.infra.binder.context.statement.SQLStatementContext;
import org.apache.shardingsphere.infra.binder.engine.SQLBindEngine;
import org.apache.shardingsphere.infra.connection.kernel.KernelProcessor;
import org.apache.shardingsphere.infra.exception.ShardingSpherePreconditions;
import org.apache.shardingsphere.infra.exception.kernel.connection.SQLExecutionInterruptedException;
import org.apache.shardingsphere.infra.executor.kernel.model.ExecutionGroup;
import org.apache.shardingsphere.infra.executor.kernel.model.ExecutionGroupContext;
import org.apache.shardingsphere.infra.executor.kernel.model.ExecutionGroupReportContext;
import org.apache.shardingsphere.infra.executor.sql.context.ExecutionContext;
import org.apache.shardingsphere.infra.executor.sql.context.ExecutionUnit;
import org.apache.shardingsphere.infra.executor.sql.execute.engine.driver.jdbc.JDBCExecutionUnit;
import org.apache.shardingsphere.infra.executor.sql.execute.result.query.QueryResult;
import org.apache.shardingsphere.infra.executor.sql.process.ProcessEngine;
import org.apache.shardingsphere.infra.executor.sql.process.ProcessRegistry;
import org.apache.shardingsphere.infra.hint.HintValueContext;
import org.apache.shardingsphere.infra.merge.MergeEngine;
import org.apache.shardingsphere.infra.merge.result.MergedResult;
import org.apache.shardingsphere.infra.metadata.ShardingSphereMetaData;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.infra.metadata.database.schema.model.ShardingSphereTable;
import org.apache.shardingsphere.infra.metadata.statistics.TableStatistics;
import org.apache.shardingsphere.infra.session.query.QueryContext;
import org.apache.shardingsphere.sql.parser.statement.core.statement.SQLStatement;
import org.apache.shardingsphere.sqlfederation.compiler.context.CompilerContext;
import org.apache.shardingsphere.sqlfederation.compiler.implementor.ScanImplementor;
import org.apache.shardingsphere.sqlfederation.compiler.implementor.ScanImplementorContext;
import org.apache.shardingsphere.sqlfederation.compiler.implementor.enumerator.EmptyDataRowEnumerator;
import org.apache.shardingsphere.sqlfederation.executor.context.ExecutorContext;
import org.apache.shardingsphere.sqlfederation.executor.enumerable.enumerator.jdbc.JDBCDataRowEnumerator;
import org.apache.shardingsphere.sqlfederation.executor.enumerable.enumerator.memory.MemoryDataRowEnumerator;
import org.apache.shardingsphere.sqlfederation.executor.enumerable.enumerator.memory.MemoryTableStatisticsBuilder;

public final class EnumerableScanImplementor
implements ScanImplementor {
    private final QueryContext queryContext;
    private final CompilerContext compilerContext;
    private final ExecutorContext executorContext;
    private final ProcessEngine processEngine = new ProcessEngine();

    public Enumerable<Object> implement(ShardingSphereTable table, ScanImplementorContext scanContext) {
        SQLStatementContext sqlStatementContext = this.queryContext.getSqlStatementContext();
        DatabaseType databaseType = sqlStatementContext.getSqlStatement().getDatabaseType();
        Collection systemSchemas = new SystemDatabase(databaseType).getSystemSchemas();
        if (sqlStatementContext.getTablesContext().getSchemaNames().stream().anyMatch(systemSchemas::contains)) {
            return this.createMemoryEnumerable(sqlStatementContext, databaseType, table);
        }
        QueryContext scanQueryContext = this.createQueryContext(this.queryContext.getMetaData(), scanContext, databaseType, this.queryContext.isUseCache());
        ExecutionContext executionContext = new KernelProcessor().generateExecutionContext(scanQueryContext, this.queryContext.getMetaData().getGlobalRuleMetaData(), this.queryContext.getMetaData().getProps());
        if (this.executorContext.isPreview()) {
            this.executorContext.getPreviewExecutionUnits().addAll(executionContext.getExecutionUnits());
            return this.createEmptyEnumerable();
        }
        return this.createJDBCEnumerable(scanQueryContext, this.queryContext.getMetaData().getDatabase(this.executorContext.getCurrentDatabaseName()), executionContext);
    }

    private Enumerable<Object> createMemoryEnumerable(SQLStatementContext sqlStatementContext, DatabaseType databaseType, ShardingSphereTable table) {
        Optional driverQuerySystemCatalogOption = new DatabaseTypeRegistry(databaseType).getDialectDatabaseMetaData().getDriverQuerySystemCatalogOption();
        if (driverQuerySystemCatalogOption.isPresent() && ((DialectDriverQuerySystemCatalogOption)driverQuerySystemCatalogOption.get()).isSystemTable(table.getName())) {
            return this.createMemoryEnumerator(MemoryTableStatisticsBuilder.buildTableStatistics(table, this.queryContext.getMetaData(), (DialectDriverQuerySystemCatalogOption)driverQuerySystemCatalogOption.get()), table, databaseType);
        }
        String databaseName = sqlStatementContext.getTablesContext().getDatabaseName().orElse(this.executorContext.getCurrentDatabaseName());
        String schemaName = sqlStatementContext.getTablesContext().getSchemaName().orElse(this.executorContext.getCurrentSchemaName());
        Optional<TableStatistics> tableStatistics = Optional.ofNullable(this.executorContext.getStatistics().getDatabaseStatistics(databaseName)).map(optional -> optional.getSchemaStatistics(schemaName)).map(optional -> optional.getTableStatistics(table.getName()));
        return tableStatistics.map(optional -> this.createMemoryEnumerator((TableStatistics)optional, table, databaseType)).orElseGet(this::createEmptyEnumerable);
    }

    private Enumerable<Object> createMemoryEnumerator(final TableStatistics tableStatistics, final ShardingSphereTable table, final DatabaseType databaseType) {
        return new AbstractEnumerable<Object>(){

            public Enumerator<Object> enumerator() {
                return new MemoryDataRowEnumerator(tableStatistics.getRows(), table.getAllColumns(), databaseType);
            }
        };
    }

    private QueryContext createQueryContext(ShardingSphereMetaData metaData, ScanImplementorContext sqlString, DatabaseType databaseType, boolean useCache) {
        String sql = sqlString.getSql().replace(System.lineSeparator(), " ");
        SQLStatement sqlStatement = this.compilerContext.getSqlParserRule().getSQLParserEngine(databaseType).parse(sql, useCache);
        HintValueContext hintValueContext = new HintValueContext();
        SQLStatementContext sqlStatementContext = new SQLBindEngine(metaData, this.executorContext.getCurrentDatabaseName(), hintValueContext).bind(sqlStatement);
        return new QueryContext(sqlStatementContext, sql, this.getParameters(sqlString.getParamIndexes()), hintValueContext, this.queryContext.getConnectionContext(), metaData, useCache);
    }

    private List<Object> getParameters(int[] paramIndexes) {
        return null == paramIndexes ? Collections.emptyList() : (List)Arrays.stream(paramIndexes).mapToObj(each -> this.queryContext.getParameters().get(each)).collect(Collectors.toCollection(() -> new ArrayList(paramIndexes.length)));
    }

    private AbstractEnumerable<Object> createEmptyEnumerable() {
        return new AbstractEnumerable<Object>(){

            public Enumerator<Object> enumerator() {
                return new EmptyDataRowEnumerator();
            }
        };
    }

    private AbstractEnumerable<Object> createJDBCEnumerable(final QueryContext queryContext, final ShardingSphereDatabase database, final ExecutionContext executionContext) {
        return new AbstractEnumerable<Object>(){

            public Enumerator<Object> enumerator() {
                EnumerableScanImplementor.this.computeConnectionOffsets(executionContext);
                ExecutionGroupContext executionGroupContext = EnumerableScanImplementor.this.prepare(database, executionContext);
                EnumerableScanImplementor.this.setParameters(executionGroupContext.getInputGroups());
                ShardingSpherePreconditions.checkState((!ProcessRegistry.getInstance().get(EnumerableScanImplementor.this.executorContext.getProcessId()).isInterrupted() ? 1 : 0) != 0, SQLExecutionInterruptedException::new);
                EnumerableScanImplementor.this.processEngine.executeSQL(executionGroupContext, queryContext);
                List queryResults = EnumerableScanImplementor.this.executorContext.getJdbcExecutor().execute(executionGroupContext, EnumerableScanImplementor.this.executorContext.getQueryCallback()).stream().map(QueryResult.class::cast).collect(Collectors.toList());
                MergeEngine mergeEngine = new MergeEngine(queryContext.getMetaData(), database, queryContext.getMetaData().getProps(), queryContext.getConnectionContext());
                MergedResult mergedResult = mergeEngine.merge(queryResults, queryContext);
                Collection statements = EnumerableScanImplementor.this.getStatements(executionGroupContext.getInputGroups());
                return new JDBCDataRowEnumerator(mergedResult, ((QueryResult)queryResults.get(0)).getMetaData(), statements);
            }
        };
    }

    private void computeConnectionOffsets(ExecutionContext context) {
        for (ExecutionUnit each : context.getExecutionUnits()) {
            int connectionOffset = this.executorContext.getConnectionOffsets().containsKey(each.getDataSourceName()) ? this.executorContext.getConnectionOffsets().get(each.getDataSourceName()) + 1 : 0;
            this.executorContext.getConnectionOffsets().put(each.getDataSourceName(), connectionOffset);
        }
    }

    private ExecutionGroupContext<JDBCExecutionUnit> prepare(ShardingSphereDatabase database, ExecutionContext executionContext) throws SQLException {
        return this.executorContext.getPrepareEngine().prepare(database.getName(), executionContext, this.executorContext.getConnectionOffsets(), executionContext.getExecutionUnits(), new ExecutionGroupReportContext(this.executorContext.getProcessId(), database.getName()));
    }

    private Collection<Statement> getStatements(Collection<ExecutionGroup<JDBCExecutionUnit>> inputGroups) {
        LinkedList<Statement> result = new LinkedList<Statement>();
        for (ExecutionGroup<JDBCExecutionUnit> each : inputGroups) {
            for (JDBCExecutionUnit executionUnit : each.getInputs()) {
                result.add(executionUnit.getStorageResource());
            }
        }
        return result;
    }

    private void setParameters(Collection<ExecutionGroup<JDBCExecutionUnit>> inputGroups) {
        for (ExecutionGroup<JDBCExecutionUnit> each : inputGroups) {
            for (JDBCExecutionUnit executionUnit : each.getInputs()) {
                if (!(executionUnit.getStorageResource() instanceof PreparedStatement)) continue;
                this.setParameters((PreparedStatement)executionUnit.getStorageResource(), executionUnit.getExecutionUnit().getSqlUnit().getParameters());
            }
        }
    }

    private void setParameters(PreparedStatement preparedStatement, List<Object> params) {
        for (int i = 0; i < params.size(); ++i) {
            preparedStatement.setObject(i + 1, params.get(i));
        }
    }

    @Generated
    public EnumerableScanImplementor(QueryContext queryContext, CompilerContext compilerContext, ExecutorContext executorContext) {
        this.queryContext = queryContext;
        this.compilerContext = compilerContext;
        this.executorContext = executorContext;
    }
}

