/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sqlfederation.executor.enumerable.enumerator.memory;

import java.sql.SQLFeatureNotSupportedException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import org.apache.shardingsphere.database.connector.core.type.DatabaseType;
import org.apache.shardingsphere.infra.exception.kernel.data.UnsupportedDataTypeConversionException;
import org.apache.shardingsphere.infra.executor.sql.execute.result.query.impl.driver.jdbc.type.util.ResultSetUtils;
import org.apache.shardingsphere.infra.metadata.database.schema.model.ShardingSphereColumn;
import org.apache.shardingsphere.sqlfederation.compiler.sql.type.SQLFederationDataTypeBuilder;

public final class MemoryDataTypeConverter {
    public static Map<Integer, Class<?>> createColumnTypes(List<ShardingSphereColumn> columns, DatabaseType databaseType) {
        HashMap result = new HashMap(columns.size(), 1.0f);
        for (int index = 0; index < columns.size(); ++index) {
            int finalIndex = index;
            MemoryDataTypeConverter.getSQLTypeClass(columns, databaseType, index).ifPresent(optional -> result.put(finalIndex, (Class<?>)optional));
        }
        return result;
    }

    private static Optional<Class<?>> getSQLTypeClass(List<ShardingSphereColumn> columns, DatabaseType databaseType, int index) {
        try {
            return Optional.of(SQLFederationDataTypeBuilder.getSqlTypeClass((DatabaseType)databaseType, (ShardingSphereColumn)columns.get(index)));
        }
        catch (IllegalArgumentException ex) {
            return Optional.empty();
        }
    }

    public static Object[] convertToTargetType(Map<Integer, Class<?>> columnTypes, Object[] rows) {
        Object[] result = new Object[rows.length];
        for (int index = 0; index < rows.length; ++index) {
            if (!columnTypes.containsKey(index)) continue;
            result[index] = MemoryDataTypeConverter.convertValue(rows, columnTypes, index);
        }
        return result;
    }

    private static Object convertValue(Object[] rows, Map<Integer, Class<?>> columnTypes, int index) {
        try {
            return ResultSetUtils.convertValue((Object)rows[index], columnTypes.get(index));
        }
        catch (SQLFeatureNotSupportedException | UnsupportedDataTypeConversionException ex) {
            return rows[index];
        }
    }

    @Generated
    private MemoryDataTypeConverter() {
    }
}

