/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sqlfederation.executor.enumerable.enumerator.memory;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import org.apache.calcite.linq4j.Enumerator;
import org.apache.shardingsphere.database.connector.core.type.DatabaseType;
import org.apache.shardingsphere.infra.metadata.database.schema.model.ShardingSphereColumn;
import org.apache.shardingsphere.infra.metadata.statistics.RowStatistics;
import org.apache.shardingsphere.sqlfederation.executor.enumerable.enumerator.memory.MemoryDataTypeConverter;

public final class MemoryDataRowEnumerator
implements Enumerator<Object> {
    private final Collection<RowStatistics> rows;
    private final Map<Integer, Class<?>> columnTypes;
    private Iterator<RowStatistics> iterator;
    private Object current;

    public MemoryDataRowEnumerator(Collection<RowStatistics> rows, Collection<ShardingSphereColumn> columns, DatabaseType databaseType) {
        this.rows = rows;
        this.columnTypes = MemoryDataTypeConverter.createColumnTypes(new ArrayList<ShardingSphereColumn>(columns), databaseType);
        this.iterator = rows.iterator();
    }

    public Object current() {
        return this.current;
    }

    public boolean moveNext() {
        if (this.iterator.hasNext()) {
            this.current = MemoryDataTypeConverter.convertToTargetType(this.columnTypes, this.iterator.next().getRows().toArray());
            return true;
        }
        this.current = null;
        this.iterator = this.rows.iterator();
        return false;
    }

    public void reset() {
    }

    public void close() {
        this.iterator = this.rows.iterator();
        this.current = null;
    }
}

