/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.mask.merge.dql;

import java.sql.SQLException;
import java.util.Optional;
import org.apache.shardingsphere.infra.binder.context.statement.type.dml.SelectStatementContext;
import org.apache.shardingsphere.infra.merge.result.MergedResult;
import org.apache.shardingsphere.infra.merge.result.impl.decorator.DecoratorMergedResult;
import org.apache.shardingsphere.infra.metadata.ShardingSphereMetaData;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.mask.rule.MaskRule;
import org.apache.shardingsphere.mask.spi.MaskAlgorithm;
import org.apache.shardingsphere.sql.parser.statement.core.segment.generic.bound.ColumnSegmentBoundInfo;

public final class MaskMergedResult
extends DecoratorMergedResult {
    private final ShardingSphereDatabase database;
    private final ShardingSphereMetaData metaData;
    private final SelectStatementContext selectStatementContext;

    public MaskMergedResult(ShardingSphereDatabase database, ShardingSphereMetaData metaData, SelectStatementContext selectStatementContext, MergedResult mergedResult) {
        super(mergedResult);
        this.database = database;
        this.metaData = metaData;
        this.selectStatementContext = selectStatementContext;
    }

    public Object getValue(int columnIndex, Class<?> type) throws SQLException {
        Optional columnSegmentBoundInfo = this.selectStatementContext.findColumnBoundInfo(columnIndex);
        if (!columnSegmentBoundInfo.isPresent()) {
            return this.getMergedResult().getValue(columnIndex, type);
        }
        String originalTableName = ((ColumnSegmentBoundInfo)columnSegmentBoundInfo.get()).getOriginalTable().getValue();
        String originalColumnName = ((ColumnSegmentBoundInfo)columnSegmentBoundInfo.get()).getOriginalColumn().getValue();
        ShardingSphereDatabase database = this.metaData.containsDatabase(((ColumnSegmentBoundInfo)columnSegmentBoundInfo.get()).getOriginalDatabase().getValue()) ? this.metaData.getDatabase(((ColumnSegmentBoundInfo)columnSegmentBoundInfo.get()).getOriginalDatabase().getValue()) : this.database;
        Optional rule = database.getRuleMetaData().findSingleRule(MaskRule.class);
        if (!rule.isPresent() || !((MaskRule)rule.get()).findMaskTable(originalTableName).map(optional -> optional.findAlgorithm(originalColumnName).isPresent()).orElse(false).booleanValue()) {
            return this.getMergedResult().getValue(columnIndex, type);
        }
        Optional maskAlgorithm = ((MaskRule)rule.get()).findMaskTable(originalTableName).flatMap(optional -> optional.findAlgorithm(originalColumnName));
        if (!maskAlgorithm.isPresent()) {
            return this.getMergedResult().getValue(columnIndex, type);
        }
        Object originalValue = this.getMergedResult().getValue(columnIndex, Object.class);
        return null == originalValue ? null : ((MaskAlgorithm)maskAlgorithm.get()).mask(originalValue);
    }
}

