/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.mask.algorithm.cover;

import com.google.common.base.Strings;
import java.util.Properties;
import org.apache.shardingsphere.mask.algorithm.MaskAlgorithmPropertiesChecker;
import org.apache.shardingsphere.mask.spi.MaskAlgorithm;

public final class MaskFirstNLastMMaskAlgorithm
implements MaskAlgorithm<Object, String> {
    private static final String FIRST_N = "first-n";
    private static final String LAST_M = "last-m";
    private static final String REPLACE_CHAR = "replace-char";
    private Integer firstN;
    private Integer lastM;
    private Character replaceChar;

    public void init(Properties props) {
        this.firstN = this.createFirstN(props);
        this.lastM = this.createLastM(props);
        this.replaceChar = this.createReplaceChar(props);
    }

    private Integer createFirstN(Properties props) {
        MaskAlgorithmPropertiesChecker.checkPositiveInteger(props, FIRST_N, this);
        return Integer.parseInt(props.getProperty(FIRST_N));
    }

    private Integer createLastM(Properties props) {
        MaskAlgorithmPropertiesChecker.checkPositiveInteger(props, LAST_M, this);
        return Integer.parseInt(props.getProperty(LAST_M));
    }

    private Character createReplaceChar(Properties props) {
        MaskAlgorithmPropertiesChecker.checkSingleChar(props, REPLACE_CHAR, this);
        return Character.valueOf(props.getProperty(REPLACE_CHAR).charAt(0));
    }

    public String mask(Object plainValue) {
        int i;
        String result;
        String string = result = null == plainValue ? null : String.valueOf(plainValue);
        if (Strings.isNullOrEmpty((String)result)) {
            return result;
        }
        char[] chars = result.toCharArray();
        int len = Math.min(this.firstN, chars.length);
        for (i = 0; i < len; ++i) {
            chars[i] = this.replaceChar.charValue();
        }
        for (i = chars.length - Math.min(this.lastM, chars.length); i < chars.length; ++i) {
            chars[i] = this.replaceChar.charValue();
        }
        return new String(chars);
    }

    public String getType() {
        return "MASK_FIRST_N_LAST_M";
    }
}

