/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.mask.algorithm.cover;

import com.google.common.base.Strings;
import java.util.Properties;
import org.apache.shardingsphere.mask.algorithm.MaskAlgorithmPropertiesChecker;
import org.apache.shardingsphere.mask.spi.MaskAlgorithm;

public final class KeepFirstNLastMMaskAlgorithm
implements MaskAlgorithm<Object, String> {
    private static final String FIRST_N = "first-n";
    private static final String LAST_M = "last-m";
    private static final String REPLACE_CHAR = "replace-char";
    private Integer firstN;
    private Integer lastM;
    private Character replaceChar;

    public void init(Properties props) {
        this.firstN = this.createFirstN(props);
        this.lastM = this.createLastM(props);
        this.replaceChar = this.createReplaceChar(props);
    }

    private Integer createFirstN(Properties props) {
        MaskAlgorithmPropertiesChecker.checkPositiveInteger(props, FIRST_N, this);
        return Integer.parseInt(props.getProperty(FIRST_N));
    }

    private Integer createLastM(Properties props) {
        MaskAlgorithmPropertiesChecker.checkPositiveInteger(props, LAST_M, this);
        return Integer.parseInt(props.getProperty(LAST_M));
    }

    private Character createReplaceChar(Properties props) {
        MaskAlgorithmPropertiesChecker.checkSingleChar(props, REPLACE_CHAR, this);
        return Character.valueOf(props.getProperty(REPLACE_CHAR).charAt(0));
    }

    public String mask(Object plainValue) {
        String result;
        String string = result = null == plainValue ? null : String.valueOf(plainValue);
        if (Strings.isNullOrEmpty((String)result)) {
            return result;
        }
        if (result.length() < this.firstN + this.lastM) {
            return result;
        }
        char[] chars = result.toCharArray();
        for (int i = this.firstN.intValue(); i < result.length() - this.lastM; ++i) {
            chars[i] = this.replaceChar.charValue();
        }
        return new String(chars);
    }

    public String getType() {
        return "KEEP_FIRST_N_LAST_M";
    }
}

