/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.rewrite.sql.token.keygen.generator;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.apache.shardingsphere.infra.binder.context.segment.insert.keygen.GeneratedKeyContext;
import org.apache.shardingsphere.infra.binder.context.statement.type.dml.InsertStatementContext;
import org.apache.shardingsphere.infra.rewrite.sql.token.common.pojo.generic.UseDefaultInsertColumnsToken;
import org.apache.shardingsphere.infra.rewrite.sql.token.keygen.generator.BaseGeneratedKeyTokenGenerator;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.column.InsertColumnsSegment;

public final class GeneratedKeyForUseDefaultInsertColumnsTokenGenerator
extends BaseGeneratedKeyTokenGenerator {
    @Override
    protected boolean isGenerateSQLToken(InsertStatementContext insertStatementContext) {
        return !insertStatementContext.containsInsertColumns();
    }

    public UseDefaultInsertColumnsToken generateSQLToken(InsertStatementContext insertStatementContext) {
        Optional insertColumnsSegment = insertStatementContext.getSqlStatement().getInsertColumns();
        Preconditions.checkState((boolean)insertColumnsSegment.isPresent());
        return new UseDefaultInsertColumnsToken(((InsertColumnsSegment)insertColumnsSegment.get()).getStopIndex(), this.getColumnNames(insertStatementContext));
    }

    private List<String> getColumnNames(InsertStatementContext insertStatementContext) {
        Optional generatedKey = insertStatementContext.getGeneratedKeyContext();
        Preconditions.checkState((boolean)generatedKey.isPresent());
        ArrayList<String> result = new ArrayList<String>(insertStatementContext.getColumnNames());
        result.remove(((GeneratedKeyContext)generatedKey.get()).getColumnName());
        result.add(((GeneratedKeyContext)generatedKey.get()).getColumnName());
        return result;
    }
}

