/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.rewrite.sql.token.common.pojo.generic;

import com.cedarsoftware.util.CaseInsensitiveMap;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import lombok.Generated;
import org.apache.shardingsphere.database.connector.core.metadata.database.enums.QuoteCharacter;
import org.apache.shardingsphere.database.connector.core.type.DatabaseType;
import org.apache.shardingsphere.database.connector.core.type.DatabaseTypeRegistry;
import org.apache.shardingsphere.infra.binder.context.segment.select.projection.Projection;
import org.apache.shardingsphere.infra.binder.context.segment.select.projection.impl.ColumnProjection;
import org.apache.shardingsphere.infra.rewrite.sql.token.common.pojo.RouteUnitAware;
import org.apache.shardingsphere.infra.rewrite.sql.token.common.pojo.SQLToken;
import org.apache.shardingsphere.infra.rewrite.sql.token.common.pojo.Substitutable;
import org.apache.shardingsphere.infra.route.context.RouteMapper;
import org.apache.shardingsphere.infra.route.context.RouteUnit;
import org.apache.shardingsphere.sql.parser.statement.core.value.identifier.IdentifierValue;

public final class SubstitutableColumnNameToken
extends SQLToken
implements Substitutable,
RouteUnitAware {
    private static final String COLUMN_NAME_SPLITTER = ", ";
    private final int stopIndex;
    private final Collection<Projection> projections;
    private final QuoteCharacter quoteCharacter;
    private final DatabaseType databaseType;

    public SubstitutableColumnNameToken(int startIndex, int stopIndex, Collection<Projection> projections, DatabaseType databaseType) {
        super(startIndex);
        this.stopIndex = stopIndex;
        this.quoteCharacter = new DatabaseTypeRegistry(databaseType).getDialectDatabaseMetaData().getQuoteCharacter();
        this.projections = projections;
        this.databaseType = databaseType;
    }

    @Override
    public String toString(RouteUnit routeUnit) {
        Map<String, String> logicAndActualTables = this.getLogicAndActualTables(routeUnit);
        StringBuilder result = new StringBuilder();
        int index = 0;
        for (Projection each : this.projections) {
            if (index > 0) {
                result.append(COLUMN_NAME_SPLITTER);
            }
            result.append(this.getColumnExpression(each, logicAndActualTables));
            ++index;
        }
        return result.toString();
    }

    private Map<String, String> getLogicAndActualTables(RouteUnit routeUnit) {
        if (null == routeUnit) {
            return Collections.emptyMap();
        }
        CaseInsensitiveMap result = new CaseInsensitiveMap();
        for (RouteMapper each : routeUnit.getTableMappers()) {
            result.put(each.getLogicName(), each.getActualName());
        }
        return result;
    }

    private String getColumnExpression(Projection projection, Map<String, String> logicActualTableNames) {
        StringBuilder builder = new StringBuilder();
        if (projection instanceof ColumnProjection) {
            this.appendColumnProjection((ColumnProjection)projection, logicActualTableNames, builder);
        } else {
            builder.append(this.quoteCharacter.wrap(projection.getColumnLabel()));
        }
        return builder.toString();
    }

    private void appendColumnProjection(ColumnProjection columnProjection, Map<String, String> logicActualTableNames, StringBuilder builder) {
        columnProjection.getLeftParentheses().ifPresent(optional -> builder.append("("));
        if (columnProjection.getOwner().isPresent()) {
            IdentifierValue owner = (IdentifierValue)columnProjection.getOwner().get();
            String actualTableOwner = logicActualTableNames.getOrDefault(owner.getValue(), owner.getValue());
            builder.append(this.getValueWithQuoteCharacters(new IdentifierValue(actualTableOwner, owner.getQuoteCharacter()))).append('.');
        }
        builder.append(this.getValueWithQuoteCharacters(columnProjection.getName()));
        columnProjection.getRightParentheses().ifPresent(optional -> builder.append(")"));
        if (columnProjection.getAlias().isPresent()) {
            builder.append(" AS ").append(this.getValueWithQuoteCharacters((IdentifierValue)columnProjection.getAlias().get()));
        }
    }

    private String getValueWithQuoteCharacters(IdentifierValue identifierValue) {
        return QuoteCharacter.NONE == identifierValue.getQuoteCharacter() ? identifierValue.getValue() : this.quoteCharacter.wrap(identifierValue.getValue());
    }

    @Override
    @Generated
    public int getStopIndex() {
        return this.stopIndex;
    }

    @Generated
    public Collection<Projection> getProjections() {
        return this.projections;
    }

    @Generated
    public DatabaseType getDatabaseType() {
        return this.databaseType;
    }
}

