/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.parser.sql;

import lombok.Generated;
import org.apache.shardingsphere.database.connector.core.type.DatabaseType;
import org.apache.shardingsphere.infra.parser.cache.CacheManager;
import org.apache.shardingsphere.infra.parser.cache.SQLStatementCacheBuilder;
import org.apache.shardingsphere.infra.parser.cache.SQLStatementCacheLoader;
import org.apache.shardingsphere.infra.parser.sql.SQLStatementParserExecutor;
import org.apache.shardingsphere.sql.parser.engine.api.CacheOption;
import org.apache.shardingsphere.sql.parser.statement.core.statement.SQLStatement;

public final class SQLStatementParserEngine {
    private final SQLStatementParserExecutor sqlStatementParserExecutor;
    private final CacheManager<String, SQLStatement> sqlStatementCacheManager;
    private final CacheOption sqlStatementCacheOption;
    private final CacheOption parseTreeCacheOption;

    public SQLStatementParserEngine(DatabaseType databaseType, CacheOption sqlStatementCacheOption, CacheOption parseTreeCacheOption) {
        this.sqlStatementParserExecutor = new SQLStatementParserExecutor(databaseType, parseTreeCacheOption);
        this.sqlStatementCacheManager = SQLStatementCacheBuilder.build(databaseType, sqlStatementCacheOption, parseTreeCacheOption);
        this.sqlStatementCacheOption = sqlStatementCacheOption;
        this.parseTreeCacheOption = parseTreeCacheOption;
    }

    public void updateCacheOption(CacheOption sqlStatementCacheOption, CacheOption parseTreeCacheOption) {
        this.sqlStatementCacheManager.getCache().policy().eviction().ifPresent(eviction -> eviction.setMaximum(sqlStatementCacheOption.getMaximumSize()));
        ((SQLStatementCacheLoader)this.sqlStatementCacheManager.getCacheLoader()).updateCacheOption(parseTreeCacheOption);
        this.sqlStatementParserExecutor.updateCacheOption(parseTreeCacheOption);
    }

    public SQLStatement parse(String sql, boolean useCache) {
        return useCache ? (SQLStatement)this.sqlStatementCacheManager.getCache().get((Object)sql) : this.sqlStatementParserExecutor.parse(sql);
    }

    @Generated
    public CacheOption getSqlStatementCacheOption() {
        return this.sqlStatementCacheOption;
    }

    @Generated
    public CacheOption getParseTreeCacheOption() {
        return this.parseTreeCacheOption;
    }
}

