/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.shadow.rule.changed;

import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.infra.util.yaml.YamlEngine;
import org.apache.shardingsphere.mode.spi.rule.RuleChangedItemType;
import org.apache.shardingsphere.mode.spi.rule.RuleItemConfigurationChangedProcessor;
import org.apache.shardingsphere.shadow.config.ShadowRuleConfiguration;
import org.apache.shardingsphere.shadow.config.table.ShadowTableConfiguration;
import org.apache.shardingsphere.shadow.rule.ShadowRule;
import org.apache.shardingsphere.shadow.yaml.config.table.YamlShadowTableConfiguration;
import org.apache.shardingsphere.shadow.yaml.swapper.table.YamlShadowTableConfigurationSwapper;

public final class ShadowTableChangedProcessor
implements RuleItemConfigurationChangedProcessor<ShadowRuleConfiguration, ShadowTableConfiguration> {
    public ShadowTableConfiguration swapRuleItemConfiguration(String itemName, String yamlContent) {
        return new YamlShadowTableConfigurationSwapper().swapToObject((YamlShadowTableConfiguration)YamlEngine.unmarshal((String)yamlContent, YamlShadowTableConfiguration.class));
    }

    public ShadowRuleConfiguration findRuleConfiguration(ShardingSphereDatabase database) {
        return database.getRuleMetaData().findSingleRule(ShadowRule.class).map(ShadowRule::getConfiguration).orElseGet(ShadowRuleConfiguration::new);
    }

    public void changeRuleItemConfiguration(String itemName, ShadowRuleConfiguration currentRuleConfig, ShadowTableConfiguration toBeChangedItemConfig) {
        currentRuleConfig.getTables().put(itemName, toBeChangedItemConfig);
    }

    public void dropRuleItemConfiguration(String itemName, ShadowRuleConfiguration currentRuleConfig) {
        currentRuleConfig.getTables().remove(itemName);
    }

    public RuleChangedItemType getType() {
        return new RuleChangedItemType("shadow", "tables");
    }
}

