/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.shadow.rule.changed;

import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.infra.util.yaml.YamlEngine;
import org.apache.shardingsphere.mode.spi.rule.RuleChangedItemType;
import org.apache.shardingsphere.mode.spi.rule.RuleItemConfigurationChangedProcessor;
import org.apache.shardingsphere.shadow.config.ShadowRuleConfiguration;
import org.apache.shardingsphere.shadow.config.datasource.ShadowDataSourceConfiguration;
import org.apache.shardingsphere.shadow.rule.ShadowRule;
import org.apache.shardingsphere.shadow.yaml.config.datasource.YamlShadowDataSourceConfiguration;

public final class ShadowDataSourceChangedProcessor
implements RuleItemConfigurationChangedProcessor<ShadowRuleConfiguration, ShadowDataSourceConfiguration> {
    public ShadowDataSourceConfiguration swapRuleItemConfiguration(String itemName, String yamlContent) {
        YamlShadowDataSourceConfiguration yamlConfig = (YamlShadowDataSourceConfiguration)YamlEngine.unmarshal((String)yamlContent, YamlShadowDataSourceConfiguration.class);
        return new ShadowDataSourceConfiguration(itemName, yamlConfig.getProductionDataSourceName(), yamlConfig.getShadowDataSourceName());
    }

    public ShadowRuleConfiguration findRuleConfiguration(ShardingSphereDatabase database) {
        return database.getRuleMetaData().findSingleRule(ShadowRule.class).map(ShadowRule::getConfiguration).orElseGet(ShadowRuleConfiguration::new);
    }

    public void changeRuleItemConfiguration(String itemName, ShadowRuleConfiguration currentRuleConfig, ShadowDataSourceConfiguration toBeChangedItemConfig) {
        currentRuleConfig.getDataSources().removeIf(each -> each.getName().equals(toBeChangedItemConfig.getName()));
        currentRuleConfig.getDataSources().add(toBeChangedItemConfig);
    }

    public void dropRuleItemConfiguration(String itemName, ShadowRuleConfiguration currentRuleConfig) {
        currentRuleConfig.getDataSources().removeIf(each -> each.getName().equals(itemName));
    }

    public RuleChangedItemType getType() {
        return new RuleChangedItemType("shadow", "data_sources");
    }
}

