/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.props;

import com.google.common.base.Strings;
import lombok.Generated;
import org.apache.shardingsphere.infra.props.TypedPropertyKey;
import org.apache.shardingsphere.infra.props.exception.TypedPropertyValueException;
import org.apache.shardingsphere.infra.spi.type.typed.TypedSPI;
import org.apache.shardingsphere.infra.spi.type.typed.TypedSPILoader;

public final class TypedPropertyValue {
    private final Object value;

    public TypedPropertyValue(TypedPropertyKey key, String value) throws TypedPropertyValueException {
        this.value = this.createTypedValue(key, value);
    }

    private Object createTypedValue(TypedPropertyKey key, String value) throws TypedPropertyValueException {
        if (Boolean.TYPE == key.getType() || Boolean.class == key.getType()) {
            return Boolean.valueOf(value);
        }
        if (Integer.TYPE == key.getType() || Integer.class == key.getType()) {
            try {
                return Integer.valueOf(value);
            }
            catch (NumberFormatException ignored) {
                throw new TypedPropertyValueException(key, value);
            }
        }
        if (Long.TYPE == key.getType() || Long.class == key.getType()) {
            try {
                return Long.valueOf(value);
            }
            catch (NumberFormatException ignored) {
                throw new TypedPropertyValueException(key, value);
            }
        }
        if (Float.TYPE == key.getType() || Float.class == key.getType()) {
            try {
                return Float.valueOf(value);
            }
            catch (NumberFormatException ignored) {
                throw new TypedPropertyValueException(key, value);
            }
        }
        if (Double.TYPE == key.getType() || Double.class == key.getType()) {
            try {
                return Double.valueOf(value);
            }
            catch (NumberFormatException ignored) {
                throw new TypedPropertyValueException(key, value);
            }
        }
        if (Enum.class.isAssignableFrom(key.getType())) {
            return this.getEnumValue(key, value);
        }
        if (TypedSPI.class.isAssignableFrom(key.getType())) {
            return this.getTypedSPI(key, value);
        }
        return value;
    }

    private Enum<?> getEnumValue(TypedPropertyKey key, String value) throws TypedPropertyValueException {
        try {
            return (Enum)key.getType().getMethod("valueOf", String.class).invoke(null, value.toUpperCase());
        }
        catch (IllegalArgumentException | ReflectiveOperationException ignored) {
            throw new TypedPropertyValueException(key, value);
        }
    }

    private TypedSPI getTypedSPI(TypedPropertyKey key, String value) {
        return Strings.isNullOrEmpty((String)value) ? null : TypedSPILoader.getService(key.getType(), (Object)value);
    }

    @Generated
    public Object getValue() {
        return this.value;
    }
}

