/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.metadata.statistics.collector.shardingsphere;

import com.cedarsoftware.util.CaseInsensitiveMap;
import com.cedarsoftware.util.CaseInsensitiveSet;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import org.apache.shardingsphere.infra.metadata.ShardingSphereMetaData;
import org.apache.shardingsphere.infra.metadata.statistics.collector.DialectDatabaseStatisticsCollector;
import org.apache.shardingsphere.infra.metadata.statistics.collector.shardingsphere.ShardingSphereTableStatisticsCollector;
import org.apache.shardingsphere.infra.spi.ShardingSphereServiceLoader;
import org.apache.shardingsphere.infra.spi.type.typed.TypedSPILoader;

public final class ShardingSphereStatisticsCollector
implements DialectDatabaseStatisticsCollector {
    private static final Map<String, Collection<String>> STATISTICS_SCHEMA_TABLES = new CaseInsensitiveMap();

    @Override
    public Optional<Collection<Map<String, Object>>> collectRowColumnValues(String databaseName, String schemaName, String tableName, ShardingSphereMetaData metaData) {
        return TypedSPILoader.findService(ShardingSphereTableStatisticsCollector.class, (Object)String.format("%s.%s", schemaName, tableName)).map(optional -> optional.collect(databaseName, schemaName, tableName, metaData));
    }

    @Override
    public boolean isStatisticsTables(Map<String, Collection<String>> schemaTables) {
        return !schemaTables.isEmpty() && schemaTables.entrySet().stream().noneMatch(entry -> !STATISTICS_SCHEMA_TABLES.containsKey(entry.getKey()) || !STATISTICS_SCHEMA_TABLES.get(entry.getKey()).containsAll((Collection)entry.getValue()));
    }

    static {
        for (ShardingSphereTableStatisticsCollector each : ShardingSphereServiceLoader.getServiceInstances(ShardingSphereTableStatisticsCollector.class)) {
            if (!STATISTICS_SCHEMA_TABLES.containsKey(each.getSchemaName())) {
                STATISTICS_SCHEMA_TABLES.put(each.getSchemaName(), (Collection<String>)new CaseInsensitiveSet());
            }
            STATISTICS_SCHEMA_TABLES.get(each.getSchemaName()).add(each.getTableName());
        }
    }
}

