/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.metadata.statistics.collector.postgresql.table;

import com.cedarsoftware.util.CaseInsensitiveMap;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Map;
import org.apache.shardingsphere.infra.metadata.ShardingSphereMetaData;
import org.apache.shardingsphere.infra.metadata.database.schema.model.ShardingSphereSchema;
import org.apache.shardingsphere.infra.metadata.statistics.collector.postgresql.PostgreSQLTableStatisticsCollector;

public final class PostgreSQLPgNamespaceTableStatisticsCollector
implements PostgreSQLTableStatisticsCollector {
    private static final String PUBLIC_SCHEMA = "public";
    private static final Long PUBLIC_SCHEMA_OID = 0L;

    @Override
    public Collection<Map<String, Object>> collect(String databaseName, String schemaName, String tableName, ShardingSphereMetaData metaData) {
        LinkedList<Map<String, Object>> result = new LinkedList<Map<String, Object>>();
        long oid = 1L;
        for (ShardingSphereSchema each : metaData.getDatabase(databaseName).getAllSchemas()) {
            long l;
            CaseInsensitiveMap columnValues = new CaseInsensitiveMap(2, 1.0f);
            if (PUBLIC_SCHEMA.equalsIgnoreCase(each.getName())) {
                l = PUBLIC_SCHEMA_OID;
            } else {
                long l2 = oid;
                l = l2;
                oid = l2 + 1L;
            }
            columnValues.put("oid", l);
            columnValues.put("nspname", each.getName());
            result.add((Map<String, Object>)columnValues);
        }
        return result;
    }

    @Override
    public String getSchemaName() {
        return "pg_catalog";
    }

    @Override
    public String getTableName() {
        return "pg_namespace";
    }

    public String getType() {
        return "pg_catalog.pg_namespace";
    }
}

