/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.metadata.statistics.builder.dialect;

import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.infra.metadata.database.schema.model.ShardingSphereSchema;
import org.apache.shardingsphere.infra.metadata.database.schema.model.ShardingSphereTable;
import org.apache.shardingsphere.infra.metadata.statistics.DatabaseStatistics;
import org.apache.shardingsphere.infra.metadata.statistics.SchemaStatistics;
import org.apache.shardingsphere.infra.metadata.statistics.TableStatistics;
import org.apache.shardingsphere.infra.metadata.statistics.builder.DialectStatisticsAppender;

public final class PostgreSQLStatisticsAppender
implements DialectStatisticsAppender {
    private static final Map<String, Collection<String>> INIT_DATA_SCHEMA_TABLES = new LinkedHashMap<String, Collection<String>>();

    @Override
    public void append(DatabaseStatistics databaseStatistics, ShardingSphereDatabase database) {
        for (Map.Entry<String, Collection<String>> entry : INIT_DATA_SCHEMA_TABLES.entrySet()) {
            SchemaStatistics schemaStatistics = new SchemaStatistics();
            if (!database.containsSchema(entry.getKey())) continue;
            this.initTables(database.getSchema(entry.getKey()), entry.getValue(), schemaStatistics);
            databaseStatistics.putSchemaStatistics(entry.getKey(), schemaStatistics);
        }
    }

    private void initTables(ShardingSphereSchema schema, Collection<String> tableNames, SchemaStatistics schemaStatistics) {
        for (ShardingSphereTable each : schema.getAllTables()) {
            if (!tableNames.contains(each.getName().toLowerCase())) continue;
            schemaStatistics.putTableStatistics(each.getName().toLowerCase(), new TableStatistics(each.getName()));
        }
    }

    public String getDatabaseType() {
        return "PostgreSQL";
    }

    static {
        INIT_DATA_SCHEMA_TABLES.put("pg_catalog", Arrays.asList("pg_class", "pg_namespace"));
    }
}

