/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.metadata.statistics.builder;

import com.cedarsoftware.util.CaseInsensitiveSet;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.shardingsphere.database.connector.core.metadata.database.metadata.DialectDatabaseMetaData;
import org.apache.shardingsphere.database.connector.core.spi.DatabaseTypedSPILoader;
import org.apache.shardingsphere.database.connector.core.type.DatabaseType;
import org.apache.shardingsphere.database.connector.core.type.DatabaseTypeRegistry;
import org.apache.shardingsphere.infra.metadata.ShardingSphereMetaData;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.infra.metadata.database.schema.model.ShardingSphereSchema;
import org.apache.shardingsphere.infra.metadata.statistics.DatabaseStatistics;
import org.apache.shardingsphere.infra.metadata.statistics.SchemaStatistics;
import org.apache.shardingsphere.infra.metadata.statistics.ShardingSphereStatistics;
import org.apache.shardingsphere.infra.metadata.statistics.TableStatistics;
import org.apache.shardingsphere.infra.metadata.statistics.builder.DialectStatisticsAppender;
import org.apache.shardingsphere.infra.metadata.statistics.builder.ShardingSphereDefaultStatisticsBuilder;
import org.apache.shardingsphere.infra.spi.type.typed.TypedSPILoader;

public final class ShardingSphereStatisticsFactory {
    public static ShardingSphereStatistics create(ShardingSphereMetaData metaData, ShardingSphereStatistics loadedStatistics) {
        ShardingSphereStatistics result = new ShardingSphereStatistics();
        if (metaData.getAllDatabases().isEmpty()) {
            return result;
        }
        Optional dialectStatisticsAppender = DatabaseTypedSPILoader.findService(DialectStatisticsAppender.class, (DatabaseType)ShardingSphereStatisticsFactory.getDatabaseType(metaData));
        Collection unloadedDatabases = metaData.getAllDatabases().stream().filter(each -> !loadedStatistics.containsDatabaseStatistics(each.getName())).collect(Collectors.toList());
        for (ShardingSphereDatabase each2 : unloadedDatabases) {
            DatabaseStatistics databaseStatistics = new DatabaseStatistics();
            dialectStatisticsAppender.ifPresent(optional -> optional.append(databaseStatistics, each2));
            if (databaseStatistics.getSchemaStatisticsMap().isEmpty()) continue;
            result.putDatabaseStatistics(each2.getName(), databaseStatistics);
        }
        loadedStatistics.getDatabaseStatisticsMap().forEach(result::putDatabaseStatistics);
        ShardingSphereStatisticsFactory.fillDefaultStatistics(metaData, result);
        return result;
    }

    private static DatabaseType getDatabaseType(ShardingSphereMetaData metaData) {
        DatabaseType protocolType = metaData.getAllDatabases().iterator().next().getProtocolType();
        DialectDatabaseMetaData dialectDatabaseMetaData = new DatabaseTypeRegistry(protocolType).getDialectDatabaseMetaData();
        return dialectDatabaseMetaData.getSchemaOption().getDefaultSchema().isPresent() ? (DatabaseType)TypedSPILoader.getService(DatabaseType.class, (Object)"PostgreSQL") : protocolType;
    }

    private static void fillDefaultStatistics(ShardingSphereMetaData metaData, ShardingSphereStatistics statistics) {
        for (ShardingSphereDatabase database : metaData.getAllDatabases()) {
            DatabaseStatistics defaultDatabaseStatistics = new ShardingSphereDefaultStatisticsBuilder().build(database);
            CaseInsensitiveSet defaultSchemaNames = new CaseInsensitiveSet(defaultDatabaseStatistics.getSchemaStatisticsMap().keySet());
            if (database.getAllSchemas().stream().noneMatch(arg_0 -> ShardingSphereStatisticsFactory.lambda$fillDefaultStatistics$2((Collection)defaultSchemaNames, arg_0))) continue;
            if (!statistics.containsDatabaseStatistics(database.getName())) {
                statistics.putDatabaseStatistics(database.getName(), defaultDatabaseStatistics);
                continue;
            }
            ShardingSphereStatisticsFactory.fillDefaultStatistics(defaultDatabaseStatistics, statistics.getDatabaseStatistics(database.getName()));
        }
    }

    private static void fillDefaultStatistics(DatabaseStatistics defaultDatabaseStatistics, DatabaseStatistics existedDatabaseStatistics) {
        for (Map.Entry<String, SchemaStatistics> entry : defaultDatabaseStatistics.getSchemaStatisticsMap().entrySet()) {
            if (!existedDatabaseStatistics.containsSchemaStatistics(entry.getKey())) {
                existedDatabaseStatistics.putSchemaStatistics(entry.getKey(), entry.getValue());
                continue;
            }
            ShardingSphereStatisticsFactory.fillDefaultStatistics(entry.getValue(), existedDatabaseStatistics.getSchemaStatistics(entry.getKey()));
        }
    }

    private static void fillDefaultStatistics(SchemaStatistics defaultSchemaStatistics, SchemaStatistics existedSchemaStatistics) {
        for (Map.Entry<String, TableStatistics> entry : defaultSchemaStatistics.getTableStatisticsMap().entrySet()) {
            if (existedSchemaStatistics.containsTableStatistics(entry.getKey())) continue;
            existedSchemaStatistics.putTableStatistics(entry.getKey(), entry.getValue());
        }
    }

    @Generated
    private ShardingSphereStatisticsFactory() {
    }

    private static /* synthetic */ boolean lambda$fillDefaultStatistics$2(Collection defaultSchemaNames, ShardingSphereSchema optional) {
        return defaultSchemaNames.contains(optional.getName());
    }
}

