/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.metadata.statistics.builder;

import java.util.Collections;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.infra.metadata.statistics.DatabaseStatistics;
import org.apache.shardingsphere.infra.metadata.statistics.RowStatistics;
import org.apache.shardingsphere.infra.metadata.statistics.SchemaStatistics;
import org.apache.shardingsphere.infra.metadata.statistics.TableStatistics;
import org.apache.shardingsphere.infra.version.ShardingSphereVersion;

public final class ShardingSphereDefaultStatisticsBuilder {
    private static final String SHARDINGSPHERE = "shardingsphere";
    private static final String CLUSTER_INFORMATION = "cluster_information";

    public DatabaseStatistics build(ShardingSphereDatabase database) {
        DatabaseStatistics result = new DatabaseStatistics();
        if (database.containsSchema(SHARDINGSPHERE)) {
            SchemaStatistics schemaStatistics = new SchemaStatistics();
            this.buildClusterInformationTable(schemaStatistics);
            result.putSchemaStatistics(SHARDINGSPHERE, schemaStatistics);
        }
        return result;
    }

    private void buildClusterInformationTable(SchemaStatistics schemaStatistics) {
        TableStatistics tableStatistics = new TableStatistics(CLUSTER_INFORMATION);
        tableStatistics.getRows().add(new RowStatistics(Collections.singletonList(ShardingSphereVersion.VERSION)));
        schemaStatistics.putTableStatistics(CLUSTER_INFORMATION, tableStatistics);
    }
}

