/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.metadata.statistics;

import com.cedarsoftware.util.CaseInsensitiveMap;
import java.util.Collections;
import java.util.Map;
import lombok.Generated;
import org.apache.shardingsphere.infra.metadata.statistics.DatabaseStatistics;

public final class ShardingSphereStatistics {
    private final Map<String, DatabaseStatistics> databaseStatisticsMap = Collections.synchronizedMap(new CaseInsensitiveMap());

    public DatabaseStatistics getDatabaseStatistics(String databaseName) {
        return this.databaseStatisticsMap.get(databaseName);
    }

    public void putDatabaseStatistics(String databaseName, DatabaseStatistics databaseStatistics) {
        this.databaseStatisticsMap.put(databaseName, databaseStatistics);
    }

    public void dropDatabaseStatistics(String databaseName) {
        this.databaseStatisticsMap.remove(databaseName);
    }

    public boolean containsDatabaseStatistics(String databaseName) {
        return this.databaseStatisticsMap.containsKey(databaseName);
    }

    @Generated
    public Map<String, DatabaseStatistics> getDatabaseStatisticsMap() {
        return this.databaseStatisticsMap;
    }
}

