/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.metadata.database.schema.manager;

import com.cedarsoftware.util.CaseInsensitiveMap;
import com.cedarsoftware.util.CaseInsensitiveSet;
import java.io.InputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.stream.Collectors;

public final class DialectSystemSchemaManager {
    private final Map<String, Collection<String>> schemaAndTableMap = new CaseInsensitiveMap();
    private final Map<String, Collection<String>> schemaAndResourceMap = new CaseInsensitiveMap();

    public void putTable(String schemaName, String tableName) {
        this.schemaAndTableMap.computeIfAbsent(schemaName, key -> new CaseInsensitiveSet()).add(tableName);
    }

    public void putResource(String schemaName, String resourcePath) {
        this.schemaAndResourceMap.computeIfAbsent(schemaName, key -> new CaseInsensitiveSet()).add(resourcePath);
    }

    public boolean isSystemTable(String schemaName, String tableName) {
        return null == schemaName ? this.schemaAndTableMap.values().stream().anyMatch(each -> each.contains(tableName)) : ((Collection)this.schemaAndTableMap.getOrDefault(schemaName, Collections.emptyList())).contains(tableName);
    }

    public boolean isSystemTable(String schemaName, Collection<String> tableNames) {
        Collection tables = this.schemaAndTableMap.getOrDefault(schemaName, Collections.emptyList());
        for (String each : tableNames) {
            if (tables.contains(each)) continue;
            return false;
        }
        return true;
    }

    public Collection<String> getTables(String schemaName) {
        return this.schemaAndTableMap.getOrDefault(schemaName, Collections.emptyList());
    }

    public Collection<InputStream> getAllInputStreams(String schemaName) {
        return ((Collection)this.schemaAndResourceMap.getOrDefault(schemaName, Collections.emptyList())).stream().map(each -> DialectSystemSchemaManager.class.getClassLoader().getResourceAsStream((String)each)).collect(Collectors.toList());
    }
}

