/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.metadata.database.schema;

import java.util.Objects;
import org.apache.shardingsphere.infra.metadata.identifier.ShardingSphereIdentifier;

public final class QualifiedTable {
    private final ShardingSphereIdentifier schemaName;
    private final ShardingSphereIdentifier tableName;

    public QualifiedTable(String schemaName, String tableName) {
        this.schemaName = new ShardingSphereIdentifier(schemaName);
        this.tableName = new ShardingSphereIdentifier(tableName);
    }

    public String getSchemaName() {
        return this.schemaName.getValue();
    }

    public String getTableName() {
        return this.tableName.getValue();
    }

    public String format() {
        return null == this.getSchemaName() ? this.getTableName() : String.join((CharSequence)".", this.getSchemaName(), this.getTableName());
    }

    public boolean equals(Object o) {
        if (null == o || this.getClass() != o.getClass()) {
            return false;
        }
        QualifiedTable that = (QualifiedTable)o;
        return Objects.equals(null == this.schemaName.getValue() ? null : this.schemaName, null == that.schemaName.getValue() ? null : that.schemaName) && Objects.equals(null == this.tableName.getValue() ? null : this.tableName, null == that.tableName.getValue() ? null : that.tableName);
    }

    public int hashCode() {
        return Objects.hash(this.schemaName, this.tableName);
    }

    public String toString() {
        return this.format();
    }
}

