/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.metadata.database.rule;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.shardingsphere.infra.config.rule.RuleConfiguration;
import org.apache.shardingsphere.infra.datanode.DataNode;
import org.apache.shardingsphere.infra.exception.ShardingSpherePreconditions;
import org.apache.shardingsphere.infra.rule.ShardingSphereRule;
import org.apache.shardingsphere.infra.rule.attribute.RuleAttribute;
import org.apache.shardingsphere.infra.rule.attribute.datanode.DataNodeRuleAttribute;
import org.apache.shardingsphere.infra.rule.attribute.datasource.DataSourceMapperRuleAttribute;

public final class RuleMetaData {
    private final Map<Class<?>, Collection<?>> ruleCache = new ConcurrentHashMap();
    private final Map<Class<?>, Optional<ShardingSphereRule>> singleRuleCache = new ConcurrentHashMap();
    private final Map<Class<?>, Collection<?>> attributeCache = new ConcurrentHashMap();
    private final Collection<ShardingSphereRule> rules;

    public RuleMetaData(Collection<ShardingSphereRule> rules) {
        this.rules = new CacheInvalidatingCopyOnWriteArrayList(rules);
    }

    public Collection<RuleConfiguration> getConfigurations() {
        return this.rules.stream().map(ShardingSphereRule::getConfiguration).collect(Collectors.toList());
    }

    public <T extends ShardingSphereRule> Collection<T> findRules(Class<T> clazz) {
        Collection result = this.ruleCache.get(clazz);
        if (null == result) {
            result = this.ruleCache.computeIfAbsent(clazz, this::computeRules);
        }
        return result;
    }

    private Collection<? extends ShardingSphereRule> computeRules(Class<?> clazz) {
        LinkedList<ShardingSphereRule> result = new LinkedList<ShardingSphereRule>();
        for (ShardingSphereRule each : this.rules) {
            if (!clazz.isAssignableFrom(each.getClass())) continue;
            result.add(each);
        }
        return result;
    }

    public <T extends ShardingSphereRule> Optional<T> findSingleRule(Class<T> clazz) {
        Optional result = this.singleRuleCache.get(clazz);
        if (null == result) {
            result = this.singleRuleCache.computeIfAbsent(clazz, this::computeSingleRule);
        }
        return result;
    }

    public <T extends ShardingSphereRule> T getSingleRule(Class<T> clazz) {
        Optional shardingSphereRule = this.singleRuleCache.get(clazz);
        if (null == shardingSphereRule) {
            shardingSphereRule = this.singleRuleCache.computeIfAbsent(clazz, this::computeSingleRule);
        }
        ShardingSpherePreconditions.checkState((boolean)shardingSphereRule.isPresent(), () -> new IllegalStateException(String.format("Rule `%s` should have and only have one instance.", clazz.getSimpleName())));
        return (T)shardingSphereRule.get();
    }

    private Optional<ShardingSphereRule> computeSingleRule(Class<?> clazz) {
        Collection<?> rules = this.findRules(clazz);
        return 1 == rules.size() ? Optional.of((ShardingSphereRule)rules.iterator().next()) : Optional.empty();
    }

    public Map<String, Collection<Class<? extends ShardingSphereRule>>> getInUsedStorageUnitNameAndRulesMap() {
        LinkedHashMap<String, Collection<Class<? extends ShardingSphereRule>>> result = new LinkedHashMap<String, Collection<Class<? extends ShardingSphereRule>>>();
        for (ShardingSphereRule each : this.rules) {
            Collection<String> inUsedStorageUnitNames = this.getInUsedStorageUnitNames(each);
            if (inUsedStorageUnitNames.isEmpty()) continue;
            this.mergeInUsedStorageUnitNameAndRules(result, this.getInUsedStorageUnitNameAndRulesMap(each, inUsedStorageUnitNames));
        }
        return result;
    }

    private Map<String, Collection<Class<? extends ShardingSphereRule>>> getInUsedStorageUnitNameAndRulesMap(ShardingSphereRule rule, Collection<String> inUsedStorageUnitNames) {
        LinkedHashMap<String, Collection<Class<? extends ShardingSphereRule>>> result = new LinkedHashMap<String, Collection<Class<? extends ShardingSphereRule>>>();
        for (String each : inUsedStorageUnitNames) {
            result.computeIfAbsent(each, unused -> new LinkedHashSet()).add(rule.getClass());
        }
        return result;
    }

    private Collection<String> getInUsedStorageUnitNames(ShardingSphereRule rule) {
        Optional<DataSourceMapperRuleAttribute> dataSourceMapperRuleAttribute = rule.getAttributes().findAttribute(DataSourceMapperRuleAttribute.class);
        if (dataSourceMapperRuleAttribute.isPresent()) {
            return this.getInUsedStorageUnitNames(dataSourceMapperRuleAttribute.get());
        }
        Optional<DataNodeRuleAttribute> dataNodeRuleAttribute = rule.getAttributes().findAttribute(DataNodeRuleAttribute.class);
        if (dataNodeRuleAttribute.isPresent()) {
            return this.getInUsedStorageUnitNames(dataNodeRuleAttribute.get());
        }
        return Collections.emptyList();
    }

    private Collection<String> getInUsedStorageUnitNames(DataSourceMapperRuleAttribute ruleAttribute) {
        return ruleAttribute.getDataSourceMapper().values().stream().flatMap(Collection::stream).collect(Collectors.toSet());
    }

    private Collection<String> getInUsedStorageUnitNames(DataNodeRuleAttribute ruleAttribute) {
        return ruleAttribute.getAllDataNodes().values().stream().flatMap(each -> each.stream().map(DataNode::getDataSourceName).collect(Collectors.toSet()).stream()).collect(Collectors.toSet());
    }

    private void mergeInUsedStorageUnitNameAndRules(Map<String, Collection<Class<? extends ShardingSphereRule>>> storageUnitNameAndRules, Map<String, Collection<Class<? extends ShardingSphereRule>>> toBeMergedStorageUnitNameAndRules) {
        for (Map.Entry<String, Collection<Class<? extends ShardingSphereRule>>> entry : toBeMergedStorageUnitNameAndRules.entrySet()) {
            if (storageUnitNameAndRules.containsKey(entry.getKey())) {
                for (Class<? extends ShardingSphereRule> each : entry.getValue()) {
                    if (storageUnitNameAndRules.get(entry.getKey()).contains(each)) continue;
                    storageUnitNameAndRules.get(entry.getKey()).add(each);
                }
                continue;
            }
            storageUnitNameAndRules.put(entry.getKey(), entry.getValue());
        }
    }

    public <T extends RuleAttribute> Collection<T> getAttributes(Class<T> attributeClass) {
        Collection result = this.attributeCache.get(attributeClass);
        if (null == result) {
            result = this.attributeCache.computeIfAbsent(attributeClass, this::computeAttributes);
        }
        return result;
    }

    private Collection<? extends RuleAttribute> computeAttributes(Class<?> attributeClass) {
        LinkedList result = new LinkedList();
        for (ShardingSphereRule each : this.rules) {
            each.getAttributes().findAttribute(attributeClass.asSubclass(RuleAttribute.class)).ifPresent(result::add);
        }
        return result;
    }

    public <T extends RuleAttribute> Optional<T> findAttribute(Class<T> attributeClass) {
        Collection<T> attributes = this.getAttributes(attributeClass);
        return attributes.isEmpty() ? Optional.empty() : Optional.of((RuleAttribute)attributes.iterator().next());
    }

    @Generated
    public Collection<ShardingSphereRule> getRules() {
        return this.rules;
    }

    private final class CacheInvalidatingCopyOnWriteArrayList
    extends CopyOnWriteArrayList<ShardingSphereRule> {
        private static final long serialVersionUID = 4649605887075508397L;

        CacheInvalidatingCopyOnWriteArrayList(Collection<ShardingSphereRule> rules) {
            super(rules);
        }

        private void invalidateCache() {
            RuleMetaData.this.ruleCache.clear();
            RuleMetaData.this.singleRuleCache.clear();
            RuleMetaData.this.attributeCache.clear();
        }

        @Override
        public boolean add(ShardingSphereRule rule) {
            this.invalidateCache();
            return super.add(rule);
        }

        @Override
        public boolean addAll(Collection<? extends ShardingSphereRule> collection) {
            this.invalidateCache();
            return super.addAll(collection);
        }

        @Override
        public boolean remove(Object o) {
            this.invalidateCache();
            return super.remove(o);
        }

        @Override
        public boolean removeAll(Collection<?> objects) {
            this.invalidateCache();
            return super.removeAll(objects);
        }

        @Override
        public boolean removeIf(Predicate<? super ShardingSphereRule> filter) {
            this.invalidateCache();
            return super.removeIf(filter);
        }

        @Override
        public boolean retainAll(Collection<?> objects) {
            this.invalidateCache();
            return super.retainAll(objects);
        }

        @Override
        public void clear() {
            this.invalidateCache();
            super.clear();
        }
    }
}

