/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.datanode;

import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.apache.shardingsphere.infra.datanode.DataNode;

public final class DataNodeUtils {
    public static Map<String, List<DataNode>> getDataNodeGroups(Collection<DataNode> dataNodes) {
        LinkedHashMap<String, List<DataNode>> result = new LinkedHashMap<String, List<DataNode>>(dataNodes.size(), 1.0f);
        for (DataNode each : dataNodes) {
            result.computeIfAbsent(each.getDataSourceName(), unused -> new LinkedList()).add(each);
        }
        return result;
    }

    public static Collection<DataNode> buildDataNode(DataNode dataNode, Map<String, Collection<String>> dataSources) {
        if (!dataSources.containsKey(dataNode.getDataSourceName())) {
            return Collections.singletonList(dataNode);
        }
        LinkedList<DataNode> result = new LinkedList<DataNode>();
        for (String each : dataSources.get(dataNode.getDataSourceName())) {
            result.add(new DataNode(each, (String)null, dataNode.getTableName()));
        }
        return result;
    }

    public static List<String> getFormattedDataNodes(int amount, String logicTable, Collection<String> dataSources) {
        LinkedList<String> result = new LinkedList<String>();
        Iterator<String> iterator = dataSources.iterator();
        for (int i = 0; i < amount; ++i) {
            if (!iterator.hasNext()) {
                iterator = dataSources.iterator();
            }
            result.add(String.format("%s.%s_%s", iterator.next(), logicTable, i));
        }
        return result;
    }

    @Generated
    private DataNodeUtils() {
    }
}

