/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.config.database.impl;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.stream.Collectors;
import javax.sql.DataSource;
import lombok.Generated;
import org.apache.shardingsphere.infra.config.database.DatabaseConfiguration;
import org.apache.shardingsphere.infra.config.rule.RuleConfiguration;
import org.apache.shardingsphere.infra.datasource.pool.props.creator.DataSourcePoolPropertiesCreator;
import org.apache.shardingsphere.infra.datasource.pool.props.domain.DataSourcePoolProperties;
import org.apache.shardingsphere.infra.metadata.database.resource.node.StorageNode;
import org.apache.shardingsphere.infra.metadata.database.resource.node.StorageNodeAggregator;
import org.apache.shardingsphere.infra.metadata.database.resource.unit.StorageUnit;
import org.apache.shardingsphere.infra.metadata.database.resource.unit.StorageUnitNodeMapCreator;

public final class DataSourceProvidedDatabaseConfiguration
implements DatabaseConfiguration {
    private final Collection<RuleConfiguration> ruleConfigurations;
    private final Map<String, StorageUnit> storageUnits;
    private final Map<StorageNode, DataSource> dataSources;

    public DataSourceProvidedDatabaseConfiguration(Map<String, DataSource> dataSources, Collection<RuleConfiguration> ruleConfigs) {
        this.ruleConfigurations = ruleConfigs;
        Map storageUnitNodeMap = dataSources.keySet().stream().collect(Collectors.toMap(each -> each, StorageNode::new, (oldValue, currentValue) -> oldValue, LinkedHashMap::new));
        Map<StorageNode, DataSource> storageNodeDataSources = StorageNodeAggregator.aggregateDataSources(dataSources);
        this.storageUnits = this.getStorageUnits(storageUnitNodeMap, storageNodeDataSources, this.createDataSourcePoolPropertiesMap(dataSources));
        this.dataSources = storageNodeDataSources;
    }

    public DataSourceProvidedDatabaseConfiguration(Map<StorageNode, DataSource> storageNodeDataSources, Collection<RuleConfiguration> ruleConfigs, Map<String, DataSourcePoolProperties> dataSourcePoolPropsMap, boolean isInstanceConnectionEnabled) {
        this.ruleConfigurations = ruleConfigs;
        Map<String, StorageNode> storageUnitNodeMap = StorageUnitNodeMapCreator.create(dataSourcePoolPropsMap, isInstanceConnectionEnabled);
        this.storageUnits = this.getStorageUnits(storageUnitNodeMap, storageNodeDataSources, dataSourcePoolPropsMap);
        this.dataSources = storageNodeDataSources;
    }

    private Map<String, StorageUnit> getStorageUnits(Map<String, StorageNode> storageUnitNodeMap, Map<StorageNode, DataSource> storageNodeDataSources, Map<String, DataSourcePoolProperties> dataSourcePoolPropsMap) {
        LinkedHashMap<String, StorageUnit> result = new LinkedHashMap<String, StorageUnit>(dataSourcePoolPropsMap.size(), 1.0f);
        for (Map.Entry<String, DataSourcePoolProperties> entry : dataSourcePoolPropsMap.entrySet()) {
            String storageUnitName = entry.getKey();
            StorageNode storageNode = storageUnitNodeMap.get(storageUnitName);
            DataSource dataSource = storageNodeDataSources.containsKey(storageNode) ? storageNodeDataSources.get(storageNode) : storageNodeDataSources.get(new StorageNode(storageUnitName));
            StorageUnit storageUnit = new StorageUnit(storageNode, entry.getValue(), dataSource);
            result.put(storageUnitName, storageUnit);
        }
        return result;
    }

    private Map<String, DataSourcePoolProperties> createDataSourcePoolPropertiesMap(Map<String, DataSource> dataSources) {
        return dataSources.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> DataSourcePoolPropertiesCreator.create((DataSource)((DataSource)entry.getValue())), (oldValue, currentValue) -> oldValue, LinkedHashMap::new));
    }

    @Override
    @Generated
    public Collection<RuleConfiguration> getRuleConfigurations() {
        return this.ruleConfigurations;
    }

    @Override
    @Generated
    public Map<String, StorageUnit> getStorageUnits() {
        return this.storageUnits;
    }

    @Override
    @Generated
    public Map<StorageNode, DataSource> getDataSources() {
        return this.dataSources;
    }
}

