/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.transaction.xa.jta.datasource.swapper;

import com.google.common.base.CaseFormat;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import javax.sql.DataSource;
import javax.sql.XADataSource;
import lombok.Generated;
import org.apache.shardingsphere.database.connector.core.type.DatabaseType;
import org.apache.shardingsphere.infra.datasource.pool.CatalogSwitchableDataSource;
import org.apache.shardingsphere.infra.datasource.pool.props.creator.DataSourcePoolPropertiesCreator;
import org.apache.shardingsphere.transaction.xa.jta.exception.XADataSourceInitializeException;

public final class DataSourceSwapper {
    private static final String SETTER_PREFIX = "set";
    private final DatabaseType databaseType;
    private final Collection<String> xaDriverClassNames;

    public XADataSource swap(DataSource dataSource) {
        XADataSource result = this.createXADataSource();
        this.setProperties(result, this.getDatabaseAccessConfiguration(dataSource));
        return result;
    }

    private XADataSource createXADataSource() {
        for (String each : this.xaDriverClassNames) {
            try {
                return this.loadXADataSource(each);
            }
            catch (ReflectiveOperationException reflectiveOperationException) {
            }
        }
        throw new XADataSourceInitializeException(this.databaseType);
    }

    private XADataSource loadXADataSource(String xaDataSourceClassName) throws ReflectiveOperationException {
        Class<?> xaDataSourceClass;
        try {
            xaDataSourceClass = Thread.currentThread().getContextClassLoader().loadClass(xaDataSourceClassName);
        }
        catch (ClassNotFoundException ignored) {
            xaDataSourceClass = Class.forName(xaDataSourceClassName);
        }
        return (XADataSource)xaDataSourceClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
    }

    private Map<String, Object> getDatabaseAccessConfiguration(DataSource dataSource) {
        HashMap<String, Object> result = new HashMap<String, Object>(3, 1.0f);
        Map standardProps = DataSourcePoolPropertiesCreator.create((DataSource)(dataSource instanceof CatalogSwitchableDataSource ? ((CatalogSwitchableDataSource)dataSource).getDataSource() : dataSource)).getAllStandardProperties();
        result.put("url", dataSource instanceof CatalogSwitchableDataSource ? ((CatalogSwitchableDataSource)dataSource).getUrl() : standardProps.get("url"));
        result.put("user", standardProps.get("username"));
        result.put("password", standardProps.get("password"));
        return result;
    }

    private void setProperties(XADataSource xaDataSource, Map<String, Object> databaseAccessConfig) {
        for (Map.Entry<String, Object> entry : databaseAccessConfig.entrySet()) {
            Optional<Method> method = this.findSetterMethod(xaDataSource.getClass().getMethods(), entry.getKey());
            if (!method.isPresent()) continue;
            method.get().invoke((Object)xaDataSource, entry.getValue());
        }
    }

    private Optional<Method> findSetterMethod(Method[] methods, String property) {
        String setterMethodName = SETTER_PREFIX + CaseFormat.LOWER_CAMEL.to(CaseFormat.UPPER_CAMEL, property);
        return Arrays.stream(methods).filter(each -> each.getName().equals(setterMethodName) && 1 == each.getParameterTypes().length).findFirst();
    }

    @Generated
    public DataSourceSwapper(DatabaseType databaseType, Collection<String> xaDriverClassNames) {
        this.databaseType = databaseType;
        this.xaDriverClassNames = xaDriverClassNames;
    }
}

