/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.transaction.xa.jta.connection.dialect;

import java.lang.reflect.Constructor;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Properties;
import javax.sql.XAConnection;
import javax.sql.XADataSource;
import org.apache.shardingsphere.transaction.xa.jta.connection.XAConnectionWrapper;

public final class FirebirdXAConnectionWrapper
implements XAConnectionWrapper {
    private Class<Connection> jdbcConnectionClass;
    private Constructor<?> xaConnectionConstructor;

    @Override
    public XAConnection wrap(XADataSource xaDataSource, Connection connection) throws SQLException {
        return this.createXAConnection(connection.unwrap(this.jdbcConnectionClass));
    }

    public void init(Properties props) {
        this.loadReflection();
    }

    private void loadReflection() {
        this.jdbcConnectionClass = this.getJDBCConnectionClass();
        this.xaConnectionConstructor = this.getXAConnectionConstructor();
    }

    private Class<Connection> getJDBCConnectionClass() {
        return Class.forName("org.firebirdsql.jdbc.FBConnection");
    }

    private Constructor<?> getXAConnectionConstructor() {
        return Class.forName("org.firebirdsql.ds.FBXAConnection").getDeclaredConstructor(Class.forName("org.firebirdsql.jdbc.FBConnection"));
    }

    private XAConnection createXAConnection(Connection connection) {
        this.xaConnectionConstructor.setAccessible(true);
        return (XAConnection)this.xaConnectionConstructor.newInstance(connection);
    }

    public String getDatabaseType() {
        return "Firebird";
    }
}

