/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.distsql.segment.converter;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import lombok.Generated;
import org.apache.shardingsphere.database.connector.core.type.DatabaseType;
import org.apache.shardingsphere.distsql.segment.DataSourceSegment;
import org.apache.shardingsphere.distsql.segment.HostnameAndPortBasedDataSourceSegment;
import org.apache.shardingsphere.distsql.segment.URLBasedDataSourceSegment;
import org.apache.shardingsphere.infra.datasource.pool.props.domain.DataSourcePoolProperties;

public final class DataSourceSegmentsConverter {
    public static Map<String, DataSourcePoolProperties> convert(DatabaseType databaseType, Collection<DataSourceSegment> dataSourceSegments) {
        LinkedHashMap<String, DataSourcePoolProperties> result = new LinkedHashMap<String, DataSourcePoolProperties>(dataSourceSegments.size(), 1.0f);
        for (DataSourceSegment each : dataSourceSegments) {
            result.put(each.getName(), new DataSourcePoolProperties("com.zaxxer.hikari.HikariDataSource", DataSourceSegmentsConverter.createProperties(databaseType, each)));
        }
        return result;
    }

    private static Map<String, Object> createProperties(DatabaseType databaseType, DataSourceSegment segment) {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        result.put("jdbcUrl", DataSourceSegmentsConverter.getURL(databaseType, segment));
        result.put("username", segment.getUser());
        result.put("password", segment.getPassword());
        if (null != segment.getProps()) {
            result.putAll(segment.getProps());
        }
        return result;
    }

    private static String getURL(DatabaseType databaseType, DataSourceSegment segment) {
        String result = null;
        if (segment instanceof URLBasedDataSourceSegment) {
            result = ((URLBasedDataSourceSegment)segment).getUrl();
        }
        if (segment instanceof HostnameAndPortBasedDataSourceSegment) {
            HostnameAndPortBasedDataSourceSegment actualSegment = (HostnameAndPortBasedDataSourceSegment)segment;
            result = String.format("%s//%s:%s/%s", databaseType.getJdbcUrlPrefixes().iterator().next(), actualSegment.getHostname(), actualSegment.getPort(), actualSegment.getDatabase());
        }
        return result;
    }

    @Generated
    private DataSourceSegmentsConverter() {
    }
}

