/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sql.parser.engine.mysql.visitor.statement.type;

import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.misc.Interval;
import org.antlr.v4.runtime.tree.ParseTree;
import org.apache.shardingsphere.database.connector.core.type.DatabaseType;
import org.apache.shardingsphere.sql.parser.api.ASTNode;
import org.apache.shardingsphere.sql.parser.api.visitor.statement.type.DDLStatementVisitor;
import org.apache.shardingsphere.sql.parser.autogen.MySQLStatementParser;
import org.apache.shardingsphere.sql.parser.engine.mysql.visitor.statement.MySQLStatementVisitor;
import org.apache.shardingsphere.sql.parser.engine.mysql.visitor.statement.type.MySQLDALStatementVisitor;
import org.apache.shardingsphere.sql.parser.engine.mysql.visitor.statement.type.MySQLTCLStatementVisitor;
import org.apache.shardingsphere.sql.parser.statement.core.enums.AlgorithmOption;
import org.apache.shardingsphere.sql.parser.statement.core.enums.LockTableOption;
import org.apache.shardingsphere.sql.parser.statement.core.segment.ddl.AlterDefinitionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.ddl.CreateDefinitionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.ddl.charset.CharsetNameSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.ddl.column.ColumnDefinitionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.ddl.column.alter.AddColumnDefinitionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.ddl.column.alter.ChangeColumnDefinitionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.ddl.column.alter.DropColumnDefinitionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.ddl.column.alter.ModifyColumnDefinitionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.ddl.column.alter.RenameColumnSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.ddl.column.position.ColumnAfterPositionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.ddl.column.position.ColumnFirstPositionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.ddl.column.position.ColumnPositionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.ddl.constraint.ConstraintDefinitionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.ddl.constraint.ConstraintSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.ddl.constraint.alter.AddConstraintDefinitionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.ddl.constraint.alter.DropConstraintDefinitionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.ddl.constraint.alter.ModifyConstraintDefinitionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.ddl.engine.EngineSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.ddl.index.DropIndexDefinitionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.ddl.index.IndexNameSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.ddl.index.IndexSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.ddl.index.RenameIndexDefinitionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.ddl.primary.DropPrimaryKeyDefinitionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.ddl.routine.FunctionNameSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.ddl.routine.RoutineBodySegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.ddl.routine.ValidStatementSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.ddl.table.AlgorithmTypeSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.ddl.table.ConvertTableDefinitionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.ddl.table.CreateTableOptionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.ddl.table.LockTableSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.ddl.table.RenameTableDefinitionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.ddl.tablespace.TablespaceSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.column.ColumnSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.expr.ExpressionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.expr.simple.SimpleExpressionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.generic.CommentSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.generic.DataTypeSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.generic.OwnerSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.generic.table.SimpleTableSegment;
import org.apache.shardingsphere.sql.parser.statement.core.statement.SQLStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.dal.AnalyzeTableStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.dal.ExplainStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.ddl.DeallocateStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.ddl.ExecuteStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.ddl.PrepareStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.ddl.TruncateStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.ddl.database.AlterDatabaseStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.ddl.database.CreateDatabaseStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.ddl.database.DropDatabaseStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.ddl.function.AlterFunctionStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.ddl.function.CreateFunctionStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.ddl.function.DropFunctionStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.ddl.index.CreateIndexStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.ddl.index.DropIndexStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.ddl.procedure.AlterProcedureStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.ddl.procedure.CreateProcedureStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.ddl.procedure.DropProcedureStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.ddl.server.AlterServerStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.ddl.server.CreateServerStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.ddl.server.DropServerStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.ddl.table.AlterTableStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.ddl.table.CreateTableStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.ddl.table.DropTableStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.ddl.table.RenameTableStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.ddl.tablespace.AlterTablespaceStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.ddl.tablespace.CreateTablespaceStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.ddl.tablespace.DropTablespaceStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.ddl.trigger.CreateTriggerStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.ddl.trigger.DropTriggerStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.ddl.view.AlterViewStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.ddl.view.CreateViewStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.ddl.view.DropViewStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.dml.DeleteStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.dml.DoStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.dml.InsertStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.dml.SelectStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.dml.UpdateStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.tcl.StartTransactionStatement;
import org.apache.shardingsphere.sql.parser.statement.core.value.collection.CollectionValue;
import org.apache.shardingsphere.sql.parser.statement.core.value.identifier.IdentifierValue;
import org.apache.shardingsphere.sql.parser.statement.mysql.dal.show.column.MySQLDescribeStatement;
import org.apache.shardingsphere.sql.parser.statement.mysql.ddl.event.MySQLAlterEventStatement;
import org.apache.shardingsphere.sql.parser.statement.mysql.ddl.event.MySQLCreateEventStatement;
import org.apache.shardingsphere.sql.parser.statement.mysql.ddl.event.MySQLDropEventStatement;
import org.apache.shardingsphere.sql.parser.statement.mysql.ddl.instance.MySQLAlterInstanceStatement;
import org.apache.shardingsphere.sql.parser.statement.mysql.ddl.logfile.MySQLAlterLogfileGroupStatement;
import org.apache.shardingsphere.sql.parser.statement.mysql.ddl.logfile.MySQLCreateLogfileGroupStatement;
import org.apache.shardingsphere.sql.parser.statement.mysql.ddl.logfile.MySQLDropLogfileGroupStatement;

public final class MySQLDDLStatementVisitor
extends MySQLStatementVisitor
implements DDLStatementVisitor {
    private final MySQLDALStatementVisitor dalStatementVisitor;
    private final MySQLTCLStatementVisitor tclStatementVisitor;

    public MySQLDDLStatementVisitor(DatabaseType databaseType) {
        super(databaseType);
        this.dalStatementVisitor = new MySQLDALStatementVisitor(databaseType);
        this.tclStatementVisitor = new MySQLTCLStatementVisitor(databaseType);
    }

    @Override
    public ASTNode visitCreateView(MySQLStatementParser.CreateViewContext ctx) {
        CreateViewStatement result = new CreateViewStatement(this.getDatabaseType());
        result.setReplaceView(null != ctx.REPLACE());
        result.setView((SimpleTableSegment)this.visit((ParseTree)ctx.viewName()));
        result.setViewDefinition(this.getOriginalText(ctx.select()));
        result.setSelect((SelectStatement)this.visit((ParseTree)ctx.select()));
        return result;
    }

    @Override
    public ASTNode visitAlterView(MySQLStatementParser.AlterViewContext ctx) {
        AlterViewStatement result = new AlterViewStatement(this.getDatabaseType());
        result.setView((SimpleTableSegment)this.visit((ParseTree)ctx.viewName()));
        result.setViewDefinition(this.getOriginalText(ctx.select()));
        result.setSelect((SelectStatement)this.visit((ParseTree)ctx.select()));
        return result;
    }

    @Override
    public ASTNode visitDropView(MySQLStatementParser.DropViewContext ctx) {
        DropViewStatement result = new DropViewStatement(this.getDatabaseType());
        result.setIfExists(null != ctx.ifExists());
        result.getViews().addAll(((CollectionValue)this.visit((ParseTree)ctx.viewNames())).getValue());
        return result;
    }

    @Override
    public ASTNode visitCreateDatabase(MySQLStatementParser.CreateDatabaseContext ctx) {
        return new CreateDatabaseStatement(this.getDatabaseType(), new IdentifierValue(ctx.databaseName().getText()).getValue(), null != ctx.ifNotExists());
    }

    @Override
    public ASTNode visitAlterDatabase(MySQLStatementParser.AlterDatabaseContext ctx) {
        return new AlterDatabaseStatement(this.getDatabaseType());
    }

    @Override
    public ASTNode visitDropDatabase(MySQLStatementParser.DropDatabaseContext ctx) {
        return new DropDatabaseStatement(this.getDatabaseType(), new IdentifierValue(ctx.databaseName().getText()).getValue(), null != ctx.ifExists());
    }

    @Override
    public ASTNode visitCreateTable(MySQLStatementParser.CreateTableContext ctx) {
        CreateTableStatement result = new CreateTableStatement(this.getDatabaseType());
        result.setTable((SimpleTableSegment)this.visit((ParseTree)ctx.tableName()));
        result.setIfNotExists(null != ctx.ifNotExists());
        if (null != ctx.createDefinitionClause()) {
            CollectionValue createDefinitions = (CollectionValue)this.visit((ParseTree)ctx.createDefinitionClause());
            for (CreateDefinitionSegment each : createDefinitions.getValue()) {
                if (each instanceof ColumnDefinitionSegment) {
                    result.getColumnDefinitions().add((ColumnDefinitionSegment)each);
                    continue;
                }
                if (!(each instanceof ConstraintDefinitionSegment)) continue;
                result.getConstraintDefinitions().add((ConstraintDefinitionSegment)each);
            }
        }
        if (null != ctx.createLikeClause()) {
            result.setLikeTable((SimpleTableSegment)this.visit((ParseTree)ctx.createLikeClause()));
        }
        if (null != ctx.createTableOptions()) {
            result.setCreateTableOption((CreateTableOptionSegment)this.visit((ParseTree)ctx.createTableOptions()));
        }
        return result;
    }

    @Override
    public ASTNode visitCreateTableOptions(MySQLStatementParser.CreateTableOptionsContext ctx) {
        CreateTableOptionSegment result = new CreateTableOptionSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex());
        for (MySQLStatementParser.CreateTableOptionContext each : ctx.createTableOption()) {
            if (null != each.engineRef()) {
                result.setEngine((EngineSegment)this.visit((ParseTree)each.engineRef()));
                continue;
            }
            if (null != each.COMMENT()) {
                result.setCommentSegment(new CommentSegment(each.string_().getText(), each.string_().getStart().getStartIndex(), each.string_().getStop().getStopIndex()));
                continue;
            }
            if (null != each.defaultCharset()) {
                Optional.ofNullable(each.defaultCharset().charsetName()).map(MySQLStatementParser.CharsetNameContext::textOrIdentifier).map(MySQLStatementParser.TextOrIdentifierContext::identifier).ifPresent(optional -> result.setCharsetName(optional.getText()));
                continue;
            }
            if (null == each.defaultCollation()) continue;
            Optional.ofNullable(each.defaultCollation().collationName()).map(MySQLStatementParser.CollationNameContext::textOrIdentifier).map(MySQLStatementParser.TextOrIdentifierContext::identifier).ifPresent(optional -> result.setCollateName(optional.getText()));
        }
        return result;
    }

    @Override
    public ASTNode visitCreateDefinitionClause(MySQLStatementParser.CreateDefinitionClauseContext ctx) {
        CollectionValue result = new CollectionValue();
        for (MySQLStatementParser.TableElementContext each : ctx.tableElementList().tableElement()) {
            if (null != each.columnDefinition()) {
                result.getValue().add((ColumnDefinitionSegment)this.visit((ParseTree)each.columnDefinition()));
            }
            if (null == each.tableConstraintDef()) continue;
            result.getValue().add((ConstraintDefinitionSegment)this.visit((ParseTree)each.tableConstraintDef()));
        }
        return result;
    }

    @Override
    public ASTNode visitCreateLikeClause(MySQLStatementParser.CreateLikeClauseContext ctx) {
        return (ASTNode)this.visit((ParseTree)ctx.tableName());
    }

    @Override
    public ASTNode visitAlterTable(MySQLStatementParser.AlterTableContext ctx) {
        AlterTableStatement result = new AlterTableStatement(this.getDatabaseType());
        result.setTable((SimpleTableSegment)this.visit((ParseTree)ctx.tableName()));
        if (null == ctx.alterTableActions() || null == ctx.alterTableActions().alterCommandList() || null == ctx.alterTableActions().alterCommandList().alterList()) {
            return result;
        }
        for (AlterDefinitionSegment each : ((CollectionValue)this.visit((ParseTree)ctx.alterTableActions().alterCommandList().alterList())).getValue()) {
            this.setAlterDefinition(result, each);
        }
        return result;
    }

    private void setAlterDefinition(AlterTableStatement alterTableStatement, AlterDefinitionSegment alterDefinitionSegment) {
        if (alterDefinitionSegment instanceof AddColumnDefinitionSegment) {
            alterTableStatement.getAddColumnDefinitions().add((AddColumnDefinitionSegment)alterDefinitionSegment);
        } else if (alterDefinitionSegment instanceof ModifyColumnDefinitionSegment) {
            alterTableStatement.getModifyColumnDefinitions().add((ModifyColumnDefinitionSegment)alterDefinitionSegment);
        } else if (alterDefinitionSegment instanceof ChangeColumnDefinitionSegment) {
            alterTableStatement.getChangeColumnDefinitions().add((ChangeColumnDefinitionSegment)alterDefinitionSegment);
        } else if (alterDefinitionSegment instanceof DropColumnDefinitionSegment) {
            alterTableStatement.getDropColumnDefinitions().add((DropColumnDefinitionSegment)alterDefinitionSegment);
        } else if (alterDefinitionSegment instanceof AddConstraintDefinitionSegment) {
            alterTableStatement.getAddConstraintDefinitions().add((AddConstraintDefinitionSegment)alterDefinitionSegment);
        } else if (alterDefinitionSegment instanceof DropConstraintDefinitionSegment) {
            alterTableStatement.getDropConstraintDefinitions().add((DropConstraintDefinitionSegment)alterDefinitionSegment);
        } else if (alterDefinitionSegment instanceof RenameTableDefinitionSegment) {
            alterTableStatement.setRenameTable(((RenameTableDefinitionSegment)alterDefinitionSegment).getRenameTable());
        } else if (alterDefinitionSegment instanceof ConvertTableDefinitionSegment) {
            alterTableStatement.setConvertTableDefinition((ConvertTableDefinitionSegment)alterDefinitionSegment);
        } else if (alterDefinitionSegment instanceof DropIndexDefinitionSegment) {
            alterTableStatement.getDropIndexDefinitions().add((DropIndexDefinitionSegment)alterDefinitionSegment);
        } else if (alterDefinitionSegment instanceof RenameIndexDefinitionSegment) {
            alterTableStatement.getRenameIndexDefinitions().add((RenameIndexDefinitionSegment)alterDefinitionSegment);
        } else if (alterDefinitionSegment instanceof RenameColumnSegment) {
            alterTableStatement.getRenameColumnDefinitions().add((RenameColumnSegment)alterDefinitionSegment);
        } else if (alterDefinitionSegment instanceof AlgorithmTypeSegment) {
            alterTableStatement.setAlgorithmSegment((AlgorithmTypeSegment)alterDefinitionSegment);
        } else if (alterDefinitionSegment instanceof LockTableSegment) {
            alterTableStatement.setLockTableSegment((LockTableSegment)alterDefinitionSegment);
        } else if (alterDefinitionSegment instanceof DropPrimaryKeyDefinitionSegment) {
            alterTableStatement.setDropPrimaryKeyDefinition((DropPrimaryKeyDefinitionSegment)alterDefinitionSegment);
        }
    }

    private ColumnDefinitionSegment generateColumnDefinitionSegment(ColumnSegment column, MySQLStatementParser.FieldDefinitionContext ctx) {
        DataTypeSegment dataTypeSegment = (DataTypeSegment)this.visit((ParseTree)ctx.dataType());
        boolean isPrimaryKey = ctx.columnAttribute().stream().anyMatch(each -> null != each.KEY() && null == each.UNIQUE());
        boolean isAutoIncrement = ctx.columnAttribute().stream().anyMatch(each -> null != each.AUTO_INCREMENT());
        ColumnDefinitionSegment result = new ColumnDefinitionSegment(column.getStartIndex(), ctx.getStop().getStopIndex(), column, dataTypeSegment, isPrimaryKey, false, this.getText(ctx));
        result.setAutoIncrement(isAutoIncrement);
        return result;
    }

    private String getText(ParserRuleContext ctx) {
        return ctx.start.getInputStream().getText(new Interval(ctx.start.getStartIndex(), ctx.stop.getStopIndex()));
    }

    @Override
    public ASTNode visitAlterConstraint(MySQLStatementParser.AlterConstraintContext ctx) {
        return new ModifyConstraintDefinitionSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), (ConstraintSegment)this.visit((ParseTree)ctx.constraintName()));
    }

    @Override
    public ASTNode visitAlterList(MySQLStatementParser.AlterListContext ctx) {
        CollectionValue result = new CollectionValue();
        if (ctx.alterListItem().isEmpty()) {
            return result;
        }
        result.getValue().addAll(this.getAlterDefinitionSegments(ctx));
        for (MySQLStatementParser.AlterCommandsModifierContext each : ctx.alterCommandsModifier()) {
            if (null != each.alterAlgorithmOption()) {
                result.getValue().add((AlgorithmTypeSegment)this.visit((ParseTree)each));
                continue;
            }
            if (null == each.alterLockOption()) continue;
            result.getValue().add((LockTableSegment)this.visit((ParseTree)each));
        }
        return result;
    }

    private Collection<AlterDefinitionSegment> getAlterDefinitionSegments(MySQLStatementParser.AlterListContext ctx) {
        LinkedList<AlterDefinitionSegment> result = new LinkedList<AlterDefinitionSegment>();
        for (MySQLStatementParser.AlterListItemContext each : ctx.alterListItem()) {
            this.getAlterDefinitionSegment(ctx, each).ifPresent(result::add);
        }
        return result;
    }

    private Optional<AlterDefinitionSegment> getAlterDefinitionSegment(MySQLStatementParser.AlterListContext alterListContext, MySQLStatementParser.AlterListItemContext alterListItemContext) {
        if (alterListItemContext instanceof MySQLStatementParser.AddColumnContext) {
            return Optional.of((AddColumnDefinitionSegment)this.visit((ParseTree)alterListItemContext));
        }
        if (alterListItemContext instanceof MySQLStatementParser.AlterConstraintContext || alterListItemContext instanceof MySQLStatementParser.AlterCheckContext) {
            return Optional.of((AlterDefinitionSegment)this.visit((ParseTree)alterListItemContext));
        }
        if (alterListItemContext instanceof MySQLStatementParser.ChangeColumnContext) {
            return Optional.of(this.generateModifyColumnDefinitionSegment((MySQLStatementParser.ChangeColumnContext)alterListItemContext));
        }
        if (alterListItemContext instanceof MySQLStatementParser.ModifyColumnContext) {
            return Optional.of(this.generateModifyColumnDefinitionSegment((MySQLStatementParser.ModifyColumnContext)alterListItemContext));
        }
        if (alterListItemContext instanceof MySQLStatementParser.AlterTableDropContext) {
            return this.getDropItemDefinitionSegment(alterListContext, (MySQLStatementParser.AlterTableDropContext)alterListItemContext);
        }
        if (alterListItemContext instanceof MySQLStatementParser.AddTableConstraintContext) {
            return Optional.of((AddConstraintDefinitionSegment)this.visit((ParseTree)alterListItemContext));
        }
        if (alterListItemContext instanceof MySQLStatementParser.AlterRenameTableContext) {
            return Optional.of((RenameTableDefinitionSegment)this.visit((ParseTree)alterListItemContext));
        }
        if (alterListItemContext instanceof MySQLStatementParser.AlterConvertContext) {
            return Optional.of((ConvertTableDefinitionSegment)this.visit((ParseTree)alterListItemContext));
        }
        if (alterListItemContext instanceof MySQLStatementParser.RenameColumnContext) {
            return Optional.of((RenameColumnSegment)this.visit((ParseTree)alterListItemContext));
        }
        if (alterListItemContext instanceof MySQLStatementParser.RenameIndexContext) {
            return Optional.of((RenameIndexDefinitionSegment)this.visit((ParseTree)alterListItemContext));
        }
        return Optional.empty();
    }

    private Optional<AlterDefinitionSegment> getDropItemDefinitionSegment(MySQLStatementParser.AlterListContext alterListContext, MySQLStatementParser.AlterTableDropContext alterTableDrop) {
        if (null != alterTableDrop.CHECK() || null != alterTableDrop.CONSTRAINT()) {
            ConstraintSegment constraint = new ConstraintSegment(alterTableDrop.identifier().getStart().getStartIndex(), alterTableDrop.identifier().getStop().getStopIndex(), (IdentifierValue)this.visit((ParseTree)alterTableDrop.identifier()));
            return Optional.of(new DropConstraintDefinitionSegment(alterListContext.getStart().getStartIndex(), alterListContext.getStop().getStopIndex(), constraint));
        }
        if (null != alterTableDrop.PRIMARY() && null != alterTableDrop.KEY()) {
            return Optional.of(new DropPrimaryKeyDefinitionSegment(alterListContext.getStart().getStartIndex(), alterListContext.getStop().getStopIndex()));
        }
        if (null == alterTableDrop.KEY() && null == alterTableDrop.keyOrIndex()) {
            ColumnSegment column = new ColumnSegment(alterTableDrop.columnInternalRef.start.getStartIndex(), alterTableDrop.columnInternalRef.stop.getStopIndex(), (IdentifierValue)this.visit((ParseTree)alterTableDrop.columnInternalRef));
            return Optional.of(new DropColumnDefinitionSegment(alterTableDrop.getStart().getStartIndex(), alterTableDrop.getStop().getStopIndex(), Collections.singleton(column)));
        }
        if (null != alterTableDrop.keyOrIndex()) {
            return Optional.of(new DropIndexDefinitionSegment(alterListContext.getStart().getStartIndex(), alterListContext.getStop().getStopIndex(), (IndexSegment)this.visit((ParseTree)alterTableDrop.indexName())));
        }
        return Optional.empty();
    }

    @Override
    public ASTNode visitAlterAlgorithmOption(MySQLStatementParser.AlterAlgorithmOptionContext ctx) {
        AlgorithmOption algorithmOption = null;
        if (null != ctx.INSTANT()) {
            algorithmOption = AlgorithmOption.INSTANT;
        } else if (null != ctx.DEFAULT()) {
            algorithmOption = AlgorithmOption.DEFAULT;
        } else if (null != ctx.INPLACE()) {
            algorithmOption = AlgorithmOption.INPLACE;
        } else if (null != ctx.COPY()) {
            algorithmOption = AlgorithmOption.COPY;
        }
        return new AlgorithmTypeSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), algorithmOption);
    }

    @Override
    public ASTNode visitAlterLockOption(MySQLStatementParser.AlterLockOptionContext ctx) {
        LockTableOption lockOption = null;
        if (null != ctx.DEFAULT()) {
            lockOption = LockTableOption.DEFAULT;
        } else if (null != ctx.NONE()) {
            lockOption = LockTableOption.NONE;
        } else if (null != ctx.SHARED()) {
            lockOption = LockTableOption.SHARED;
        } else if (null != ctx.EXCLUSIVE()) {
            lockOption = LockTableOption.EXCLUSIVE;
        }
        return new LockTableSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), lockOption);
    }

    @Override
    public ASTNode visitAlterConvert(MySQLStatementParser.AlterConvertContext ctx) {
        ConvertTableDefinitionSegment result = new ConvertTableDefinitionSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), (CharsetNameSegment)this.visit((ParseTree)ctx.charsetName()));
        if (null != ctx.collateClause()) {
            result.setCollateValue((SimpleExpressionSegment)this.visit((ParseTree)ctx.collateClause()));
        }
        return result;
    }

    @Override
    public ASTNode visitCharsetName(MySQLStatementParser.CharsetNameContext ctx) {
        return new CharsetNameSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), ctx.getText());
    }

    @Override
    public ASTNode visitAddTableConstraint(MySQLStatementParser.AddTableConstraintContext ctx) {
        return new AddConstraintDefinitionSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), (ConstraintDefinitionSegment)this.visit((ParseTree)ctx.tableConstraintDef()));
    }

    @Override
    public ASTNode visitAlterCheck(MySQLStatementParser.AlterCheckContext ctx) {
        return new ModifyConstraintDefinitionSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), (ConstraintSegment)this.visit((ParseTree)ctx.constraintName()));
    }

    @Override
    public ASTNode visitAlterRenameTable(MySQLStatementParser.AlterRenameTableContext ctx) {
        RenameTableDefinitionSegment result = new RenameTableDefinitionSegment(ctx.start.getStartIndex(), ctx.stop.getStopIndex());
        result.setRenameTable((SimpleTableSegment)this.visit((ParseTree)ctx.tableName()));
        return result;
    }

    @Override
    public ASTNode visitRenameTable(MySQLStatementParser.RenameTableContext ctx) {
        LinkedList<RenameTableDefinitionSegment> renameTables = new LinkedList<RenameTableDefinitionSegment>();
        int len = ctx.tableName().size();
        for (int i = 0; i < len; i += 2) {
            MySQLStatementParser.TableNameContext tableName = ctx.tableName(i);
            MySQLStatementParser.TableNameContext renameTableName = ctx.tableName(i + 1);
            renameTables.add(this.createRenameTableDefinitionSegment(tableName, renameTableName));
        }
        return new RenameTableStatement(this.getDatabaseType(), renameTables);
    }

    private RenameTableDefinitionSegment createRenameTableDefinitionSegment(MySQLStatementParser.TableNameContext tableName, MySQLStatementParser.TableNameContext renameTableName) {
        RenameTableDefinitionSegment result = new RenameTableDefinitionSegment(tableName.start.getStartIndex(), renameTableName.stop.getStopIndex());
        result.setTable((SimpleTableSegment)this.visit((ParseTree)tableName));
        result.setRenameTable((SimpleTableSegment)this.visit((ParseTree)renameTableName));
        return result;
    }

    private ModifyColumnDefinitionSegment generateModifyColumnDefinitionSegment(MySQLStatementParser.ModifyColumnContext ctx) {
        ColumnSegment column = new ColumnSegment(ctx.columnInternalRef.start.getStartIndex(), ctx.columnInternalRef.stop.getStopIndex(), (IdentifierValue)this.visit((ParseTree)ctx.columnInternalRef));
        ModifyColumnDefinitionSegment result = new ModifyColumnDefinitionSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), this.generateColumnDefinitionSegment(column, ctx.fieldDefinition()));
        if (null != ctx.place()) {
            result.setColumnPosition((ColumnPositionSegment)this.visit((ParseTree)ctx.place()));
        }
        return result;
    }

    private ChangeColumnDefinitionSegment generateModifyColumnDefinitionSegment(MySQLStatementParser.ChangeColumnContext ctx) {
        ChangeColumnDefinitionSegment result = new ChangeColumnDefinitionSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), (ColumnDefinitionSegment)this.visit((ParseTree)ctx.columnDefinition()));
        result.setPreviousColumn(new ColumnSegment(ctx.columnInternalRef.getStart().getStartIndex(), ctx.columnInternalRef.getStop().getStopIndex(), new IdentifierValue(ctx.columnInternalRef.getText())));
        if (null != ctx.place()) {
            result.setColumnPosition((ColumnPositionSegment)this.visit((ParseTree)ctx.place()));
        }
        return result;
    }

    @Override
    public ASTNode visitAddColumn(MySQLStatementParser.AddColumnContext ctx) {
        LinkedList<ColumnDefinitionSegment> columnDefinitions = new LinkedList<ColumnDefinitionSegment>();
        if (null != ctx.columnDefinition()) {
            columnDefinitions.add((ColumnDefinitionSegment)this.visit((ParseTree)ctx.columnDefinition()));
        }
        if (null != ctx.tableElementList()) {
            for (MySQLStatementParser.TableElementContext each : ctx.tableElementList().tableElement()) {
                if (null == each.columnDefinition()) continue;
                columnDefinitions.add((ColumnDefinitionSegment)this.visit((ParseTree)each.columnDefinition()));
            }
        }
        AddColumnDefinitionSegment result = new AddColumnDefinitionSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), columnDefinitions);
        if (null != ctx.place()) {
            Preconditions.checkState((1 == columnDefinitions.size() ? 1 : 0) != 0);
            result.setColumnPosition((ColumnPositionSegment)this.visit((ParseTree)ctx.place()));
        }
        return result;
    }

    @Override
    public ASTNode visitRenameColumn(MySQLStatementParser.RenameColumnContext ctx) {
        ColumnSegment oldColumnSegment = (ColumnSegment)this.visit((ParseTree)ctx.oldColumn());
        ColumnSegment newColumnSegment = (ColumnSegment)this.visit((ParseTree)ctx.newColumn());
        return new RenameColumnSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), oldColumnSegment, newColumnSegment);
    }

    @Override
    public ASTNode visitColumnDefinition(MySQLStatementParser.ColumnDefinitionContext ctx) {
        ColumnSegment column = new ColumnSegment(ctx.column_name.start.getStartIndex(), ctx.column_name.stop.getStopIndex(), (IdentifierValue)this.visit((ParseTree)ctx.column_name));
        DataTypeSegment dataTypeSegment = (DataTypeSegment)this.visit((ParseTree)ctx.fieldDefinition().dataType());
        boolean isPrimaryKey = ctx.fieldDefinition().columnAttribute().stream().anyMatch(each -> null != each.KEY() && null == each.UNIQUE());
        boolean isAutoIncrement = ctx.fieldDefinition().columnAttribute().stream().anyMatch(each -> null != each.AUTO_INCREMENT());
        boolean isNotNull = ctx.fieldDefinition().columnAttribute().stream().anyMatch(each -> null != each.NOT() && null != each.NULL());
        ColumnDefinitionSegment result = new ColumnDefinitionSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), column, dataTypeSegment, isPrimaryKey, isNotNull, this.getText(ctx));
        result.getReferencedTables().addAll(this.getReferencedTables(ctx));
        result.setAutoIncrement(isAutoIncrement);
        if (null != ctx.fieldDefinition().dataType().charsetWithOptBinary()) {
            result.setCharsetName(ctx.fieldDefinition().dataType().charsetWithOptBinary().charsetName().textOrIdentifier().identifier().IDENTIFIER_().getText());
        }
        ctx.fieldDefinition().columnAttribute().stream().filter(each -> null != each.collateClause()).findFirst().ifPresent(optional -> result.setCollateName(optional.collateClause().collationName().textOrIdentifier().identifier().IDENTIFIER_().getText()));
        return result;
    }

    private Collection<SimpleTableSegment> getReferencedTables(MySQLStatementParser.ColumnDefinitionContext ctx) {
        LinkedList<SimpleTableSegment> result = new LinkedList<SimpleTableSegment>();
        if (null != ctx.referenceDefinition()) {
            result.add((SimpleTableSegment)this.visit((ParseTree)ctx.referenceDefinition()));
        }
        return result;
    }

    @Override
    public ASTNode visitTableConstraintDef(MySQLStatementParser.TableConstraintDefContext ctx) {
        ConstraintDefinitionSegment result = new ConstraintDefinitionSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex());
        if (null != ctx.constraintClause() && null != ctx.constraintClause().constraintName()) {
            result.setConstraintName((ConstraintSegment)this.visit((ParseTree)ctx.constraintClause().constraintName()));
        }
        if (null != ctx.KEY() && null != ctx.PRIMARY()) {
            result.setPrimaryKey(true);
            result.getPrimaryKeyColumns().addAll(((CollectionValue)this.visit((ParseTree)ctx.keyListWithExpression())).getValue());
            return result;
        }
        if (null != ctx.FOREIGN()) {
            result.setReferencedTable((SimpleTableSegment)this.visit((ParseTree)ctx.referenceDefinition()));
            return result;
        }
        if (null != ctx.UNIQUE()) {
            result.setUniqueKey(true);
            result.getIndexColumns().addAll(((CollectionValue)this.visit((ParseTree)ctx.keyListWithExpression())).getValue());
            if (null != ctx.indexName()) {
                result.setIndexName((IndexSegment)this.visit((ParseTree)ctx.indexName()));
            }
            return result;
        }
        if (null != ctx.checkConstraint()) {
            return result;
        }
        result.getIndexColumns().addAll(((CollectionValue)this.visit((ParseTree)ctx.keyListWithExpression())).getValue());
        if (null != ctx.indexName()) {
            result.setIndexName((IndexSegment)this.visit((ParseTree)ctx.indexName()));
        }
        return result;
    }

    @Override
    public ASTNode visitKeyListWithExpression(MySQLStatementParser.KeyListWithExpressionContext ctx) {
        CollectionValue result = new CollectionValue();
        for (MySQLStatementParser.KeyPartWithExpressionContext each : ctx.keyPartWithExpression()) {
            if (null == each.keyPart()) continue;
            result.getValue().add((ColumnSegment)this.visit((ParseTree)each.keyPart().columnName()));
        }
        return result;
    }

    @Override
    public ASTNode visitReferenceDefinition(MySQLStatementParser.ReferenceDefinitionContext ctx) {
        return (ASTNode)this.visit((ParseTree)ctx.tableName());
    }

    @Override
    public ASTNode visitPlace(MySQLStatementParser.PlaceContext ctx) {
        ColumnSegment columnName = null;
        if (null != ctx.columnName()) {
            columnName = (ColumnSegment)this.visit((ParseTree)ctx.columnName());
        }
        return null == ctx.columnName() ? new ColumnFirstPositionSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), columnName) : new ColumnAfterPositionSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), columnName);
    }

    @Override
    public ASTNode visitDropTable(MySQLStatementParser.DropTableContext ctx) {
        DropTableStatement result = new DropTableStatement(this.getDatabaseType());
        result.setIfExists(null != ctx.ifExists());
        result.getTables().addAll(((CollectionValue)this.visit((ParseTree)ctx.tableList())).getValue());
        return result;
    }

    @Override
    public ASTNode visitTruncateTable(MySQLStatementParser.TruncateTableContext ctx) {
        return new TruncateStatement(this.getDatabaseType(), Collections.singleton((SimpleTableSegment)this.visit((ParseTree)ctx.tableName())));
    }

    @Override
    public ASTNode visitCreateIndex(MySQLStatementParser.CreateIndexContext ctx) {
        CreateIndexStatement result = new CreateIndexStatement(this.getDatabaseType());
        result.setTable((SimpleTableSegment)this.visit((ParseTree)ctx.tableName()));
        IndexNameSegment indexName = new IndexNameSegment(ctx.indexName().start.getStartIndex(), ctx.indexName().stop.getStopIndex(), new IdentifierValue(ctx.indexName().getText()));
        result.setIndex(new IndexSegment(ctx.indexName().start.getStartIndex(), ctx.indexName().stop.getStopIndex(), indexName));
        result.getColumns().addAll(((CollectionValue)this.visit((ParseTree)ctx.keyListWithExpression())).getValue());
        if (null != ctx.createIndexSpecification() && null != ctx.createIndexSpecification().UNIQUE()) {
            result.getIndex().setUniqueKey(true);
        }
        if (null != ctx.algorithmOptionAndLockOption()) {
            if (null != ctx.algorithmOptionAndLockOption().alterAlgorithmOption()) {
                result.setAlgorithmType((AlgorithmTypeSegment)this.visit((ParseTree)ctx.algorithmOptionAndLockOption().alterAlgorithmOption()));
            }
            if (null != ctx.algorithmOptionAndLockOption().alterLockOption()) {
                result.setLockTable((LockTableSegment)this.visit((ParseTree)ctx.algorithmOptionAndLockOption().alterLockOption()));
            }
        }
        return result;
    }

    @Override
    public ASTNode visitDropIndex(MySQLStatementParser.DropIndexContext ctx) {
        DropIndexStatement result = new DropIndexStatement(this.getDatabaseType());
        result.setSimpleTable((SimpleTableSegment)this.visit((ParseTree)ctx.tableName()));
        IndexNameSegment indexName = new IndexNameSegment(ctx.indexName().start.getStartIndex(), ctx.indexName().stop.getStopIndex(), new IdentifierValue(ctx.indexName().getText()));
        result.getIndexes().add(new IndexSegment(ctx.indexName().start.getStartIndex(), ctx.indexName().stop.getStopIndex(), indexName));
        if (null != ctx.algorithmOptionAndLockOption()) {
            if (null != ctx.algorithmOptionAndLockOption().alterAlgorithmOption()) {
                result.setAlgorithmType((AlgorithmTypeSegment)this.visit((ParseTree)ctx.algorithmOptionAndLockOption().alterAlgorithmOption()));
            }
            if (null != ctx.algorithmOptionAndLockOption().alterLockOption()) {
                result.setLockTable((LockTableSegment)this.visit((ParseTree)ctx.algorithmOptionAndLockOption().alterLockOption()));
            }
        }
        return result;
    }

    @Override
    public ASTNode visitRenameIndex(MySQLStatementParser.RenameIndexContext ctx) {
        IndexSegment indexNameSegment = (IndexSegment)this.visitIndexName(ctx.indexName(0));
        IndexSegment renameIndexName = (IndexSegment)this.visitIndexName(ctx.indexName(1));
        return new RenameIndexDefinitionSegment(ctx.start.getStartIndex(), ctx.stop.getStopIndex(), indexNameSegment, renameIndexName);
    }

    @Override
    public ASTNode visitKeyParts(MySQLStatementParser.KeyPartsContext ctx) {
        CollectionValue result = new CollectionValue();
        List<MySQLStatementParser.KeyPartContext> keyParts = ctx.keyPart();
        for (MySQLStatementParser.KeyPartContext each : keyParts) {
            if (null == each.columnName()) continue;
            result.getValue().add((ColumnSegment)this.visit((ParseTree)each.columnName()));
        }
        return result;
    }

    @Override
    public ASTNode visitCreateProcedure(MySQLStatementParser.CreateProcedureContext ctx) {
        CreateProcedureStatement result = new CreateProcedureStatement(this.getDatabaseType());
        result.setProcedureName((FunctionNameSegment)this.visit((ParseTree)ctx.functionName()));
        if (null != ctx.routineBody()) {
            result.setRoutineBody((RoutineBodySegment)this.visit((ParseTree)ctx.routineBody()));
        }
        return result;
    }

    @Override
    public ASTNode visitFunctionName(MySQLStatementParser.FunctionNameContext ctx) {
        FunctionNameSegment result = new FunctionNameSegment(ctx.start.getStartIndex(), ctx.stop.getStopIndex(), (IdentifierValue)this.visit((ParseTree)ctx.identifier()));
        if (null != ctx.owner()) {
            result.setOwner((OwnerSegment)this.visit((ParseTree)ctx.owner()));
        }
        return result;
    }

    @Override
    public ASTNode visitAlterProcedure(MySQLStatementParser.AlterProcedureContext ctx) {
        return new AlterProcedureStatement(this.getDatabaseType());
    }

    @Override
    public ASTNode visitDropProcedure(MySQLStatementParser.DropProcedureContext ctx) {
        return new DropProcedureStatement(this.getDatabaseType());
    }

    @Override
    public ASTNode visitCreateFunction(MySQLStatementParser.CreateFunctionContext ctx) {
        CreateFunctionStatement result = new CreateFunctionStatement(this.getDatabaseType());
        result.setFunctionName((FunctionNameSegment)this.visit((ParseTree)ctx.functionName()));
        result.setRoutineBody((RoutineBodySegment)this.visit((ParseTree)ctx.routineBody()));
        return result;
    }

    @Override
    public ASTNode visitRoutineBody(MySQLStatementParser.RoutineBodyContext ctx) {
        RoutineBodySegment result = new RoutineBodySegment(ctx.start.getStartIndex(), ctx.stop.getStopIndex());
        CollectionValue validStatements = null == ctx.simpleStatement() ? (CollectionValue)this.visit((ParseTree)ctx.compoundStatement()) : (CollectionValue)this.visit((ParseTree)ctx.simpleStatement());
        result.getValidStatements().addAll(validStatements.getValue());
        return result;
    }

    @Override
    public ASTNode visitSimpleStatement(MySQLStatementParser.SimpleStatementContext ctx) {
        return (ASTNode)this.visit((ParseTree)ctx.validStatement());
    }

    @Override
    public ASTNode visitCompoundStatement(MySQLStatementParser.CompoundStatementContext ctx) {
        return (ASTNode)this.visit((ParseTree)ctx.beginStatement());
    }

    @Override
    public ASTNode visitBeginStatement(MySQLStatementParser.BeginStatementContext ctx) {
        CollectionValue result = new CollectionValue();
        for (MySQLStatementParser.ValidStatementContext each : ctx.validStatement()) {
            result.combine((CollectionValue)this.visit((ParseTree)each));
        }
        return result;
    }

    @Override
    public ASTNode visitValidStatement(MySQLStatementParser.ValidStatementContext ctx) {
        CollectionValue result = new CollectionValue();
        ValidStatementSegment validStatement = this.createValidStatementSegment(ctx);
        if (null != validStatement.getSqlStatement()) {
            result.getValue().add(validStatement);
        }
        if (null != ctx.beginStatement()) {
            result.combine((CollectionValue)this.visit((ParseTree)ctx.beginStatement()));
        }
        if (null != ctx.flowControlStatement()) {
            result.combine((CollectionValue)this.visit((ParseTree)ctx.flowControlStatement()));
        }
        return result;
    }

    private ValidStatementSegment createValidStatementSegment(MySQLStatementParser.ValidStatementContext ctx) {
        ValidStatementSegment result = new ValidStatementSegment(ctx.start.getStartIndex(), ctx.stop.getStopIndex());
        CreateTableStatement sqlStatement = null;
        if (null != ctx.createTable()) {
            sqlStatement = (CreateTableStatement)this.visit((ParseTree)ctx.createTable());
        } else if (null != ctx.alterTable()) {
            sqlStatement = (AlterTableStatement)this.visit((ParseTree)ctx.alterTable());
        } else if (null != ctx.dropTable()) {
            sqlStatement = (DropTableStatement)this.visit((ParseTree)ctx.dropTable());
        } else if (null != ctx.truncateTable()) {
            sqlStatement = (TruncateStatement)this.visit((ParseTree)ctx.truncateTable());
        } else if (null != ctx.insert()) {
            sqlStatement = (InsertStatement)this.visit((ParseTree)ctx.insert());
        } else if (null != ctx.replace()) {
            sqlStatement = (InsertStatement)this.visit((ParseTree)ctx.replace());
        } else if (null != ctx.update()) {
            sqlStatement = (UpdateStatement)this.visit((ParseTree)ctx.update());
        } else if (null != ctx.delete()) {
            sqlStatement = (DeleteStatement)this.visit((ParseTree)ctx.delete());
        } else if (null != ctx.select()) {
            sqlStatement = (SelectStatement)this.visit((ParseTree)ctx.select());
        } else if (null != ctx.startTransaction()) {
            sqlStatement = new StartTransactionStatement(this.getDatabaseType());
        } else if (null != ctx.commit()) {
            sqlStatement = (SQLStatement)this.tclStatementVisitor.visitCommit(ctx.commit());
        } else if (null != ctx.rollback()) {
            sqlStatement = (SQLStatement)this.tclStatementVisitor.visitRollback(ctx.rollback());
        } else if (null != ctx.setVariable()) {
            sqlStatement = (SQLStatement)this.dalStatementVisitor.visitSetVariable(ctx.setVariable());
        } else if (null != ctx.doStatement()) {
            sqlStatement = (DoStatement)this.visit((ParseTree)ctx.doStatement());
        } else if (null != ctx.explain()) {
            sqlStatement = (SQLStatement)this.visit((ParseTree)ctx.explain());
        } else if (null != ctx.analyzeTable()) {
            sqlStatement = (AnalyzeTableStatement)this.visit((ParseTree)ctx.analyzeTable());
        }
        result.setSqlStatement((SQLStatement)sqlStatement);
        return result;
    }

    @Override
    public ASTNode visitAnalyzeTable(MySQLStatementParser.AnalyzeTableContext ctx) {
        return new AnalyzeTableStatement(this.getDatabaseType(), ((CollectionValue)this.visit((ParseTree)ctx.tableList())).getValue());
    }

    @Override
    public ASTNode visitDoStatement(MySQLStatementParser.DoStatementContext ctx) {
        LinkedList<ExpressionSegment> expressions = new LinkedList<ExpressionSegment>();
        for (int i = 0; i < ctx.expr().size(); ++i) {
            expressions.add((ExpressionSegment)this.visit((ParseTree)ctx.expr(i)));
        }
        return new DoStatement(this.getDatabaseType(), expressions);
    }

    @Override
    public ASTNode visitExplain(MySQLStatementParser.ExplainContext ctx) {
        return null == ctx.tableName() ? new ExplainStatement(this.getDatabaseType(), (SQLStatement)this.getExplainableSQLStatement(ctx).orElse(null)) : new MySQLDescribeStatement(this.getDatabaseType(), (SimpleTableSegment)this.visit((ParseTree)ctx.tableName()), this.getColumnWildcard(ctx));
    }

    private Optional<SQLStatement> getExplainableSQLStatement(MySQLStatementParser.ExplainContext ctx) {
        if (null != ctx.explainableStatement()) {
            return Optional.of((SQLStatement)this.visit((ParseTree)ctx.explainableStatement()));
        }
        if (null != ctx.select()) {
            return Optional.of((SQLStatement)this.visit((ParseTree)ctx.select()));
        }
        if (null != ctx.delete()) {
            return Optional.of((SQLStatement)this.visit((ParseTree)ctx.delete()));
        }
        if (null != ctx.update()) {
            return Optional.of((SQLStatement)this.visit((ParseTree)ctx.update()));
        }
        if (null != ctx.insert()) {
            return Optional.of((SQLStatement)this.visit((ParseTree)ctx.insert()));
        }
        return Optional.empty();
    }

    private ColumnSegment getColumnWildcard(MySQLStatementParser.ExplainContext ctx) {
        if (null != ctx.columnRef()) {
            return (ColumnSegment)this.visit((ParseTree)ctx.columnRef());
        }
        if (null != ctx.textString()) {
            return (ColumnSegment)this.visit((ParseTree)ctx.textString());
        }
        return null;
    }

    @Override
    public ASTNode visitFlowControlStatement(MySQLStatementParser.FlowControlStatementContext ctx) {
        CollectionValue result = new CollectionValue();
        if (null != ctx.caseStatement()) {
            result.combine((CollectionValue)this.visit((ParseTree)ctx.caseStatement()));
        }
        if (null != ctx.ifStatement()) {
            result.combine((CollectionValue)this.visit((ParseTree)ctx.ifStatement()));
        }
        if (null != ctx.loopStatement()) {
            result.combine((CollectionValue)this.visit((ParseTree)ctx.loopStatement()));
        }
        if (null != ctx.repeatStatement()) {
            result.combine((CollectionValue)this.visit((ParseTree)ctx.repeatStatement()));
        }
        if (null != ctx.whileStatement()) {
            result.combine((CollectionValue)this.visit((ParseTree)ctx.whileStatement()));
        }
        return result;
    }

    @Override
    public ASTNode visitCaseStatement(MySQLStatementParser.CaseStatementContext ctx) {
        CollectionValue result = new CollectionValue();
        for (MySQLStatementParser.ValidStatementContext each : ctx.validStatement()) {
            result.combine((CollectionValue)this.visit((ParseTree)each));
        }
        return result;
    }

    @Override
    public ASTNode visitIfStatement(MySQLStatementParser.IfStatementContext ctx) {
        CollectionValue result = new CollectionValue();
        for (MySQLStatementParser.ValidStatementContext each : ctx.validStatement()) {
            result.combine((CollectionValue)this.visit((ParseTree)each));
        }
        return result;
    }

    @Override
    public ASTNode visitLoopStatement(MySQLStatementParser.LoopStatementContext ctx) {
        CollectionValue result = new CollectionValue();
        for (MySQLStatementParser.ValidStatementContext each : ctx.validStatement()) {
            result.combine((CollectionValue)this.visit((ParseTree)each));
        }
        return result;
    }

    @Override
    public ASTNode visitRepeatStatement(MySQLStatementParser.RepeatStatementContext ctx) {
        CollectionValue result = new CollectionValue();
        for (MySQLStatementParser.ValidStatementContext each : ctx.validStatement()) {
            result.combine((CollectionValue)this.visit((ParseTree)each));
        }
        return result;
    }

    @Override
    public ASTNode visitWhileStatement(MySQLStatementParser.WhileStatementContext ctx) {
        CollectionValue result = new CollectionValue();
        for (MySQLStatementParser.ValidStatementContext each : ctx.validStatement()) {
            result.combine((CollectionValue)this.visit((ParseTree)each));
        }
        return result;
    }

    @Override
    public ASTNode visitAlterFunction(MySQLStatementParser.AlterFunctionContext ctx) {
        return new AlterFunctionStatement(this.getDatabaseType());
    }

    @Override
    public ASTNode visitDropFunction(MySQLStatementParser.DropFunctionContext ctx) {
        return new DropFunctionStatement(this.getDatabaseType());
    }

    @Override
    public ASTNode visitCreateEvent(MySQLStatementParser.CreateEventContext ctx) {
        return new MySQLCreateEventStatement(this.getDatabaseType());
    }

    @Override
    public ASTNode visitAlterEvent(MySQLStatementParser.AlterEventContext ctx) {
        return new MySQLAlterEventStatement(this.getDatabaseType());
    }

    @Override
    public ASTNode visitDropEvent(MySQLStatementParser.DropEventContext ctx) {
        return new MySQLDropEventStatement(this.getDatabaseType());
    }

    @Override
    public ASTNode visitAlterInstance(MySQLStatementParser.AlterInstanceContext ctx) {
        return new MySQLAlterInstanceStatement(this.getDatabaseType());
    }

    @Override
    public ASTNode visitCreateLogfileGroup(MySQLStatementParser.CreateLogfileGroupContext ctx) {
        return new MySQLCreateLogfileGroupStatement(this.getDatabaseType());
    }

    @Override
    public ASTNode visitAlterLogfileGroup(MySQLStatementParser.AlterLogfileGroupContext ctx) {
        return new MySQLAlterLogfileGroupStatement(this.getDatabaseType());
    }

    @Override
    public ASTNode visitDropLogfileGroup(MySQLStatementParser.DropLogfileGroupContext ctx) {
        return new MySQLDropLogfileGroupStatement(this.getDatabaseType());
    }

    @Override
    public ASTNode visitCreateServer(MySQLStatementParser.CreateServerContext ctx) {
        return new CreateServerStatement(this.getDatabaseType());
    }

    @Override
    public ASTNode visitAlterServer(MySQLStatementParser.AlterServerContext ctx) {
        return new AlterServerStatement(this.getDatabaseType());
    }

    @Override
    public ASTNode visitDropServer(MySQLStatementParser.DropServerContext ctx) {
        return new DropServerStatement(this.getDatabaseType());
    }

    @Override
    public ASTNode visitCreateTrigger(MySQLStatementParser.CreateTriggerContext ctx) {
        return new CreateTriggerStatement(this.getDatabaseType());
    }

    @Override
    public ASTNode visitDropTrigger(MySQLStatementParser.DropTriggerContext ctx) {
        return new DropTriggerStatement(this.getDatabaseType());
    }

    @Override
    public ASTNode visitCreateTablespace(MySQLStatementParser.CreateTablespaceContext ctx) {
        return new CreateTablespaceStatement(this.getDatabaseType());
    }

    @Override
    public ASTNode visitAlterTablespace(MySQLStatementParser.AlterTablespaceContext ctx) {
        if (null != ctx.alterTablespaceInnodb()) {
            return (ASTNode)this.visit((ParseTree)ctx.alterTablespaceInnodb());
        }
        return (ASTNode)this.visit((ParseTree)ctx.alterTablespaceNdb());
    }

    @Override
    public ASTNode visitAlterTablespaceInnodb(MySQLStatementParser.AlterTablespaceInnodbContext ctx) {
        return new AlterTablespaceStatement(this.getDatabaseType(), null == ctx.tablespace ? null : this.createTablespaceSegment(ctx.tablespace), null == ctx.renameTablespace ? null : this.createTablespaceSegment(ctx.renameTablespace));
    }

    @Override
    public ASTNode visitAlterTablespaceNdb(MySQLStatementParser.AlterTablespaceNdbContext ctx) {
        return new AlterTablespaceStatement(this.getDatabaseType(), null == ctx.tablespace ? null : this.createTablespaceSegment(ctx.tablespace), null == ctx.renameTableSpace ? null : this.createTablespaceSegment(ctx.renameTableSpace));
    }

    private TablespaceSegment createTablespaceSegment(MySQLStatementParser.IdentifierContext ctx) {
        return new TablespaceSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), (IdentifierValue)this.visit((ParseTree)ctx));
    }

    @Override
    public ASTNode visitDropTablespace(MySQLStatementParser.DropTablespaceContext ctx) {
        return new DropTablespaceStatement(this.getDatabaseType());
    }

    @Override
    public ASTNode visitPrepare(MySQLStatementParser.PrepareContext ctx) {
        return new PrepareStatement(this.getDatabaseType());
    }

    @Override
    public ASTNode visitExecuteStmt(MySQLStatementParser.ExecuteStmtContext ctx) {
        return new ExecuteStatement(this.getDatabaseType());
    }

    @Override
    public ASTNode visitDeallocate(MySQLStatementParser.DeallocateContext ctx) {
        return new DeallocateStatement(this.getDatabaseType());
    }
}

