/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sql.parser.engine.mysql.visitor.statement;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.misc.Interval;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.TerminalNode;
import org.antlr.v4.runtime.tree.TerminalNodeImpl;
import org.apache.shardingsphere.database.connector.core.type.DatabaseType;
import org.apache.shardingsphere.sql.parser.api.ASTNode;
import org.apache.shardingsphere.sql.parser.autogen.MySQLStatementBaseVisitor;
import org.apache.shardingsphere.sql.parser.autogen.MySQLStatementParser;
import org.apache.shardingsphere.sql.parser.statement.core.enums.AggregationType;
import org.apache.shardingsphere.sql.parser.statement.core.enums.CombineType;
import org.apache.shardingsphere.sql.parser.statement.core.enums.JoinType;
import org.apache.shardingsphere.sql.parser.statement.core.enums.OrderDirection;
import org.apache.shardingsphere.sql.parser.statement.core.enums.ParameterMarkerType;
import org.apache.shardingsphere.sql.parser.statement.core.enums.SubqueryType;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dal.VariableSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.ddl.constraint.ConstraintSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.ddl.engine.EngineSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.ddl.index.IndexNameSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.ddl.index.IndexSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.ReturningSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.assignment.ColumnAssignmentSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.assignment.InsertValuesSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.assignment.RowAliasSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.assignment.SetAssignmentSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.assignment.ValueReferenceSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.column.ColumnSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.column.InsertColumnsSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.column.OnDuplicateKeyColumnsSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.combine.CombineSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.expr.BetweenExpression;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.expr.BinaryOperationExpression;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.expr.CaseWhenExpression;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.expr.CollateExpression;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.expr.ExistsSubqueryExpression;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.expr.ExpressionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.expr.FunctionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.expr.InExpression;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.expr.IntervalExpression;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.expr.IntervalUnit;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.expr.ListExpression;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.expr.NotExpression;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.expr.QuantifySubqueryExpression;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.expr.RowExpression;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.expr.UnaryOperationExpression;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.expr.ValuesExpression;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.expr.complex.CommonExpressionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.expr.complex.CommonTableExpressionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.expr.simple.LiteralExpressionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.expr.simple.ParameterMarkerExpressionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.expr.simple.SimpleExpressionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.expr.subquery.SubqueryExpressionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.expr.subquery.SubquerySegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.interval.IntervalUnitExpression;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.item.AggregationDistinctProjectionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.item.AggregationProjectionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.item.ColumnProjectionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.item.ExpressionProjectionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.item.ProjectionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.item.ProjectionsSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.item.ShorthandProjectionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.item.SubqueryProjectionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.order.GroupBySegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.order.OrderBySegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.order.item.ColumnOrderByItemSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.order.item.ExpressionOrderByItemSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.order.item.IndexOrderByItemSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.order.item.OrderByItemSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.pagination.PaginationValueSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.pagination.limit.LimitSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.pagination.limit.NumberLiteralLimitValueSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.pagination.limit.ParameterMarkerLimitValueSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.predicate.HavingSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.predicate.LockSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.predicate.WhereSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.generic.AliasSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.generic.DataTypeLengthSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.generic.DataTypeSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.generic.DatabaseSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.generic.OwnerSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.generic.ParameterMarkerSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.generic.ParenthesesSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.generic.WindowSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.generic.WithSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.generic.match.MatchAgainstExpression;
import org.apache.shardingsphere.sql.parser.statement.core.segment.generic.table.DeleteMultiTableSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.generic.table.FunctionTableSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.generic.table.IndexHintSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.generic.table.JoinTableSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.generic.table.SimpleTableSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.generic.table.SubqueryTableSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.generic.table.TableNameSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.generic.table.TableSegment;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.dml.DeleteStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.dml.InsertStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.dml.SelectStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.dml.UpdateStatement;
import org.apache.shardingsphere.sql.parser.statement.core.util.SQLUtils;
import org.apache.shardingsphere.sql.parser.statement.core.value.collection.CollectionValue;
import org.apache.shardingsphere.sql.parser.statement.core.value.identifier.IdentifierValue;
import org.apache.shardingsphere.sql.parser.statement.core.value.literal.impl.BooleanLiteralValue;
import org.apache.shardingsphere.sql.parser.statement.core.value.literal.impl.NullLiteralValue;
import org.apache.shardingsphere.sql.parser.statement.core.value.literal.impl.NumberLiteralValue;
import org.apache.shardingsphere.sql.parser.statement.core.value.literal.impl.OtherLiteralValue;
import org.apache.shardingsphere.sql.parser.statement.core.value.literal.impl.StringLiteralValue;
import org.apache.shardingsphere.sql.parser.statement.core.value.literal.impl.TemporalLiteralValue;
import org.apache.shardingsphere.sql.parser.statement.core.value.parametermarker.ParameterMarkerValue;

public abstract class MySQLStatementVisitor
extends MySQLStatementBaseVisitor<ASTNode> {
    private final DatabaseType databaseType;
    private final Collection<ParameterMarkerSegment> parameterMarkerSegments = new LinkedList<ParameterMarkerSegment>();

    @Override
    public final ASTNode visitParameterMarker(MySQLStatementParser.ParameterMarkerContext ctx) {
        return new ParameterMarkerValue(Integer.valueOf(this.parameterMarkerSegments.size()), ParameterMarkerType.QUESTION);
    }

    @Override
    public final ASTNode visitLiterals(MySQLStatementParser.LiteralsContext ctx) {
        if (null != ctx.stringLiterals()) {
            return (ASTNode)this.visit((ParseTree)ctx.stringLiterals());
        }
        if (null != ctx.numberLiterals()) {
            return (ASTNode)this.visit((ParseTree)ctx.numberLiterals());
        }
        if (null != ctx.temporalLiterals()) {
            return (ASTNode)this.visit((ParseTree)ctx.temporalLiterals());
        }
        if (null != ctx.hexadecimalLiterals()) {
            return (ASTNode)this.visit((ParseTree)ctx.hexadecimalLiterals());
        }
        if (null != ctx.bitValueLiterals()) {
            return (ASTNode)this.visit((ParseTree)ctx.bitValueLiterals());
        }
        if (null != ctx.booleanLiterals()) {
            return (ASTNode)this.visit((ParseTree)ctx.booleanLiterals());
        }
        if (null != ctx.nullValueLiterals()) {
            return (ASTNode)this.visit((ParseTree)ctx.nullValueLiterals());
        }
        throw new IllegalStateException("Literals must have string, number, dateTime, hex, bit, boolean or null.");
    }

    @Override
    public final ASTNode visitStringLiterals(MySQLStatementParser.StringLiteralsContext ctx) {
        if (!ctx.string_().isEmpty()) {
            return new StringLiteralValue((Collection)ctx.string_().stream().map(each -> (StringLiteralValue)this.visit((ParseTree)each)).collect(Collectors.toList()));
        }
        return new StringLiteralValue(ctx.getText());
    }

    @Override
    public ASTNode visitString_(MySQLStatementParser.String_Context ctx) {
        return new StringLiteralValue(ctx.getText());
    }

    @Override
    public final ASTNode visitNumberLiterals(MySQLStatementParser.NumberLiteralsContext ctx) {
        return new NumberLiteralValue(ctx.getText());
    }

    @Override
    public ASTNode visitTemporalLiterals(MySQLStatementParser.TemporalLiteralsContext ctx) {
        String temporalType = null != ctx.DATE() ? "DATE" : (null != ctx.TIME() ? "TIME" : "TIMESTAMP");
        return new TemporalLiteralValue(temporalType, ctx.textString().getText());
    }

    @Override
    public final ASTNode visitHexadecimalLiterals(MySQLStatementParser.HexadecimalLiteralsContext ctx) {
        return new OtherLiteralValue(ctx.getText());
    }

    @Override
    public final ASTNode visitBitValueLiterals(MySQLStatementParser.BitValueLiteralsContext ctx) {
        return new OtherLiteralValue(ctx.getText());
    }

    @Override
    public final ASTNode visitBooleanLiterals(MySQLStatementParser.BooleanLiteralsContext ctx) {
        return new BooleanLiteralValue(ctx.getText());
    }

    @Override
    public final ASTNode visitNullValueLiterals(MySQLStatementParser.NullValueLiteralsContext ctx) {
        return new NullLiteralValue(ctx.getText());
    }

    @Override
    public final ASTNode visitIdentifier(MySQLStatementParser.IdentifierContext ctx) {
        return new IdentifierValue(ctx.getText());
    }

    @Override
    public final ASTNode visitDatabaseName(MySQLStatementParser.DatabaseNameContext ctx) {
        return new DatabaseSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), (IdentifierValue)this.visit((ParseTree)ctx.identifier()));
    }

    @Override
    public final ASTNode visitTableName(MySQLStatementParser.TableNameContext ctx) {
        SimpleTableSegment result = new SimpleTableSegment(new TableNameSegment(ctx.name().getStart().getStartIndex(), ctx.name().getStop().getStopIndex(), new IdentifierValue(ctx.name().identifier().getText())));
        MySQLStatementParser.OwnerContext owner = ctx.owner();
        if (null != owner) {
            result.setOwner((OwnerSegment)this.visit((ParseTree)owner));
        }
        return result;
    }

    @Override
    public final ASTNode visitViewName(MySQLStatementParser.ViewNameContext ctx) {
        SimpleTableSegment result = new SimpleTableSegment(new TableNameSegment(ctx.identifier().getStart().getStartIndex(), ctx.identifier().getStop().getStopIndex(), new IdentifierValue(ctx.identifier().getText())));
        MySQLStatementParser.OwnerContext owner = ctx.owner();
        if (null != owner) {
            result.setOwner((OwnerSegment)this.visit((ParseTree)owner));
        }
        return result;
    }

    @Override
    public final ASTNode visitOwner(MySQLStatementParser.OwnerContext ctx) {
        return new OwnerSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), (IdentifierValue)this.visit((ParseTree)ctx.identifier()));
    }

    @Override
    public ASTNode visitFunctionName(MySQLStatementParser.FunctionNameContext ctx) {
        FunctionSegment result = new FunctionSegment(ctx.start.getStartIndex(), ctx.stop.getStopIndex(), ctx.identifier().IDENTIFIER_().getText(), ctx.getText());
        if (null != ctx.owner()) {
            result.setOwner((OwnerSegment)this.visit((ParseTree)ctx.owner()));
        }
        return result;
    }

    @Override
    public final ASTNode visitColumnName(MySQLStatementParser.ColumnNameContext ctx) {
        return new ColumnSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), (IdentifierValue)this.visit((ParseTree)ctx.identifier()));
    }

    @Override
    public final ASTNode visitIndexName(MySQLStatementParser.IndexNameContext ctx) {
        IndexNameSegment indexName = new IndexNameSegment(ctx.start.getStartIndex(), ctx.stop.getStopIndex(), (IdentifierValue)this.visit((ParseTree)ctx.identifier()));
        return new IndexSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), indexName);
    }

    @Override
    public ASTNode visitTableList(MySQLStatementParser.TableListContext ctx) {
        CollectionValue result = new CollectionValue();
        for (MySQLStatementParser.TableNameContext each : ctx.tableName()) {
            result.getValue().add((SimpleTableSegment)this.visit((ParseTree)each));
        }
        return result;
    }

    @Override
    public final ASTNode visitViewNames(MySQLStatementParser.ViewNamesContext ctx) {
        CollectionValue result = new CollectionValue();
        for (MySQLStatementParser.ViewNameContext each : ctx.viewName()) {
            result.getValue().add((SimpleTableSegment)this.visit((ParseTree)each));
        }
        return result;
    }

    @Override
    public final ASTNode visitColumnNames(MySQLStatementParser.ColumnNamesContext ctx) {
        CollectionValue result = new CollectionValue();
        for (MySQLStatementParser.ColumnNameContext each : ctx.columnName()) {
            result.getValue().add((ColumnSegment)this.visit((ParseTree)each));
        }
        return result;
    }

    @Override
    public final ASTNode visitExpr(MySQLStatementParser.ExprContext ctx) {
        if (null != ctx.booleanPrimary()) {
            return (ASTNode)this.visit((ParseTree)ctx.booleanPrimary());
        }
        if (null != ctx.XOR()) {
            return this.createBinaryOperationExpression(ctx, "XOR");
        }
        if (null != ctx.andOperator()) {
            return this.createBinaryOperationExpression(ctx, ctx.andOperator().getText());
        }
        if (null != ctx.orOperator()) {
            return this.createBinaryOperationExpression(ctx, ctx.orOperator().getText());
        }
        return new NotExpression(ctx.start.getStartIndex(), ctx.stop.getStopIndex(), (ExpressionSegment)this.visit((ParseTree)ctx.expr(0)), Boolean.valueOf(false));
    }

    private BinaryOperationExpression createBinaryOperationExpression(MySQLStatementParser.ExprContext ctx, String operator) {
        ExpressionSegment left = (ExpressionSegment)this.visit((ParseTree)ctx.expr(0));
        ExpressionSegment right = (ExpressionSegment)this.visit((ParseTree)ctx.expr(1));
        String text = ctx.start.getInputStream().getText(new Interval(ctx.start.getStartIndex(), ctx.stop.getStopIndex()));
        return new BinaryOperationExpression(ctx.start.getStartIndex(), ctx.stop.getStopIndex(), left, right, operator, text);
    }

    @Override
    public final ASTNode visitBooleanPrimary(MySQLStatementParser.BooleanPrimaryContext ctx) {
        if (null != ctx.IS()) {
            String rightText = "";
            if (null != ctx.NOT()) {
                rightText = rightText + ctx.start.getInputStream().getText(new Interval(ctx.NOT().getSymbol().getStartIndex(), ctx.NOT().getSymbol().getStopIndex())) + " ";
            }
            Token operatorToken = null;
            if (null != ctx.NULL()) {
                operatorToken = ctx.NULL().getSymbol();
            }
            if (null != ctx.TRUE()) {
                operatorToken = ctx.TRUE().getSymbol();
            }
            if (null != ctx.FALSE()) {
                operatorToken = ctx.FALSE().getSymbol();
            }
            if (null != ctx.UNKNOWN()) {
                operatorToken = ctx.UNKNOWN().getSymbol();
            }
            int startIndex = null == operatorToken ? ctx.IS().getSymbol().getStopIndex() + 2 : operatorToken.getStartIndex();
            rightText = rightText + ctx.start.getInputStream().getText(new Interval(startIndex, ctx.stop.getStopIndex()));
            LiteralExpressionSegment right = new LiteralExpressionSegment(ctx.IS().getSymbol().getStopIndex() + 2, ctx.stop.getStopIndex(), (Object)rightText);
            String text = ctx.start.getInputStream().getText(new Interval(ctx.start.getStartIndex(), ctx.stop.getStopIndex()));
            ExpressionSegment left = (ExpressionSegment)this.visit((ParseTree)ctx.booleanPrimary());
            String operator = "IS";
            return new BinaryOperationExpression(ctx.start.getStartIndex(), ctx.stop.getStopIndex(), left, (ExpressionSegment)right, operator, text);
        }
        if (null != ctx.comparisonOperator() || null != ctx.SAFE_EQ_()) {
            return this.createCompareSegment(ctx);
        }
        if (null != ctx.MEMBER()) {
            int startIndex = ctx.MEMBER().getSymbol().getStopIndex() + 5;
            int endIndex = ctx.stop.getStopIndex() - 1;
            String rightText = ctx.start.getInputStream().getText(new Interval(startIndex, endIndex));
            ExpressionProjectionSegment right = new ExpressionProjectionSegment(startIndex, endIndex, rightText);
            String text = ctx.start.getInputStream().getText(new Interval(ctx.start.getStartIndex(), ctx.stop.getStopIndex()));
            ExpressionSegment left = (ExpressionSegment)this.visit((ParseTree)ctx.booleanPrimary());
            String operator = "MEMBER OF";
            return new BinaryOperationExpression(ctx.start.getStartIndex(), ctx.stop.getStopIndex(), left, (ExpressionSegment)right, operator, text);
        }
        if (null != ctx.assignmentOperator()) {
            return this.createAssignmentSegment(ctx);
        }
        return (ASTNode)this.visit((ParseTree)ctx.predicate());
    }

    private ASTNode createAssignmentSegment(MySQLStatementParser.BooleanPrimaryContext ctx) {
        ExpressionSegment left = (ExpressionSegment)this.visit((ParseTree)ctx.booleanPrimary());
        ExpressionSegment right = (ExpressionSegment)this.visit((ParseTree)ctx.predicate());
        String operator = ctx.assignmentOperator().getText();
        String text = ctx.start.getInputStream().getText(new Interval(ctx.start.getStartIndex(), ctx.stop.getStopIndex()));
        return new BinaryOperationExpression(ctx.start.getStartIndex(), ctx.stop.getStopIndex(), left, right, operator, text);
    }

    private ASTNode createCompareSegment(MySQLStatementParser.BooleanPrimaryContext ctx) {
        ExpressionSegment left = (ExpressionSegment)this.visit((ParseTree)ctx.booleanPrimary());
        ExpressionSegment right = null != ctx.predicate() ? (ExpressionSegment)this.visit((ParseTree)ctx.predicate()) : this.createRightExpression(ctx);
        String operator = null == ctx.SAFE_EQ_() ? ctx.comparisonOperator().getText() : ctx.SAFE_EQ_().getText();
        String text = ctx.start.getInputStream().getText(new Interval(ctx.start.getStartIndex(), ctx.stop.getStopIndex()));
        return new BinaryOperationExpression(ctx.start.getStartIndex(), ctx.stop.getStopIndex(), left, right, operator, text);
    }

    private ExpressionSegment createRightExpression(MySQLStatementParser.BooleanPrimaryContext ctx) {
        SubqueryExpressionSegment result = new SubqueryExpressionSegment(new SubquerySegment(ctx.subquery().start.getStartIndex(), ctx.subquery().stop.getStopIndex(), (SelectStatement)this.visit((ParseTree)ctx.subquery()), this.getOriginalText(ctx.subquery())));
        if (null != ctx.ANY() || null != ctx.ALL()) {
            int startIndex = null == ctx.ANY() ? ctx.ALL().getSymbol().getStartIndex() : ctx.ANY().getSymbol().getStartIndex();
            String quantifyOperator = null == ctx.ANY() ? ctx.ALL().getText() : ctx.ANY().getText();
            return new QuantifySubqueryExpression(startIndex, result.getStopIndex(), result.getSubquery(), quantifyOperator);
        }
        return result;
    }

    @Override
    public final ASTNode visitPredicate(MySQLStatementParser.PredicateContext ctx) {
        if (null != ctx.IN()) {
            return this.createInSegment(ctx);
        }
        if (null != ctx.BETWEEN()) {
            return this.createBetweenSegment(ctx);
        }
        if (null != ctx.LIKE()) {
            return this.createBinaryOperationExpressionFromLike(ctx);
        }
        if (null != ctx.REGEXP()) {
            return this.createBinaryOperationExpressionFromRegexp(ctx);
        }
        if (null != ctx.RLIKE()) {
            return this.createBinaryOperationExpressionFromRlike(ctx);
        }
        return (ASTNode)this.visit((ParseTree)ctx.bitExpr(0));
    }

    private InExpression createInSegment(MySQLStatementParser.PredicateContext ctx) {
        ListExpression right;
        boolean not = null != ctx.NOT();
        ExpressionSegment left = (ExpressionSegment)this.visit((ParseTree)ctx.bitExpr(0));
        if (null != ctx.subquery()) {
            right = new SubqueryExpressionSegment(new SubquerySegment(ctx.subquery().start.getStartIndex(), ctx.subquery().stop.getStopIndex(), (SelectStatement)this.visit((ParseTree)ctx.subquery()), this.getOriginalText(ctx.subquery())));
        } else {
            right = new ListExpression(ctx.LP_().getSymbol().getStartIndex(), ctx.RP_().getSymbol().getStopIndex());
            for (MySQLStatementParser.ExprContext each : ctx.expr()) {
                right.getItems().add((ExpressionSegment)this.visit((ParseTree)each));
            }
        }
        return new InExpression(ctx.start.getStartIndex(), ctx.stop.getStopIndex(), left, (ExpressionSegment)right, not);
    }

    private BinaryOperationExpression createBinaryOperationExpressionFromLike(MySQLStatementParser.PredicateContext ctx) {
        String operator;
        ExpressionSegment right;
        ExpressionSegment left = (ExpressionSegment)this.visit((ParseTree)ctx.bitExpr(0));
        if (null != ctx.SOUNDS()) {
            right = (ExpressionSegment)this.visit((ParseTree)ctx.bitExpr(1));
            operator = "SOUNDS LIKE";
        } else {
            ListExpression listExpression = new ListExpression(ctx.simpleExpr((int)0).start.getStartIndex(), ctx.simpleExpr().get((int)(ctx.simpleExpr().size() - 1)).stop.getStopIndex());
            for (MySQLStatementParser.SimpleExprContext each : ctx.simpleExpr()) {
                listExpression.getItems().add((ExpressionSegment)this.visit((ParseTree)each));
            }
            right = listExpression;
            operator = null == ctx.NOT() ? "LIKE" : "NOT LIKE";
        }
        String text = ctx.start.getInputStream().getText(new Interval(ctx.start.getStartIndex(), ctx.stop.getStopIndex()));
        return new BinaryOperationExpression(ctx.start.getStartIndex(), ctx.stop.getStopIndex(), left, right, operator, text);
    }

    private BinaryOperationExpression createBinaryOperationExpressionFromRegexp(MySQLStatementParser.PredicateContext ctx) {
        ExpressionSegment left = (ExpressionSegment)this.visit((ParseTree)ctx.bitExpr(0));
        ExpressionSegment right = (ExpressionSegment)this.visit((ParseTree)ctx.bitExpr(1));
        String operator = null == ctx.NOT() ? "REGEXP" : "NOT REGEXP";
        String text = ctx.start.getInputStream().getText(new Interval(ctx.start.getStartIndex(), ctx.stop.getStopIndex()));
        return new BinaryOperationExpression(ctx.start.getStartIndex(), ctx.stop.getStopIndex(), left, right, operator, text);
    }

    private BinaryOperationExpression createBinaryOperationExpressionFromRlike(MySQLStatementParser.PredicateContext ctx) {
        ExpressionSegment left = (ExpressionSegment)this.visit((ParseTree)ctx.bitExpr(0));
        ExpressionSegment right = (ExpressionSegment)this.visit((ParseTree)ctx.bitExpr(1));
        String operator = null == ctx.NOT() ? "RLIKE" : "NOT RLIKE";
        String text = ctx.start.getInputStream().getText(new Interval(ctx.start.getStartIndex(), ctx.stop.getStopIndex()));
        return new BinaryOperationExpression(ctx.start.getStartIndex(), ctx.stop.getStopIndex(), left, right, operator, text);
    }

    private BetweenExpression createBetweenSegment(MySQLStatementParser.PredicateContext ctx) {
        ExpressionSegment left = (ExpressionSegment)this.visit((ParseTree)ctx.bitExpr(0));
        ExpressionSegment between = (ExpressionSegment)this.visit((ParseTree)ctx.bitExpr(1));
        ExpressionSegment and = (ExpressionSegment)this.visit((ParseTree)ctx.predicate());
        boolean not = null != ctx.NOT();
        return new BetweenExpression(ctx.start.getStartIndex(), ctx.stop.getStopIndex(), left, between, and, not);
    }

    @Override
    public final ASTNode visitBitExpr(MySQLStatementParser.BitExprContext ctx) {
        if (null != ctx.simpleExpr()) {
            return (ASTNode)this.visit((ParseTree)ctx.simpleExpr());
        }
        ExpressionSegment left = (ExpressionSegment)this.visit(ctx.getChild(0));
        ExpressionSegment right = (ExpressionSegment)this.visit(ctx.getChild(2));
        String operator = ctx.getChild(1).getText();
        String text = ctx.start.getInputStream().getText(new Interval(ctx.start.getStartIndex(), ctx.stop.getStopIndex()));
        return new BinaryOperationExpression(ctx.start.getStartIndex(), ctx.stop.getStopIndex(), left, right, operator, text);
    }

    @Override
    public final ASTNode visitSimpleExpr(MySQLStatementParser.SimpleExprContext ctx) {
        int startIndex = ctx.start.getStartIndex();
        int stopIndex = ctx.stop.getStopIndex();
        if (null != ctx.subquery()) {
            SubquerySegment subquerySegment = new SubquerySegment(ctx.subquery().getStart().getStartIndex(), ctx.subquery().getStop().getStopIndex(), (SelectStatement)this.visit((ParseTree)ctx.subquery()), this.getOriginalText(ctx.subquery()));
            if (null != ctx.EXISTS()) {
                subquerySegment.getSelect().setSubqueryType(SubqueryType.EXISTS);
                return new ExistsSubqueryExpression(startIndex, stopIndex, subquerySegment);
            }
            return new SubqueryExpressionSegment(subquerySegment);
        }
        if (null != ctx.parameterMarker()) {
            ParameterMarkerValue parameterMarker = (ParameterMarkerValue)this.visit((ParseTree)ctx.parameterMarker());
            ParameterMarkerExpressionSegment result = new ParameterMarkerExpressionSegment(startIndex, stopIndex, parameterMarker.getValue().intValue(), parameterMarker.getType());
            this.parameterMarkerSegments.add((ParameterMarkerSegment)result);
            return result;
        }
        if (null != ctx.literals()) {
            return SQLUtils.createLiteralExpression((ASTNode)((ASTNode)this.visit((ParseTree)ctx.literals())), (int)startIndex, (int)stopIndex, (String)ctx.literals().start.getInputStream().getText(new Interval(startIndex, stopIndex)));
        }
        if (null != ctx.intervalExpression()) {
            return (ASTNode)this.visit((ParseTree)ctx.intervalExpression());
        }
        if (null != ctx.functionCall()) {
            return (ASTNode)this.visit((ParseTree)ctx.functionCall());
        }
        if (null != ctx.collateClause()) {
            ExpressionSegment expr = null == ctx.simpleExpr() ? null : (ExpressionSegment)this.visit((ParseTree)ctx.simpleExpr(0));
            return new CollateExpression(startIndex, stopIndex, (SimpleExpressionSegment)this.visit((ParseTree)ctx.collateClause()), expr);
        }
        if (null != ctx.columnRef()) {
            return (ASTNode)this.visit((ParseTree)ctx.columnRef());
        }
        if (null != ctx.matchExpression()) {
            return (ASTNode)this.visit((ParseTree)ctx.matchExpression());
        }
        if (null != ctx.notOperator()) {
            ASTNode expression = (ASTNode)this.visit((ParseTree)ctx.simpleExpr(0));
            if (expression instanceof ExistsSubqueryExpression) {
                ((ExistsSubqueryExpression)expression).setNot(true);
                return expression;
            }
            return new NotExpression(startIndex, stopIndex, (ExpressionSegment)expression, Boolean.valueOf("!".equalsIgnoreCase(ctx.notOperator().getText())));
        }
        if (null != ctx.LP_() && 1 == ctx.expr().size()) {
            ASTNode result = (ASTNode)this.visit((ParseTree)ctx.expr(0));
            if (result instanceof ColumnSegment) {
                ((ColumnSegment)result).setLeftParentheses(new ParenthesesSegment(ctx.LP_().getSymbol().getStartIndex(), ctx.LP_().getSymbol().getStopIndex(), ctx.LP_().getSymbol().getText()));
                ((ColumnSegment)result).setRightParentheses(new ParenthesesSegment(ctx.RP_().getSymbol().getStartIndex(), ctx.RP_().getSymbol().getStopIndex(), ctx.RP_().getSymbol().getText()));
            }
            return result;
        }
        if (null != ctx.VERTICAL_BAR_() && 2 == ctx.VERTICAL_BAR_().size()) {
            ExpressionSegment left = (ExpressionSegment)this.visit((ParseTree)ctx.simpleExpr(0));
            ExpressionSegment right = (ExpressionSegment)this.visit((ParseTree)ctx.simpleExpr(1));
            String text = ctx.start.getInputStream().getText(new Interval(ctx.start.getStartIndex(), ctx.stop.getStopIndex()));
            return new BinaryOperationExpression(ctx.start.getStartIndex(), ctx.stop.getStopIndex(), left, right, ctx.VERTICAL_BAR_(0).getText() + ctx.VERTICAL_BAR_(1).getText(), text);
        }
        return this.visitRemainSimpleExpr(ctx);
    }

    @Override
    public ASTNode visitColumnRef(MySQLStatementParser.ColumnRefContext ctx) {
        ColumnSegment result;
        int identifierCount = ctx.identifier().size();
        if (1 == identifierCount) {
            result = new ColumnSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), (IdentifierValue)this.visit((ParseTree)ctx.identifier(0)));
        } else if (2 == identifierCount) {
            result = new ColumnSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), (IdentifierValue)this.visit((ParseTree)ctx.identifier(1)));
            result.setOwner(new OwnerSegment(ctx.identifier((int)0).start.getStartIndex(), ctx.identifier((int)0).stop.getStopIndex(), (IdentifierValue)this.visit((ParseTree)ctx.identifier(0))));
        } else {
            result = new ColumnSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), (IdentifierValue)this.visit((ParseTree)ctx.identifier(2)));
            OwnerSegment owner = new OwnerSegment(ctx.identifier((int)1).start.getStartIndex(), ctx.identifier((int)1).stop.getStopIndex(), (IdentifierValue)this.visit((ParseTree)ctx.identifier(1)));
            owner.setOwner(new OwnerSegment(ctx.identifier((int)0).start.getStartIndex(), ctx.identifier((int)0).stop.getStopIndex(), (IdentifierValue)this.visit((ParseTree)ctx.identifier(0))));
            result.setOwner(owner);
        }
        return result;
    }

    @Override
    public ASTNode visitSubquery(MySQLStatementParser.SubqueryContext ctx) {
        return (ASTNode)this.visit((ParseTree)ctx.queryExpressionParens());
    }

    @Override
    public ASTNode visitQueryExpressionParens(MySQLStatementParser.QueryExpressionParensContext ctx) {
        if (null != ctx.queryExpressionParens()) {
            return (ASTNode)this.visit((ParseTree)ctx.queryExpressionParens());
        }
        SelectStatement result = (SelectStatement)this.visit((ParseTree)ctx.queryExpression());
        if (null != ctx.lockClauseList()) {
            result.setLock((LockSegment)this.visit((ParseTree)ctx.lockClauseList()));
        }
        result.addParameterMarkers(this.getParameterMarkerSegments());
        return result;
    }

    @Override
    public ASTNode visitLockClauseList(MySQLStatementParser.LockClauseListContext ctx) {
        LockSegment result = new LockSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex());
        for (MySQLStatementParser.LockClauseContext each : ctx.lockClause()) {
            if (null == each.tableLockingList()) continue;
            result.getTables().addAll(this.generateTablesFromTableAliasRefList(each.tableLockingList().tableAliasRefList()));
        }
        return result;
    }

    @Override
    public ASTNode visitQueryExpression(MySQLStatementParser.QueryExpressionContext ctx) {
        SelectStatement result = null != ctx.queryExpressionBody() ? (SelectStatement)this.visit((ParseTree)ctx.queryExpressionBody()) : (SelectStatement)this.visit((ParseTree)ctx.queryExpressionParens());
        if (null != ctx.orderByClause()) {
            result.setOrderBy((OrderBySegment)this.visit((ParseTree)ctx.orderByClause()));
        }
        if (null != ctx.limitClause()) {
            result.setLimit((LimitSegment)this.visit((ParseTree)ctx.limitClause()));
        }
        if (null != result && null != ctx.withClause()) {
            result.setWith((WithSegment)this.visit((ParseTree)ctx.withClause()));
        }
        return result;
    }

    @Override
    public ASTNode visitSelectWithInto(MySQLStatementParser.SelectWithIntoContext ctx) {
        if (null != ctx.selectWithInto()) {
            return (ASTNode)this.visit((ParseTree)ctx.selectWithInto());
        }
        SelectStatement result = (SelectStatement)this.visit((ParseTree)ctx.queryExpression());
        if (null != ctx.lockClauseList()) {
            result.setLock((LockSegment)this.visit((ParseTree)ctx.lockClauseList()));
        }
        return result;
    }

    @Override
    public ASTNode visitWithClause(MySQLStatementParser.WithClauseContext ctx) {
        LinkedList<CommonTableExpressionSegment> commonTableExpressions = new LinkedList<CommonTableExpressionSegment>();
        for (MySQLStatementParser.CteClauseContext each : ctx.cteClause()) {
            commonTableExpressions.add((CommonTableExpressionSegment)this.visit((ParseTree)each));
        }
        return new WithSegment(ctx.start.getStartIndex(), ctx.stop.getStopIndex(), commonTableExpressions, null != ctx.RECURSIVE());
    }

    @Override
    public ASTNode visitCteClause(MySQLStatementParser.CteClauseContext ctx) {
        CommonTableExpressionSegment result = new CommonTableExpressionSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), (AliasSegment)this.visit((ParseTree)ctx.alias()), new SubquerySegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), (SelectStatement)this.visit((ParseTree)ctx.subquery()), this.getOriginalText(ctx.subquery())));
        if (null != ctx.columnNames()) {
            CollectionValue columns = (CollectionValue)this.visit((ParseTree)ctx.columnNames());
            result.getColumns().addAll(columns.getValue());
        }
        return result;
    }

    @Override
    public ASTNode visitQueryExpressionBody(MySQLStatementParser.QueryExpressionBodyContext ctx) {
        if (1 == ctx.getChildCount() && ctx.getChild(0) instanceof MySQLStatementParser.QueryPrimaryContext) {
            return (ASTNode)this.visit((ParseTree)ctx.queryPrimary());
        }
        if (null != ctx.queryExpressionBody() && ctx.queryExpressionBody().size() > 1) {
            SelectStatement result = new SelectStatement(this.databaseType);
            SubquerySegment left = new SubquerySegment(ctx.queryExpressionBody((int)0).start.getStartIndex(), ctx.queryExpressionBody((int)0).stop.getStopIndex(), (SelectStatement)this.visit((ParseTree)ctx.queryExpressionBody(0)), this.getOriginalText(ctx.queryExpressionBody(0)));
            result.setProjections(left.getSelect().getProjections());
            left.getSelect().getFrom().ifPresent(arg_0 -> ((SelectStatement)result).setFrom(arg_0));
            result.setCombine(this.createCombineSegment(ctx, left));
            return result;
        }
        return (ASTNode)this.visit((ParseTree)ctx.queryExpressionParens());
    }

    private CombineSegment createCombineSegment(MySQLStatementParser.QueryExpressionBodyContext ctx, SubquerySegment left) {
        CombineType combineType = null != ctx.EXCEPT() ? (null == ctx.combineOption() || null == ctx.combineOption().ALL() ? CombineType.EXCEPT : CombineType.EXCEPT_ALL) : (null != ctx.INTERSECT() ? (null == ctx.combineOption() || null == ctx.combineOption().ALL() ? CombineType.INTERSECT : CombineType.INTERSECT_ALL) : (null == ctx.combineOption() || null == ctx.combineOption().ALL() ? CombineType.UNION : CombineType.UNION_ALL));
        MySQLStatementParser.QueryExpressionBodyContext ruleContext = ctx.queryExpressionBody(1);
        SubquerySegment right = new SubquerySegment(ruleContext.start.getStartIndex(), ruleContext.stop.getStopIndex(), (SelectStatement)this.visit((ParseTree)ruleContext), this.getOriginalText(ruleContext));
        return new CombineSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), left, combineType, right);
    }

    @Override
    public ASTNode visitQuerySpecification(MySQLStatementParser.QuerySpecificationContext ctx) {
        SelectStatement result = new SelectStatement(this.databaseType);
        result.setProjections((ProjectionsSegment)this.visit((ParseTree)ctx.projections()));
        if (null != ctx.selectSpecification()) {
            result.getProjections().setDistinctRow(this.isDistinct(ctx));
        }
        if (null != ctx.fromClause()) {
            TableSegment tableSource;
            if (null != ctx.fromClause().tableReferences()) {
                tableSource = (TableSegment)this.visit((ParseTree)ctx.fromClause().tableReferences());
                result.setFrom(tableSource);
            }
            if (null != ctx.fromClause().DUAL()) {
                tableSource = new SimpleTableSegment(new TableNameSegment(ctx.fromClause().DUAL().getSymbol().getStartIndex(), ctx.fromClause().DUAL().getSymbol().getStopIndex(), new IdentifierValue(ctx.fromClause().DUAL().getText())));
                result.setFrom(tableSource);
            }
        }
        if (null != ctx.whereClause()) {
            result.setWhere((WhereSegment)this.visit((ParseTree)ctx.whereClause()));
        }
        if (null != ctx.groupByClause()) {
            result.setGroupBy((GroupBySegment)this.visit((ParseTree)ctx.groupByClause()));
        }
        if (null != ctx.havingClause()) {
            result.setHaving((HavingSegment)this.visit((ParseTree)ctx.havingClause()));
        }
        if (null != ctx.windowClause()) {
            result.setWindow((WindowSegment)this.visit((ParseTree)ctx.windowClause()));
        }
        if (null != ctx.lockClauseList()) {
            result.setLock((LockSegment)this.visit((ParseTree)ctx.lockClauseList()));
        }
        return result;
    }

    @Override
    public ASTNode visitTableValueConstructor(MySQLStatementParser.TableValueConstructorContext ctx) {
        SelectStatement result = new SelectStatement(this.databaseType);
        int startIndex = ctx.getStart().getStartIndex();
        int stopIndex = ctx.getStop().getStopIndex();
        ValuesExpression valuesExpression = new ValuesExpression(startIndex, stopIndex);
        valuesExpression.getRowConstructorList().addAll(this.createRowConstructorList(ctx.rowConstructorList()));
        result.setProjections(new ProjectionsSegment(startIndex, stopIndex));
        result.getProjections().getProjections().add(new ExpressionProjectionSegment(startIndex, stopIndex, this.getOriginalText(ctx), (ExpressionSegment)valuesExpression));
        return result;
    }

    private Collection<InsertValuesSegment> createRowConstructorList(MySQLStatementParser.RowConstructorListContext ctx) {
        LinkedList<InsertValuesSegment> result = new LinkedList<InsertValuesSegment>();
        for (int index = 0; index < ctx.getChildCount(); ++index) {
            if (!(ctx.getChild(index) instanceof MySQLStatementParser.AssignmentValuesContext)) continue;
            InsertValuesSegment valuesSegment = (InsertValuesSegment)this.visit(ctx.getChild(index));
            result.add(new InsertValuesSegment(((TerminalNodeImpl)ctx.getChild((int)(index - 1))).symbol.getStartIndex(), valuesSegment.getStopIndex(), valuesSegment.getValues()));
        }
        return result;
    }

    @Override
    public ASTNode visitTableStatement(MySQLStatementParser.TableStatementContext ctx) {
        SelectStatement result = new SelectStatement(this.databaseType);
        result.setProjections(new ProjectionsSegment(ctx.start.getStartIndex(), ctx.start.getStartIndex()));
        result.getProjections().getProjections().add(new ShorthandProjectionSegment(ctx.start.getStartIndex(), ctx.start.getStartIndex()));
        result.setFrom((TableSegment)new SimpleTableSegment(new TableNameSegment(ctx.start.getStartIndex(), ctx.stop.getStopIndex(), new IdentifierValue(ctx.tableName().getText()))));
        return result;
    }

    @Override
    public ASTNode visitHavingClause(MySQLStatementParser.HavingClauseContext ctx) {
        ExpressionSegment expr = (ExpressionSegment)this.visit((ParseTree)ctx.expr());
        return new HavingSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), expr);
    }

    @Override
    public final ASTNode visitIntervalExpression(MySQLStatementParser.IntervalExpressionContext ctx) {
        IntervalUnit intervalUnit = IntervalUnit.valueOf((String)ctx.intervalValue().intervalUnit().getText().toUpperCase());
        return new IntervalExpression(ctx.INTERVAL().getSymbol().getStartIndex(), ctx.INTERVAL().getSymbol().getStopIndex(), (ExpressionSegment)this.visit((ParseTree)ctx.intervalValue().expr()), intervalUnit, this.getOriginalText(ctx));
    }

    @Override
    public final ASTNode visitFunctionCall(MySQLStatementParser.FunctionCallContext ctx) {
        if (null != ctx.aggregationFunction()) {
            return (ASTNode)this.visit((ParseTree)ctx.aggregationFunction());
        }
        if (null != ctx.specialFunction()) {
            return (ASTNode)this.visit((ParseTree)ctx.specialFunction());
        }
        if (null != ctx.regularFunction()) {
            return (ASTNode)this.visit((ParseTree)ctx.regularFunction());
        }
        if (null != ctx.jsonFunction()) {
            return (ASTNode)this.visit((ParseTree)ctx.jsonFunction());
        }
        if (null != ctx.udfFunction()) {
            return (ASTNode)this.visit((ParseTree)ctx.udfFunction());
        }
        if (null != ctx.specialAnalysisFunction()) {
            return (ASTNode)this.visit((ParseTree)ctx.specialAnalysisFunction());
        }
        throw new IllegalStateException("FunctionCallContext must have aggregationFunction, regularFunction, specialFunction, jsonFunction, udfFunction or specialAnalysisFunction.");
    }

    @Override
    public ASTNode visitUdfFunction(MySQLStatementParser.UdfFunctionContext ctx) {
        FunctionSegment result = new FunctionSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), this.getOriginalText(ctx), this.getOriginalText(ctx));
        if (null != ctx.expr()) {
            for (MySQLStatementParser.ExprContext each : ctx.expr()) {
                result.getParameters().add((ExpressionSegment)this.visit((ParseTree)each));
            }
        }
        return result;
    }

    @Override
    public ASTNode visitSpecialAnalysisFunction(MySQLStatementParser.SpecialAnalysisFunctionContext ctx) {
        return null != ctx.geomCollectionFunction() ? (ASTNode)this.visit((ParseTree)ctx.geomCollectionFunction()) : new ExpressionProjectionSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), this.getOriginalText(ctx));
    }

    @Override
    public ASTNode visitGeomCollectionFunction(MySQLStatementParser.GeomCollectionFunctionContext ctx) {
        FunctionSegment result = new FunctionSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), ctx.GEOMCOLLECTION().getText(), this.getOriginalText(ctx));
        for (MySQLStatementParser.ExprContext each : ctx.expr()) {
            result.getParameters().add((ExpressionSegment)this.visit((ParseTree)each));
        }
        return result;
    }

    @Override
    public final ASTNode visitAggregationFunction(MySQLStatementParser.AggregationFunctionContext ctx) {
        String aggregationType = ctx.aggregationFunctionName().getText();
        return AggregationType.isAggregationType((String)aggregationType) ? this.createAggregationSegment(ctx, aggregationType) : new ExpressionProjectionSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), this.getOriginalText(ctx));
    }

    @Override
    public ASTNode visitSeparatorName(MySQLStatementParser.SeparatorNameContext ctx) {
        return new StringLiteralValue(ctx.string_().getText());
    }

    @Override
    public final ASTNode visitJsonFunction(MySQLStatementParser.JsonFunctionContext ctx) {
        FunctionSegment result;
        MySQLStatementParser.JsonFunctionNameContext functionNameContext = ctx.jsonFunctionName();
        if (null != functionNameContext) {
            String functionName = functionNameContext.getText();
            result = new FunctionSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), functionName, this.getOriginalText(ctx));
            for (MySQLStatementParser.ExprContext each : ctx.expr()) {
                result.getParameters().add((ExpressionSegment)this.visit((ParseTree)each));
            }
        } else {
            result = null != ctx.JSON_SEPARATOR() ? this.createJsonSeparatorFunction(ctx.JSON_SEPARATOR().getText(), ctx) : (null != ctx.JSON_UNQUOTED_SEPARATOR() ? this.createJsonSeparatorFunction(ctx.JSON_UNQUOTED_SEPARATOR().getText(), ctx) : (FunctionSegment)this.visitJsonTableFunction(ctx.jsonTableFunction()));
        }
        return result;
    }

    private FunctionSegment createJsonSeparatorFunction(String functionName, MySQLStatementParser.JsonFunctionContext ctx) {
        FunctionSegment result = new FunctionSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), functionName, this.getOriginalText(ctx));
        result.getParameters().add((ExpressionSegment)this.visit((ParseTree)ctx.columnRef()));
        result.getParameters().add(new LiteralExpressionSegment(ctx.path().getStart().getStartIndex(), ctx.path().getStop().getStopIndex(), (Object)ctx.path().getText()));
        return result;
    }

    @Override
    public final ASTNode visitJsonTableFunction(MySQLStatementParser.JsonTableFunctionContext ctx) {
        FunctionSegment result = new FunctionSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), ctx.JSON_TABLE().getText(), this.getOriginalText(ctx));
        result.getParameters().add((ExpressionSegment)this.visit((ParseTree)ctx.expr()));
        result.getParameters().add(new LiteralExpressionSegment(ctx.path().getStart().getStartIndex(), ctx.path().getStop().getStopIndex(), (Object)this.getOriginalText(ctx.path())));
        result.getParameters().add(new LiteralExpressionSegment(ctx.jsonTableColumns().getStart().getStartIndex(), ctx.jsonTableColumns().getStop().getStopIndex(), (Object)this.getOriginalText(ctx.jsonTableColumns())));
        return result;
    }

    private ASTNode createAggregationSegment(MySQLStatementParser.AggregationFunctionContext ctx, String aggregationType) {
        AggregationType type = AggregationType.valueOf((String)aggregationType.toUpperCase());
        String separator = null;
        if (null != ctx.separatorName()) {
            separator = new StringLiteralValue(ctx.separatorName().string_().getText()).getValue();
        }
        if (null != ctx.distinct()) {
            AggregationDistinctProjectionSegment result = new AggregationDistinctProjectionSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), type, this.getOriginalText(ctx), this.getDistinctExpression(ctx), separator);
            result.getParameters().addAll(this.getExpressions(ctx.aggregationExpression().expr()));
            return result;
        }
        AggregationProjectionSegment result = new AggregationProjectionSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), type, this.getOriginalText(ctx), separator);
        result.getParameters().addAll(this.getExpressions(ctx.aggregationExpression().expr()));
        return result;
    }

    protected Collection<ExpressionSegment> getExpressions(List<MySQLStatementParser.ExprContext> exprList) {
        if (null == exprList) {
            return Collections.emptyList();
        }
        ArrayList<ExpressionSegment> result = new ArrayList<ExpressionSegment>(exprList.size());
        for (MySQLStatementParser.ExprContext each : exprList) {
            result.add((ExpressionSegment)this.visit((ParseTree)each));
        }
        return result;
    }

    private String getDistinctExpression(MySQLStatementParser.AggregationFunctionContext ctx) {
        return ctx.aggregationExpression().getText();
    }

    @Override
    public final ASTNode visitSpecialFunction(MySQLStatementParser.SpecialFunctionContext ctx) {
        if (null != ctx.groupConcatFunction()) {
            return (ASTNode)this.visit((ParseTree)ctx.groupConcatFunction());
        }
        if (null != ctx.windowFunction()) {
            return (ASTNode)this.visit((ParseTree)ctx.windowFunction());
        }
        if (null != ctx.castFunction()) {
            return (ASTNode)this.visit((ParseTree)ctx.castFunction());
        }
        if (null != ctx.convertFunction()) {
            return (ASTNode)this.visit((ParseTree)ctx.convertFunction());
        }
        if (null != ctx.positionFunction()) {
            return (ASTNode)this.visit((ParseTree)ctx.positionFunction());
        }
        if (null != ctx.substringFunction()) {
            return (ASTNode)this.visit((ParseTree)ctx.substringFunction());
        }
        if (null != ctx.extractFunction()) {
            return (ASTNode)this.visit((ParseTree)ctx.extractFunction());
        }
        if (null != ctx.charFunction()) {
            return (ASTNode)this.visit((ParseTree)ctx.charFunction());
        }
        if (null != ctx.trimFunction()) {
            return (ASTNode)this.visit((ParseTree)ctx.trimFunction());
        }
        if (null != ctx.weightStringFunction()) {
            return (ASTNode)this.visit((ParseTree)ctx.weightStringFunction());
        }
        if (null != ctx.valuesFunction()) {
            return (ASTNode)this.visit((ParseTree)ctx.valuesFunction());
        }
        if (null != ctx.currentUserFunction()) {
            return (ASTNode)this.visit((ParseTree)ctx.currentUserFunction());
        }
        if (null != ctx.timeStampDiffFunction()) {
            return (ASTNode)this.visit((ParseTree)ctx.timeStampDiffFunction());
        }
        if (null != ctx.timeStampAddFunction()) {
            return (ASTNode)this.visit((ParseTree)ctx.timeStampAddFunction());
        }
        return new FunctionSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), this.getOriginalText(ctx), this.getOriginalText(ctx));
    }

    @Override
    public final ASTNode visitGroupConcatFunction(MySQLStatementParser.GroupConcatFunctionContext ctx) {
        FunctionSegment result = new FunctionSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), ctx.GROUP_CONCAT().getText(), this.getOriginalText(ctx));
        for (MySQLStatementParser.ExprContext each : this.getTargetRuleContextFromParseTree((ParseTree)ctx, MySQLStatementParser.ExprContext.class)) {
            result.getParameters().add((ExpressionSegment)this.visit((ParseTree)each));
        }
        return result;
    }

    private <T extends ParseTree> Collection<T> getTargetRuleContextFromParseTree(ParseTree parseTree, Class<? extends T> clazz) {
        LinkedList<Object> result = new LinkedList<Object>();
        for (int index = 0; index < parseTree.getChildCount(); ++index) {
            ParseTree child = parseTree.getChild(index);
            if (clazz.isInstance(child)) {
                result.add((ParseTree)clazz.cast(child));
                continue;
            }
            result.addAll(this.getTargetRuleContextFromParseTree(child, clazz));
        }
        return result;
    }

    @Override
    public final ASTNode visitCastFunction(MySQLStatementParser.CastFunctionContext ctx) {
        FunctionSegment result = new FunctionSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), ctx.CAST().getText(), this.getOriginalText(ctx));
        for (MySQLStatementParser.ExprContext each : ctx.expr()) {
            ASTNode expr = (ASTNode)this.visit((ParseTree)each);
            result.getParameters().add((ExpressionSegment)expr);
        }
        if (null != ctx.castType()) {
            result.getParameters().add((DataTypeSegment)this.visit((ParseTree)ctx.castType()));
        }
        if (null != ctx.DATETIME()) {
            DataTypeSegment dataType = new DataTypeSegment();
            dataType.setDataTypeName(ctx.DATETIME().getText());
            dataType.setStartIndex(ctx.DATETIME().getSymbol().getStartIndex());
            dataType.setStopIndex(ctx.DATETIME().getSymbol().getStopIndex());
            if (null != ctx.typeDatetimePrecision()) {
                dataType.setDataLength((DataTypeLengthSegment)this.visit((ParseTree)ctx.typeDatetimePrecision()));
            }
            result.getParameters().add(dataType);
        }
        return result;
    }

    @Override
    public ASTNode visitCastType(MySQLStatementParser.CastTypeContext ctx) {
        DataTypeLengthSegment dataTypeLengthSegment;
        DataTypeSegment result = new DataTypeSegment();
        result.setDataTypeName(ctx.castTypeName.getText());
        result.setStartIndex(ctx.start.getStartIndex());
        result.setStopIndex(ctx.stop.getStopIndex());
        if (null != ctx.fieldLength()) {
            dataTypeLengthSegment = (DataTypeLengthSegment)this.visit((ParseTree)ctx.fieldLength());
            result.setDataLength(dataTypeLengthSegment);
        }
        if (null != ctx.precision()) {
            dataTypeLengthSegment = (DataTypeLengthSegment)this.visit((ParseTree)ctx.precision());
            result.setDataLength(dataTypeLengthSegment);
        }
        return result;
    }

    @Override
    public final ASTNode visitConvertFunction(MySQLStatementParser.ConvertFunctionContext ctx) {
        FunctionSegment result = new FunctionSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), ctx.CONVERT().getText(), this.getOriginalText(ctx));
        result.getParameters().add((ExpressionSegment)this.visit((ParseTree)ctx.expr()));
        if (null != ctx.castType()) {
            result.getParameters().add((DataTypeSegment)this.visit((ParseTree)ctx.castType()));
        } else if (null != ctx.charsetName()) {
            result.getParameters().add((ExpressionSegment)this.visit((ParseTree)ctx.charsetName()));
        }
        return result;
    }

    @Override
    public ASTNode visitCharsetName(MySQLStatementParser.CharsetNameContext ctx) {
        String charsetName = "";
        if (null != ctx.textOrIdentifier() && null != ctx.textOrIdentifier().getText()) {
            charsetName = ctx.textOrIdentifier().getText();
        } else if (null != ctx.BINARY()) {
            charsetName = ctx.BINARY().getText();
        } else if (null != ctx.DEFAULT()) {
            charsetName = ctx.DEFAULT().getText();
        }
        return new LiteralExpressionSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), (Object)charsetName);
    }

    @Override
    public final ASTNode visitPositionFunction(MySQLStatementParser.PositionFunctionContext ctx) {
        FunctionSegment result = new FunctionSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), ctx.POSITION().getText(), this.getOriginalText(ctx));
        result.getParameters().add((ExpressionSegment)this.visit((ParseTree)ctx.expr(0)));
        result.getParameters().add((ExpressionSegment)this.visit((ParseTree)ctx.expr(1)));
        return result;
    }

    @Override
    public final ASTNode visitSubstringFunction(MySQLStatementParser.SubstringFunctionContext ctx) {
        FunctionSegment result = new FunctionSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), MySQLStatementVisitor.getFunctionName(ctx), this.getOriginalText(ctx));
        result.getParameters().add((ExpressionSegment)this.visit((ParseTree)ctx.expr()));
        for (MySQLStatementParser.SubstringParamContext each : ctx.substringParam()) {
            if (null != each.numberLiterals()) {
                result.getParameters().add(new LiteralExpressionSegment(each.numberLiterals().start.getStartIndex(), each.numberLiterals().stop.getStopIndex(), (Object)new NumberLiteralValue(each.getText()).getValue()));
                continue;
            }
            if (null == each.expr()) continue;
            result.getParameters().add((ExpressionSegment)this.visit((ParseTree)each.expr()));
        }
        return result;
    }

    @Override
    public final ASTNode visitExtractFunction(MySQLStatementParser.ExtractFunctionContext ctx) {
        FunctionSegment result = new FunctionSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), ctx.EXTRACT().getText(), this.getOriginalText(ctx));
        result.getParameters().add(new IntervalUnitExpression(ctx.intervalUnit().getStart().getStartIndex(), ctx.intervalUnit().getStop().getStopIndex(), IntervalUnit.valueOf((String)ctx.intervalUnit().getText().toUpperCase())));
        result.getParameters().add((ExpressionSegment)this.visit((ParseTree)ctx.expr()));
        return result;
    }

    @Override
    public final ASTNode visitCharFunction(MySQLStatementParser.CharFunctionContext ctx) {
        FunctionSegment result = new FunctionSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), ctx.CHAR().getText(), this.getOriginalText(ctx));
        for (MySQLStatementParser.ExprContext each : ctx.expr()) {
            ASTNode expr = (ASTNode)this.visit((ParseTree)each);
            result.getParameters().add((ExpressionSegment)expr);
        }
        return result;
    }

    @Override
    public final ASTNode visitTrimFunction(MySQLStatementParser.TrimFunctionContext ctx) {
        FunctionSegment result = new FunctionSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), ctx.TRIM().getText(), this.getOriginalText(ctx));
        if (null != ctx.BOTH()) {
            result.getParameters().add(new LiteralExpressionSegment(ctx.BOTH().getSymbol().getStartIndex(), ctx.BOTH().getSymbol().getStopIndex(), (Object)new OtherLiteralValue(ctx.BOTH().getSymbol().getText()).getValue()));
        }
        if (null != ctx.TRAILING()) {
            result.getParameters().add(new LiteralExpressionSegment(ctx.TRAILING().getSymbol().getStartIndex(), ctx.TRAILING().getSymbol().getStopIndex(), (Object)new OtherLiteralValue(ctx.TRAILING().getSymbol().getText()).getValue()));
        }
        if (null != ctx.LEADING()) {
            result.getParameters().add(new LiteralExpressionSegment(ctx.LEADING().getSymbol().getStartIndex(), ctx.LEADING().getSymbol().getStopIndex(), (Object)new OtherLiteralValue(ctx.LEADING().getSymbol().getText()).getValue()));
        }
        for (MySQLStatementParser.ExprContext each : ctx.expr()) {
            result.getParameters().add((ExpressionSegment)this.visit((ParseTree)each));
        }
        return result;
    }

    @Override
    public final ASTNode visitWeightStringFunction(MySQLStatementParser.WeightStringFunctionContext ctx) {
        FunctionSegment result = new FunctionSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), ctx.WEIGHT_STRING().getText(), this.getOriginalText(ctx));
        result.getParameters().add((ExpressionSegment)this.visit((ParseTree)ctx.expr()));
        return result;
    }

    @Override
    public final ASTNode visitValuesFunction(MySQLStatementParser.ValuesFunctionContext ctx) {
        FunctionSegment result = new FunctionSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), ctx.VALUES().getText(), this.getOriginalText(ctx));
        if (!ctx.columnRefList().columnRef().isEmpty()) {
            ColumnSegment columnSegment = (ColumnSegment)this.visit((ParseTree)ctx.columnRefList().columnRef(0));
            result.getParameters().add(columnSegment);
        }
        return result;
    }

    @Override
    public final ASTNode visitCurrentUserFunction(MySQLStatementParser.CurrentUserFunctionContext ctx) {
        return new FunctionSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), ctx.CURRENT_USER().getText(), this.getOriginalText(ctx));
    }

    @Override
    public ASTNode visitTimeStampAddFunction(MySQLStatementParser.TimeStampAddFunctionContext ctx) {
        FunctionSegment result = new FunctionSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), ctx.TIMESTAMPADD().getText(), this.getOriginalText(ctx));
        result.getParameters().add(new IntervalUnitExpression(ctx.intervalUnit().getStart().getStartIndex(), ctx.intervalUnit().getStop().getStopIndex(), IntervalUnit.valueOf((String)ctx.intervalUnit().getText().toUpperCase())));
        result.getParameters().addAll(this.getExpressions(ctx.expr()));
        return result;
    }

    @Override
    public ASTNode visitTimeStampDiffFunction(MySQLStatementParser.TimeStampDiffFunctionContext ctx) {
        FunctionSegment result = new FunctionSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), ctx.TIMESTAMPDIFF().getText(), this.getOriginalText(ctx));
        result.getParameters().add(new IntervalUnitExpression(ctx.intervalUnit().getStart().getStartIndex(), ctx.intervalUnit().getStop().getStopIndex(), IntervalUnit.valueOf((String)ctx.intervalUnit().getText().toUpperCase())));
        result.getParameters().addAll(this.getExpressions(ctx.expr()));
        return result;
    }

    @Override
    public final ASTNode visitRegularFunction(MySQLStatementParser.RegularFunctionContext ctx) {
        return null == ctx.completeRegularFunction() ? (ASTNode)this.visit((ParseTree)ctx.shorthandRegularFunction()) : (ASTNode)this.visit((ParseTree)ctx.completeRegularFunction());
    }

    @Override
    public ASTNode visitCompleteRegularFunction(MySQLStatementParser.CompleteRegularFunctionContext ctx) {
        FunctionSegment result = new FunctionSegment(ctx.start.getStartIndex(), ctx.stop.getStopIndex(), ctx.regularFunctionName().getText(), this.getOriginalText(ctx));
        Collection expressionSegments = ctx.expr().stream().map(each -> (ExpressionSegment)this.visit((ParseTree)each)).collect(Collectors.toList());
        result.getParameters().addAll(expressionSegments);
        return result;
    }

    @Override
    public ASTNode visitShorthandRegularFunction(MySQLStatementParser.ShorthandRegularFunctionContext ctx) {
        FunctionSegment result;
        String text = this.getOriginalText(ctx);
        if (null != ctx.CURRENT_TIME()) {
            result = new FunctionSegment(ctx.start.getStartIndex(), ctx.stop.getStopIndex(), ctx.CURRENT_TIME().getText(), text);
            if (null != ctx.NUMBER_()) {
                result.getParameters().add(new LiteralExpressionSegment(ctx.NUMBER_().getSymbol().getStartIndex(), ctx.NUMBER_().getSymbol().getStopIndex(), (Object)new NumberLiteralValue(ctx.NUMBER_().getText())));
            }
        } else {
            result = new FunctionSegment(ctx.start.getStartIndex(), ctx.stop.getStopIndex(), ctx.getText(), text);
        }
        return result;
    }

    private ASTNode visitRemainSimpleExpr(MySQLStatementParser.SimpleExprContext ctx) {
        if (null != ctx.caseExpression()) {
            return (ASTNode)this.visit((ParseTree)ctx.caseExpression());
        }
        if (null != ctx.BINARY()) {
            return new UnaryOperationExpression(ctx.start.getStartIndex(), ctx.stop.getStopIndex(), (ExpressionSegment)this.visit((ParseTree)ctx.simpleExpr(0)), ctx.BINARY().getText(), ctx.getText());
        }
        if (null != ctx.TILDE_()) {
            return new UnaryOperationExpression(ctx.start.getStartIndex(), ctx.stop.getStopIndex(), (ExpressionSegment)this.visit((ParseTree)ctx.simpleExpr(0)), "~", ctx.getText());
        }
        if (null != ctx.PLUS_()) {
            return new UnaryOperationExpression(ctx.start.getStartIndex(), ctx.stop.getStopIndex(), (ExpressionSegment)this.visit((ParseTree)ctx.simpleExpr(0)), "+", ctx.getText());
        }
        if (null != ctx.MINUS_()) {
            return new UnaryOperationExpression(ctx.start.getStartIndex(), ctx.stop.getStopIndex(), (ExpressionSegment)this.visit((ParseTree)ctx.simpleExpr(0)), "-", ctx.getText());
        }
        if (null != ctx.variable()) {
            return (ASTNode)this.visit((ParseTree)ctx.variable());
        }
        if (null != ctx.LP_()) {
            RowExpression result = new RowExpression(ctx.start.getStartIndex(), ctx.stop.getStopIndex(), ctx.getText());
            for (MySQLStatementParser.ExprContext each : ctx.expr()) {
                result.getItems().add((ExpressionSegment)this.visit((ParseTree)each));
            }
            return result;
        }
        if (null != ctx.RETURNING()) {
            ListExpression result = new ListExpression(ctx.start.getStartIndex(), ctx.stop.getStopIndex());
            result.getItems().add(new LiteralExpressionSegment(ctx.path().start.getStartIndex(), ctx.path().stop.getStopIndex(), (Object)ctx.path().getText()));
            result.getItems().add(new LiteralExpressionSegment(ctx.RETURNING().getSymbol().getStartIndex(), ctx.RETURNING().getSymbol().getStopIndex(), (Object)ctx.RETURNING().getSymbol().getText()));
            result.getItems().add((ExpressionSegment)this.visit((ParseTree)ctx.dataType()));
            return result;
        }
        if (null != ctx.LBE_()) {
            return (ASTNode)this.visit((ParseTree)ctx.expr(0));
        }
        for (MySQLStatementParser.ExprContext exprContext : ctx.expr()) {
            this.visit((ParseTree)exprContext);
        }
        for (MySQLStatementParser.SimpleExprContext simpleExprContext : ctx.simpleExpr()) {
            this.visit((ParseTree)simpleExprContext);
        }
        String text = ctx.start.getInputStream().getText(new Interval(ctx.start.getStartIndex(), ctx.stop.getStopIndex()));
        return new CommonExpressionSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), text);
    }

    @Override
    public ASTNode visitCaseExpression(MySQLStatementParser.CaseExpressionContext ctx) {
        LinkedList<ExpressionSegment> whenExprs = new LinkedList<ExpressionSegment>();
        LinkedList<ExpressionSegment> thenExprs = new LinkedList<ExpressionSegment>();
        for (MySQLStatementParser.CaseWhenContext each : ctx.caseWhen()) {
            whenExprs.add((ExpressionSegment)this.visit((ParseTree)each.expr(0)));
            thenExprs.add((ExpressionSegment)this.visit((ParseTree)each.expr(1)));
        }
        ExpressionSegment caseExpr = null == ctx.expr() ? null : (ExpressionSegment)this.visit((ParseTree)ctx.expr());
        ExpressionSegment elseExpr = null == ctx.caseElse() ? null : (ExpressionSegment)this.visit((ParseTree)ctx.caseElse().expr());
        return new CaseWhenExpression(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), caseExpr, whenExprs, thenExprs, elseExpr, this.getOriginalText(ctx));
    }

    @Override
    public ASTNode visitVariable(MySQLStatementParser.VariableContext ctx) {
        return null == ctx.systemVariable() ? (ASTNode)this.visit((ParseTree)ctx.userVariable()) : (ASTNode)this.visit((ParseTree)ctx.systemVariable());
    }

    @Override
    public ASTNode visitUserVariable(MySQLStatementParser.UserVariableContext ctx) {
        return new VariableSegment(ctx.start.getStartIndex(), ctx.stop.getStopIndex(), ctx.textOrIdentifier().getText());
    }

    @Override
    public ASTNode visitSystemVariable(MySQLStatementParser.SystemVariableContext ctx) {
        VariableSegment result = new VariableSegment(ctx.start.getStartIndex(), ctx.stop.getStopIndex(), ctx.rvalueSystemVariable().getText());
        if (null != ctx.systemVariableScope) {
            result.setScope(ctx.systemVariableScope.getText());
        }
        return result;
    }

    @Override
    public final ASTNode visitMatchExpression(MySQLStatementParser.MatchExpressionContext ctx) {
        ExpressionSegment expressionSegment = (ExpressionSegment)this.visit((ParseTree)ctx.expr());
        MatchAgainstExpression result = new MatchAgainstExpression(ctx.start.getStartIndex(), ctx.stop.getStopIndex(), expressionSegment, this.getOriginalText(ctx.matchSearchModifier()), this.getOriginalText(ctx));
        for (MySQLStatementParser.ColumnRefContext each : ctx.columnRefList().columnRef()) {
            result.getColumns().add((ColumnSegment)this.visit((ParseTree)each));
        }
        return result;
    }

    @Override
    public final ASTNode visitDataType(MySQLStatementParser.DataTypeContext ctx) {
        DataTypeLengthSegment dataTypeLengthSegment;
        DataTypeSegment result = new DataTypeSegment();
        result.setDataTypeName(ctx.dataTypeName.getText());
        result.setStartIndex(ctx.start.getStartIndex());
        result.setStopIndex(ctx.stop.getStopIndex());
        if (null != ctx.fieldLength()) {
            dataTypeLengthSegment = (DataTypeLengthSegment)this.visit((ParseTree)ctx.fieldLength());
            result.setDataLength(dataTypeLengthSegment);
        }
        if (null != ctx.precision()) {
            dataTypeLengthSegment = (DataTypeLengthSegment)this.visit((ParseTree)ctx.precision());
            result.setDataLength(dataTypeLengthSegment);
        }
        return result;
    }

    @Override
    public ASTNode visitFieldLength(MySQLStatementParser.FieldLengthContext ctx) {
        DataTypeLengthSegment result = new DataTypeLengthSegment();
        result.setStartIndex(ctx.start.getStartIndex());
        result.setStopIndex(ctx.stop.getStartIndex());
        result.setPrecision(new BigDecimal(ctx.length.getText()).intValue());
        return result;
    }

    @Override
    public ASTNode visitPrecision(MySQLStatementParser.PrecisionContext ctx) {
        DataTypeLengthSegment result = new DataTypeLengthSegment();
        result.setStartIndex(ctx.start.getStartIndex());
        result.setStopIndex(ctx.stop.getStartIndex());
        List<TerminalNode> numbers = ctx.NUMBER_();
        result.setPrecision(Integer.parseInt(numbers.get(0).getText()));
        result.setScale(Integer.parseInt(numbers.get(1).getText()));
        return result;
    }

    @Override
    public ASTNode visitTypeDatetimePrecision(MySQLStatementParser.TypeDatetimePrecisionContext ctx) {
        DataTypeLengthSegment result = new DataTypeLengthSegment();
        result.setStartIndex(ctx.start.getStartIndex());
        result.setStopIndex(ctx.stop.getStartIndex());
        result.setPrecision(Integer.parseInt(ctx.NUMBER_().getText()));
        return result;
    }

    @Override
    public final ASTNode visitOrderByClause(MySQLStatementParser.OrderByClauseContext ctx) {
        LinkedList<OrderByItemSegment> items = new LinkedList<OrderByItemSegment>();
        for (MySQLStatementParser.OrderByItemContext each : ctx.orderByItem()) {
            items.add((OrderByItemSegment)this.visit((ParseTree)each));
        }
        return new OrderBySegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), items);
    }

    @Override
    public final ASTNode visitOrderByItem(MySQLStatementParser.OrderByItemContext ctx) {
        OrderDirection orderDirection = null != ctx.direction() ? (null == ctx.direction().DESC() ? OrderDirection.ASC : OrderDirection.DESC) : OrderDirection.ASC;
        if (null != ctx.numberLiterals()) {
            return new IndexOrderByItemSegment(ctx.numberLiterals().getStart().getStartIndex(), ctx.numberLiterals().getStop().getStopIndex(), SQLUtils.getExactlyNumber((String)ctx.numberLiterals().getText(), (int)10).intValue(), orderDirection, null);
        }
        ASTNode expr = this.visitExpr(ctx.expr());
        if (expr instanceof ColumnSegment) {
            return new ColumnOrderByItemSegment((ColumnSegment)expr, orderDirection, null);
        }
        return new ExpressionOrderByItemSegment(ctx.expr().getStart().getStartIndex(), ctx.expr().getStop().getStopIndex(), this.getOriginalText(ctx.expr()), orderDirection, null, (ExpressionSegment)expr);
    }

    @Override
    public ASTNode visitInsert(MySQLStatementParser.InsertContext ctx) {
        InsertStatement result = (InsertStatement)this.visit((ParseTree)ctx.insertBody());
        if (null != ctx.onDuplicateKeyClause()) {
            result.setOnDuplicateKeyColumns((OnDuplicateKeyColumnsSegment)this.visit((ParseTree)ctx.onDuplicateKeyClause()));
        }
        result.setIgnore(null != ctx.insertSpecification().IGNORE());
        result.setTable((SimpleTableSegment)this.visit((ParseTree)ctx.tableName()));
        result.addParameterMarkers(this.getParameterMarkerSegments());
        if (null != ctx.returningClause()) {
            result.setReturning((ReturningSegment)this.visit((ParseTree)ctx.returningClause()));
        }
        return result;
    }

    @Override
    public ASTNode visitInsertBody(MySQLStatementParser.InsertBodyContext ctx) {
        InsertStatement result;
        if (null != ctx.insertValuesClause()) {
            result = (InsertStatement)this.visit((ParseTree)ctx.insertValuesClause());
        } else if (null != ctx.insertSelectClause()) {
            result = (InsertStatement)this.visit((ParseTree)ctx.insertSelectClause());
            if (null != ctx.valueReference()) {
                result.setValueReference((ValueReferenceSegment)this.visit((ParseTree)ctx.valueReference()));
            }
        } else {
            result = new InsertStatement(this.databaseType);
            result.setSetAssignment((SetAssignmentSegment)this.visit((ParseTree)ctx.setAssignmentsClause()));
            if (null != ctx.valueReference()) {
                result.setValueReference((ValueReferenceSegment)this.visit((ParseTree)ctx.valueReference()));
            }
            if (null == ctx.valueReference() && null != ctx.setAssignmentsClause().setRowAlias()) {
                result.setValueReference(this.createValueReferenceFromSetRowAlias(ctx.setAssignmentsClause().setRowAlias()));
            }
        }
        return result;
    }

    @Override
    public ASTNode visitInsertSelectClause(MySQLStatementParser.InsertSelectClauseContext ctx) {
        InsertStatement result = new InsertStatement(this.databaseType);
        result.setInsertSelect(this.createInsertSelectSegment(ctx));
        if (null != ctx.LP_() && !ctx.LP_().isEmpty()) {
            if (null != ctx.fields()) {
                result.setInsertColumns(new InsertColumnsSegment(ctx.LP_().get(0).getSymbol().getStartIndex(), ctx.RP_().get(0).getSymbol().getStopIndex(), this.createInsertColumns(ctx.fields())));
            } else {
                result.setInsertColumns(new InsertColumnsSegment(ctx.LP_().get(0).getSymbol().getStartIndex(), ctx.RP_().get(0).getSymbol().getStopIndex(), Collections.emptyList()));
            }
        } else {
            result.setInsertColumns(new InsertColumnsSegment(ctx.start.getStartIndex() - 1, ctx.start.getStartIndex() - 1, Collections.emptyList()));
        }
        return result;
    }

    private ValueReferenceSegment createValueReferenceFromSetRowAlias(MySQLStatementParser.SetRowAliasContext ctx) {
        AliasSegment alias = (AliasSegment)this.visit((ParseTree)ctx.alias());
        LinkedList<ColumnSegment> derivedColumns = null;
        if (null != ctx.derivedColumns()) {
            derivedColumns = new LinkedList<ColumnSegment>();
            for (MySQLStatementParser.AliasContext each : ctx.derivedColumns().alias()) {
                AliasSegment aliasSegment = (AliasSegment)this.visit((ParseTree)each);
                ColumnSegment column = new ColumnSegment(each.getStart().getStartIndex(), each.getStop().getStopIndex(), aliasSegment.getIdentifier());
                derivedColumns.add(column);
            }
        }
        return new ValueReferenceSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), alias, derivedColumns);
    }

    private SubquerySegment createInsertSelectSegment(MySQLStatementParser.InsertSelectClauseContext ctx) {
        SelectStatement selectStatement = (SelectStatement)this.visit((ParseTree)ctx.select());
        selectStatement.addParameterMarkers(this.getParameterMarkerSegments());
        return new SubquerySegment(ctx.select().start.getStartIndex(), ctx.select().stop.getStopIndex(), selectStatement, this.getOriginalText(ctx.select()));
    }

    @Override
    public ASTNode visitInsertValuesClause(MySQLStatementParser.InsertValuesClauseContext ctx) {
        InsertStatement result = new InsertStatement(this.databaseType);
        if (null != ctx.LP_()) {
            if (null != ctx.fields()) {
                result.setInsertColumns(new InsertColumnsSegment(ctx.LP_().getSymbol().getStartIndex(), ctx.RP_().getSymbol().getStopIndex(), this.createInsertColumns(ctx.fields())));
            } else {
                result.setInsertColumns(new InsertColumnsSegment(ctx.LP_().getSymbol().getStartIndex(), ctx.RP_().getSymbol().getStopIndex(), Collections.emptyList()));
            }
        } else {
            result.setInsertColumns(new InsertColumnsSegment(ctx.start.getStartIndex() - 1, ctx.start.getStartIndex() - 1, Collections.emptyList()));
        }
        if (null != ctx.valueReference()) {
            ValueReferenceSegment valueRef = (ValueReferenceSegment)this.visit((ParseTree)ctx.valueReference());
            result.setValueReference(valueRef);
        }
        Collection<InsertValuesSegment> insertValuesSegments = null == ctx.rowConstructorList() ? this.createInsertValuesSegments(ctx.assignmentValues()) : this.createRowConstructorList(ctx.rowConstructorList());
        result.getValues().addAll(insertValuesSegments);
        return result;
    }

    private Collection<InsertValuesSegment> createInsertValuesSegments(Collection<MySQLStatementParser.AssignmentValuesContext> assignmentValuesContexts) {
        LinkedList<InsertValuesSegment> result = new LinkedList<InsertValuesSegment>();
        for (MySQLStatementParser.AssignmentValuesContext each : assignmentValuesContexts) {
            result.add((InsertValuesSegment)this.visit((ParseTree)each));
        }
        return result;
    }

    @Override
    public ASTNode visitRowAlias(MySQLStatementParser.RowAliasContext ctx) {
        AliasSegment alias = (AliasSegment)this.visit((ParseTree)ctx.alias());
        LinkedList<ColumnSegment> derivedColumns = null;
        if (null != ctx.derivedColumns()) {
            derivedColumns = new LinkedList<ColumnSegment>();
            for (MySQLStatementParser.AliasContext each : ctx.derivedColumns().alias()) {
                AliasSegment aliasSegment = (AliasSegment)this.visit((ParseTree)each);
                ColumnSegment column = new ColumnSegment(each.getStart().getStartIndex(), each.getStop().getStopIndex(), aliasSegment.getIdentifier());
                derivedColumns.add(column);
            }
        }
        return new RowAliasSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), alias, derivedColumns);
    }

    @Override
    public ASTNode visitValueReference(MySQLStatementParser.ValueReferenceContext ctx) {
        AliasSegment alias = (AliasSegment)this.visit((ParseTree)ctx.alias());
        LinkedList<ColumnSegment> derivedColumns = null;
        if (null != ctx.derivedColumns()) {
            derivedColumns = new LinkedList<ColumnSegment>();
            for (MySQLStatementParser.AliasContext each : ctx.derivedColumns().alias()) {
                AliasSegment aliasSegment = (AliasSegment)this.visit((ParseTree)each);
                ColumnSegment column = new ColumnSegment(each.getStart().getStartIndex(), each.getStop().getStopIndex(), aliasSegment.getIdentifier());
                derivedColumns.add(column);
            }
        }
        return new ValueReferenceSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), alias, derivedColumns);
    }

    @Override
    public ASTNode visitOnDuplicateKeyClause(MySQLStatementParser.OnDuplicateKeyClauseContext ctx) {
        LinkedList<ColumnAssignmentSegment> columns = new LinkedList<ColumnAssignmentSegment>();
        for (MySQLStatementParser.AssignmentContext each : ctx.assignment()) {
            columns.add((ColumnAssignmentSegment)this.visit((ParseTree)each));
        }
        return new OnDuplicateKeyColumnsSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), columns);
    }

    @Override
    public ASTNode visitReplace(MySQLStatementParser.ReplaceContext ctx) {
        InsertStatement result;
        if (null != ctx.replaceValuesClause()) {
            result = (InsertStatement)this.visit((ParseTree)ctx.replaceValuesClause());
        } else if (null != ctx.replaceSelectClause()) {
            result = (InsertStatement)this.visit((ParseTree)ctx.replaceSelectClause());
        } else {
            result = new InsertStatement(this.databaseType);
            result.setSetAssignment((SetAssignmentSegment)this.visit((ParseTree)ctx.setAssignmentsClause()));
        }
        result.setReplace(true);
        result.setTable((SimpleTableSegment)this.visit((ParseTree)ctx.tableName()));
        result.addParameterMarkers(this.getParameterMarkerSegments());
        if (null != ctx.returningClause()) {
            result.setReturning((ReturningSegment)this.visit((ParseTree)ctx.returningClause()));
        }
        return result;
    }

    @Override
    public ASTNode visitReplaceSelectClause(MySQLStatementParser.ReplaceSelectClauseContext ctx) {
        InsertStatement result = new InsertStatement(this.databaseType);
        if (null != ctx.LP_()) {
            if (null != ctx.fields()) {
                result.setInsertColumns(new InsertColumnsSegment(ctx.LP_().getSymbol().getStartIndex(), ctx.RP_().getSymbol().getStopIndex(), this.createInsertColumns(ctx.fields())));
            } else {
                result.setInsertColumns(new InsertColumnsSegment(ctx.LP_().getSymbol().getStartIndex(), ctx.RP_().getSymbol().getStopIndex(), Collections.emptyList()));
            }
        } else {
            result.setInsertColumns(new InsertColumnsSegment(ctx.start.getStartIndex() - 1, ctx.start.getStartIndex() - 1, Collections.emptyList()));
        }
        result.setInsertSelect(this.createReplaceSelectSegment(ctx));
        return result;
    }

    private SubquerySegment createReplaceSelectSegment(MySQLStatementParser.ReplaceSelectClauseContext ctx) {
        SelectStatement selectStatement = (SelectStatement)this.visit((ParseTree)ctx.select());
        return new SubquerySegment(ctx.select().start.getStartIndex(), ctx.select().stop.getStopIndex(), selectStatement, this.getOriginalText(ctx.select()));
    }

    @Override
    public ASTNode visitReplaceValuesClause(MySQLStatementParser.ReplaceValuesClauseContext ctx) {
        InsertStatement result = new InsertStatement(this.databaseType);
        if (null != ctx.LP_()) {
            if (null != ctx.fields()) {
                result.setInsertColumns(new InsertColumnsSegment(ctx.LP_().getSymbol().getStartIndex(), ctx.RP_().getSymbol().getStopIndex(), this.createInsertColumns(ctx.fields())));
            } else {
                result.setInsertColumns(new InsertColumnsSegment(ctx.LP_().getSymbol().getStartIndex(), ctx.RP_().getSymbol().getStopIndex(), Collections.emptyList()));
            }
        } else {
            result.setInsertColumns(new InsertColumnsSegment(ctx.start.getStartIndex() - 1, ctx.start.getStartIndex() - 1, Collections.emptyList()));
        }
        result.getValues().addAll(this.createInsertValuesSegments(ctx.assignmentValues()));
        return result;
    }

    private List<ColumnSegment> createInsertColumns(MySQLStatementParser.FieldsContext fields) {
        LinkedList<ColumnSegment> result = new LinkedList<ColumnSegment>();
        for (MySQLStatementParser.InsertIdentifierContext each : fields.insertIdentifier()) {
            result.add((ColumnSegment)this.visit((ParseTree)each));
        }
        return result;
    }

    @Override
    public ASTNode visitUpdate(MySQLStatementParser.UpdateContext ctx) {
        UpdateStatement result = new UpdateStatement(this.databaseType);
        TableSegment tableSegment = (TableSegment)this.visit((ParseTree)ctx.tableReferences());
        result.setTable(tableSegment);
        result.setSetAssignment((SetAssignmentSegment)this.visit((ParseTree)ctx.setAssignmentsClause()));
        if (null != ctx.whereClause()) {
            result.setWhere((WhereSegment)this.visit((ParseTree)ctx.whereClause()));
        }
        if (null != ctx.orderByClause()) {
            result.setOrderBy((OrderBySegment)this.visit((ParseTree)ctx.orderByClause()));
        }
        if (null != ctx.limitClause()) {
            result.setLimit((LimitSegment)this.visit((ParseTree)ctx.limitClause()));
        }
        if (null != ctx.withClause()) {
            result.setWith((WithSegment)this.visit((ParseTree)ctx.withClause()));
        }
        result.addParameterMarkers(this.getParameterMarkerSegments());
        return result;
    }

    @Override
    public ASTNode visitSetAssignmentsClause(MySQLStatementParser.SetAssignmentsClauseContext ctx) {
        LinkedList<ColumnAssignmentSegment> assignments = new LinkedList<ColumnAssignmentSegment>();
        for (MySQLStatementParser.AssignmentContext each : ctx.assignmentList().assignment()) {
            assignments.add((ColumnAssignmentSegment)this.visit((ParseTree)each));
        }
        return new SetAssignmentSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), assignments);
    }

    @Override
    public ASTNode visitAssignmentValues(MySQLStatementParser.AssignmentValuesContext ctx) {
        LinkedList<ExpressionSegment> segments = new LinkedList<ExpressionSegment>();
        for (MySQLStatementParser.AssignmentValueContext each : ctx.assignmentValue()) {
            segments.add((ExpressionSegment)this.visit((ParseTree)each));
        }
        return new InsertValuesSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), segments);
    }

    @Override
    public ASTNode visitAssignment(MySQLStatementParser.AssignmentContext ctx) {
        ColumnSegment column = (ColumnSegment)this.visit((ParseTree)ctx.columnRef());
        ExpressionSegment value = (ExpressionSegment)this.visit((ParseTree)ctx.assignmentValue());
        LinkedList<ColumnSegment> columnSegments = new LinkedList<ColumnSegment>();
        columnSegments.add(column);
        return new ColumnAssignmentSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), columnSegments, value);
    }

    @Override
    public ASTNode visitAssignmentValue(MySQLStatementParser.AssignmentValueContext ctx) {
        MySQLStatementParser.ExprContext expr = ctx.expr();
        if (null != expr) {
            return (ASTNode)this.visit((ParseTree)expr);
        }
        return new CommonExpressionSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), ctx.getText());
    }

    @Override
    public ASTNode visitBlobValue(MySQLStatementParser.BlobValueContext ctx) {
        return new StringLiteralValue(ctx.string_().getText());
    }

    @Override
    public ASTNode visitDelete(MySQLStatementParser.DeleteContext ctx) {
        DeleteStatement result = new DeleteStatement(this.databaseType);
        if (null != ctx.multipleTablesClause()) {
            result.setTable((TableSegment)this.visit((ParseTree)ctx.multipleTablesClause()));
        } else {
            result.setTable((TableSegment)this.visit((ParseTree)ctx.singleTableClause()));
        }
        if (null != ctx.whereClause()) {
            result.setWhere((WhereSegment)this.visit((ParseTree)ctx.whereClause()));
        }
        if (null != ctx.orderByClause()) {
            result.setOrderBy((OrderBySegment)this.visit((ParseTree)ctx.orderByClause()));
        }
        if (null != ctx.limitClause()) {
            result.setLimit((LimitSegment)this.visit((ParseTree)ctx.limitClause()));
        }
        result.addParameterMarkers(this.getParameterMarkerSegments());
        if (null != ctx.returningClause()) {
            result.setReturning((ReturningSegment)this.visit((ParseTree)ctx.returningClause()));
        }
        if (null != ctx.withClause()) {
            result.setWith((WithSegment)this.visit((ParseTree)ctx.withClause()));
        }
        return result;
    }

    @Override
    public ASTNode visitSingleTableClause(MySQLStatementParser.SingleTableClauseContext ctx) {
        SimpleTableSegment result = (SimpleTableSegment)this.visit((ParseTree)ctx.tableName());
        if (null != ctx.alias()) {
            result.setAlias((AliasSegment)this.visit((ParseTree)ctx.alias()));
        }
        return result;
    }

    @Override
    public ASTNode visitMultipleTablesClause(MySQLStatementParser.MultipleTablesClauseContext ctx) {
        DeleteMultiTableSegment result = new DeleteMultiTableSegment();
        TableSegment relateTableSource = (TableSegment)this.visit((ParseTree)ctx.tableReferences());
        result.setRelationTable(relateTableSource);
        result.setActualDeleteTables(this.generateTablesFromTableAliasRefList(ctx.tableAliasRefList()));
        return result;
    }

    private List<SimpleTableSegment> generateTablesFromTableAliasRefList(MySQLStatementParser.TableAliasRefListContext ctx) {
        LinkedList<SimpleTableSegment> result = new LinkedList<SimpleTableSegment>();
        for (MySQLStatementParser.TableIdentOptWildContext each : ctx.tableIdentOptWild()) {
            result.add((SimpleTableSegment)this.visit((ParseTree)each.tableName()));
        }
        return result;
    }

    @Override
    public ASTNode visitSelect(MySQLStatementParser.SelectContext ctx) {
        SelectStatement result;
        if (null != ctx.queryExpression()) {
            result = (SelectStatement)this.visit((ParseTree)ctx.queryExpression());
            if (null != ctx.lockClauseList()) {
                result.setLock((LockSegment)this.visit((ParseTree)ctx.lockClauseList()));
            }
        } else {
            result = null != ctx.selectWithInto() ? (SelectStatement)this.visit((ParseTree)ctx.selectWithInto()) : (SelectStatement)this.visit(ctx.getChild(0));
        }
        result.addParameterMarkers(this.getParameterMarkerSegments());
        return result;
    }

    private boolean isDistinct(MySQLStatementParser.QuerySpecificationContext ctx) {
        for (MySQLStatementParser.SelectSpecificationContext each : ctx.selectSpecification()) {
            if (!((BooleanLiteralValue)this.visit((ParseTree)each)).getValue().booleanValue()) continue;
            return true;
        }
        return false;
    }

    @Override
    public ASTNode visitSelectSpecification(MySQLStatementParser.SelectSpecificationContext ctx) {
        if (null != ctx.duplicateSpecification()) {
            return (ASTNode)this.visit((ParseTree)ctx.duplicateSpecification());
        }
        return new BooleanLiteralValue(false);
    }

    @Override
    public ASTNode visitDuplicateSpecification(MySQLStatementParser.DuplicateSpecificationContext ctx) {
        String text = ctx.getText();
        if ("DISTINCT".equalsIgnoreCase(text) || "DISTINCTROW".equalsIgnoreCase(text)) {
            return new BooleanLiteralValue(true);
        }
        return new BooleanLiteralValue(false);
    }

    @Override
    public ASTNode visitProjections(MySQLStatementParser.ProjectionsContext ctx) {
        LinkedList<Object> projections = new LinkedList<Object>();
        if (null != ctx.unqualifiedShorthand()) {
            projections.add(new ShorthandProjectionSegment(ctx.unqualifiedShorthand().getStart().getStartIndex(), ctx.unqualifiedShorthand().getStop().getStopIndex()));
        }
        for (MySQLStatementParser.ProjectionContext each : ctx.projection()) {
            projections.add((ProjectionSegment)this.visit((ParseTree)each));
        }
        ProjectionsSegment result = new ProjectionsSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex());
        result.getProjections().addAll(projections);
        return result;
    }

    @Override
    public ASTNode visitProjection(MySQLStatementParser.ProjectionContext ctx) {
        if (null != ctx.qualifiedShorthand()) {
            return this.createShorthandProjection(ctx.qualifiedShorthand());
        }
        AliasSegment alias = null == ctx.alias() ? null : (AliasSegment)this.visit((ParseTree)ctx.alias());
        ExpressionSegment exprProjection = (ExpressionSegment)this.visit((ParseTree)ctx.expr());
        if (exprProjection instanceof ColumnSegment) {
            ColumnProjectionSegment result = new ColumnProjectionSegment((ColumnSegment)exprProjection);
            result.setAlias(alias);
            return result;
        }
        if (exprProjection instanceof SubquerySegment) {
            SubquerySegment subquerySegment = (SubquerySegment)exprProjection;
            String text = ctx.start.getInputStream().getText(new Interval(subquerySegment.getStartIndex(), subquerySegment.getStopIndex()));
            SubqueryProjectionSegment result = new SubqueryProjectionSegment((SubquerySegment)exprProjection, text);
            result.setAlias(alias);
            return result;
        }
        return this.createProjection(ctx, alias, exprProjection);
    }

    private ShorthandProjectionSegment createShorthandProjection(MySQLStatementParser.QualifiedShorthandContext shorthand) {
        ShorthandProjectionSegment result = new ShorthandProjectionSegment(shorthand.getStart().getStartIndex(), shorthand.getStop().getStopIndex());
        MySQLStatementParser.IdentifierContext identifier = shorthand.identifier().get(shorthand.identifier().size() - 1);
        OwnerSegment owner = new OwnerSegment(identifier.getStart().getStartIndex(), identifier.getStop().getStopIndex(), new IdentifierValue(identifier.getText()));
        result.setOwner(owner);
        if (shorthand.identifier().size() > 1) {
            MySQLStatementParser.IdentifierContext databaseIdentifier = shorthand.identifier().get(0);
            owner.setOwner(new OwnerSegment(databaseIdentifier.getStart().getStartIndex(), databaseIdentifier.getStop().getStopIndex(), new IdentifierValue(databaseIdentifier.getText())));
        }
        return result;
    }

    @Override
    public ASTNode visitAlias(MySQLStatementParser.AliasContext ctx) {
        return new AliasSegment(ctx.start.getStartIndex(), ctx.stop.getStopIndex(), new IdentifierValue(ctx.textOrIdentifier().getText()));
    }

    private ASTNode createProjection(MySQLStatementParser.ProjectionContext ctx, AliasSegment alias, ExpressionSegment projection) {
        if (projection instanceof AggregationProjectionSegment) {
            ((AggregationProjectionSegment)projection).setAlias(alias);
            return projection;
        }
        if (projection instanceof ExpressionProjectionSegment) {
            ((ExpressionProjectionSegment)projection).setAlias(alias);
            return projection;
        }
        if (projection instanceof FunctionSegment) {
            FunctionSegment functionSegment = (FunctionSegment)projection;
            ExpressionProjectionSegment result = new ExpressionProjectionSegment(functionSegment.getStartIndex(), functionSegment.getStopIndex(), functionSegment.getText(), (ExpressionSegment)functionSegment);
            result.setAlias(alias);
            return result;
        }
        if (projection instanceof CommonExpressionSegment) {
            CommonExpressionSegment segment = (CommonExpressionSegment)projection;
            ExpressionProjectionSegment result = new ExpressionProjectionSegment(segment.getStartIndex(), segment.getStopIndex(), segment.getText(), (ExpressionSegment)segment);
            result.setAlias(alias);
            return result;
        }
        if (projection instanceof ColumnSegment) {
            ExpressionProjectionSegment result = new ExpressionProjectionSegment(ctx.start.getStartIndex(), ctx.stop.getStopIndex(), this.getOriginalText(ctx), projection);
            result.setAlias(alias);
            return result;
        }
        if (projection instanceof SubqueryExpressionSegment) {
            SubqueryExpressionSegment subqueryExpressionSegment = (SubqueryExpressionSegment)projection;
            String text = ctx.start.getInputStream().getText(new Interval(subqueryExpressionSegment.getStartIndex(), subqueryExpressionSegment.getStopIndex()));
            SubqueryProjectionSegment result = new SubqueryProjectionSegment(subqueryExpressionSegment.getSubquery(), text);
            result.setAlias(alias);
            return result;
        }
        if (projection instanceof BinaryOperationExpression) {
            int startIndex = projection.getStartIndex();
            int stopIndex = null == alias ? projection.getStopIndex() : alias.getStopIndex();
            ExpressionProjectionSegment result = new ExpressionProjectionSegment(startIndex, stopIndex, projection.getText(), projection);
            result.setAlias(alias);
            return result;
        }
        if (projection instanceof ParameterMarkerExpressionSegment) {
            ParameterMarkerExpressionSegment result = (ParameterMarkerExpressionSegment)projection;
            result.setAlias(alias);
            return projection;
        }
        if (projection instanceof CaseWhenExpression || projection instanceof VariableSegment || projection instanceof BetweenExpression || projection instanceof InExpression || projection instanceof CollateExpression || projection instanceof NotExpression || projection instanceof ExistsSubqueryExpression) {
            return this.createExpressionProjectionSegment(ctx, alias, projection);
        }
        ExpressionProjectionSegment result = null == alias ? new ExpressionProjectionSegment(projection.getStartIndex(), projection.getStopIndex(), String.valueOf(projection.getText()), projection) : new ExpressionProjectionSegment(projection.getStartIndex(), ctx.alias().stop.getStopIndex(), String.valueOf(projection.getText()), projection);
        result.setAlias(alias);
        return result;
    }

    private ExpressionProjectionSegment createExpressionProjectionSegment(MySQLStatementParser.ProjectionContext ctx, AliasSegment alias, ExpressionSegment projection) {
        ExpressionProjectionSegment result = new ExpressionProjectionSegment(ctx.start.getStartIndex(), ctx.stop.getStopIndex(), this.getOriginalText(ctx.expr()), projection);
        result.setAlias(alias);
        return result;
    }

    @Override
    public ASTNode visitFromClause(MySQLStatementParser.FromClauseContext ctx) {
        return (ASTNode)this.visit((ParseTree)ctx.tableReferences());
    }

    @Override
    public ASTNode visitTableReferences(MySQLStatementParser.TableReferencesContext ctx) {
        TableSegment result = (TableSegment)this.visit((ParseTree)ctx.tableReference(0));
        if (ctx.tableReference().size() > 1) {
            for (int i = 1; i < ctx.tableReference().size(); ++i) {
                result = this.generateJoinTableSourceFromEscapedTableReference(ctx.tableReference(i), result);
            }
        }
        return result;
    }

    private JoinTableSegment generateJoinTableSourceFromEscapedTableReference(MySQLStatementParser.TableReferenceContext ctx, TableSegment tableSegment) {
        JoinTableSegment result = new JoinTableSegment();
        result.setStartIndex(tableSegment.getStartIndex());
        result.setStopIndex(ctx.stop.getStopIndex());
        result.setLeft(tableSegment);
        result.setJoinType(JoinType.COMMA.name());
        result.setRight((TableSegment)this.visit((ParseTree)ctx));
        return result;
    }

    @Override
    public ASTNode visitEscapedTableReference(MySQLStatementParser.EscapedTableReferenceContext ctx) {
        TableSegment left = (TableSegment)this.visit((ParseTree)ctx.tableFactor());
        for (MySQLStatementParser.JoinedTableContext each : ctx.joinedTable()) {
            left = this.visitJoinedTable(each, left);
        }
        TableSegment result = left;
        return result;
    }

    @Override
    public ASTNode visitTableReference(MySQLStatementParser.TableReferenceContext ctx) {
        TableSegment left = null == ctx.tableFactor() ? (TableSegment)this.visit((ParseTree)ctx.escapedTableReference()) : (TableSegment)this.visit((ParseTree)ctx.tableFactor());
        for (MySQLStatementParser.JoinedTableContext each : ctx.joinedTable()) {
            left = this.visitJoinedTable(each, left);
        }
        TableSegment result = left;
        return result;
    }

    @Override
    public ASTNode visitTableFactor(MySQLStatementParser.TableFactorContext ctx) {
        if (null != ctx.subquery()) {
            SelectStatement subquery = (SelectStatement)this.visit((ParseTree)ctx.subquery());
            SubquerySegment subquerySegment = new SubquerySegment(ctx.subquery().start.getStartIndex(), ctx.subquery().stop.getStopIndex(), subquery, this.getOriginalText(ctx.subquery()));
            SubqueryTableSegment result = new SubqueryTableSegment(ctx.start.getStartIndex(), ctx.stop.getStopIndex(), subquerySegment);
            if (null != ctx.alias()) {
                result.setAlias((AliasSegment)this.visit((ParseTree)ctx.alias()));
            }
            return result;
        }
        if (null != ctx.tableName()) {
            SimpleTableSegment result = (SimpleTableSegment)this.visit((ParseTree)ctx.tableName());
            if (null != ctx.alias()) {
                result.setAlias((AliasSegment)this.visit((ParseTree)ctx.alias()));
            }
            if (null != ctx.indexHintList()) {
                ctx.indexHintList().indexHint().forEach(each -> result.getIndexHintSegments().add((IndexHintSegment)this.visit((ParseTree)each)));
            }
            return result;
        }
        if (null != ctx.expr()) {
            ExpressionSegment exprSegment = (ExpressionSegment)this.visit((ParseTree)ctx.expr());
            FunctionTableSegment result = new FunctionTableSegment(exprSegment.getStartIndex(), exprSegment.getStopIndex(), exprSegment);
            if (null != ctx.alias()) {
                result.setAlias((AliasSegment)this.visit((ParseTree)ctx.alias()));
            }
            return result;
        }
        return (ASTNode)this.visit((ParseTree)ctx.tableReferences());
    }

    private JoinTableSegment visitJoinedTable(MySQLStatementParser.JoinedTableContext ctx, TableSegment tableSegment) {
        JoinTableSegment result = new JoinTableSegment();
        result.setLeft(tableSegment);
        result.setStartIndex(tableSegment.getStartIndex());
        result.setStopIndex(ctx.stop.getStopIndex());
        result.setJoinType(this.getJoinType(ctx));
        result.setNatural(null != ctx.naturalJoinType());
        TableSegment right = null == ctx.tableFactor() ? (TableSegment)this.visit((ParseTree)ctx.tableReference()) : (TableSegment)this.visit((ParseTree)ctx.tableFactor());
        result.setRight(right);
        return null == ctx.joinSpecification() ? result : this.visitJoinSpecification(ctx.joinSpecification(), result);
    }

    private String getJoinType(MySQLStatementParser.JoinedTableContext ctx) {
        if (null != ctx.innerJoinType()) {
            return JoinType.INNER.name();
        }
        if (null != ctx.outerJoinType()) {
            return null == ctx.outerJoinType().LEFT() ? JoinType.RIGHT.name() : JoinType.LEFT.name();
        }
        if (null != ctx.naturalJoinType()) {
            return this.getNaturalJoinType(ctx.naturalJoinType());
        }
        return JoinType.COMMA.name();
    }

    private String getNaturalJoinType(MySQLStatementParser.NaturalJoinTypeContext ctx) {
        if (null != ctx.LEFT()) {
            return JoinType.LEFT.name();
        }
        if (null != ctx.RIGHT()) {
            return JoinType.RIGHT.name();
        }
        return JoinType.INNER.name();
    }

    private JoinTableSegment visitJoinSpecification(MySQLStatementParser.JoinSpecificationContext ctx, JoinTableSegment result) {
        if (null != ctx.expr()) {
            ExpressionSegment condition = (ExpressionSegment)this.visit((ParseTree)ctx.expr());
            result.setCondition(condition);
        }
        if (null != ctx.USING()) {
            result.setUsing(ctx.columnNames().columnName().stream().map(each -> (ColumnSegment)this.visit((ParseTree)each)).collect(Collectors.toList()));
        }
        return result;
    }

    @Override
    public ASTNode visitWhereClause(MySQLStatementParser.WhereClauseContext ctx) {
        ASTNode segment = (ASTNode)this.visit((ParseTree)ctx.expr());
        return new WhereSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), (ExpressionSegment)segment);
    }

    @Override
    public ASTNode visitGroupByClause(MySQLStatementParser.GroupByClauseContext ctx) {
        LinkedList<OrderByItemSegment> items = new LinkedList<OrderByItemSegment>();
        for (MySQLStatementParser.OrderByItemContext each : ctx.orderByItem()) {
            items.add((OrderByItemSegment)this.visit((ParseTree)each));
        }
        return new GroupBySegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), items);
    }

    @Override
    public ASTNode visitLimitClause(MySQLStatementParser.LimitClauseContext ctx) {
        PaginationValueSegment offset;
        PaginationValueSegment rowCount;
        if (null == ctx.limitOffset()) {
            return new LimitSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), null, (PaginationValueSegment)this.visit((ParseTree)ctx.limitRowCount()));
        }
        if (null != ctx.OFFSET()) {
            rowCount = (PaginationValueSegment)this.visit((ParseTree)ctx.limitRowCount());
            offset = (PaginationValueSegment)this.visit((ParseTree)ctx.limitOffset());
        } else {
            offset = (PaginationValueSegment)this.visit((ParseTree)ctx.limitOffset());
            rowCount = (PaginationValueSegment)this.visit((ParseTree)ctx.limitRowCount());
        }
        return new LimitSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), offset, rowCount);
    }

    @Override
    public ASTNode visitLimitRowCount(MySQLStatementParser.LimitRowCountContext ctx) {
        if (null != ctx.numberLiterals()) {
            return new NumberLiteralLimitValueSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), Long.valueOf(((NumberLiteralValue)this.visit((ParseTree)ctx.numberLiterals())).getValue().longValue()));
        }
        ParameterMarkerLimitValueSegment result = new ParameterMarkerLimitValueSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), ((ParameterMarkerValue)this.visit((ParseTree)ctx.parameterMarker())).getValue().intValue());
        this.parameterMarkerSegments.add((ParameterMarkerSegment)result);
        return result;
    }

    @Override
    public final ASTNode visitConstraintName(MySQLStatementParser.ConstraintNameContext ctx) {
        return new ConstraintSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), (IdentifierValue)this.visit((ParseTree)ctx.identifier()));
    }

    @Override
    public ASTNode visitLimitOffset(MySQLStatementParser.LimitOffsetContext ctx) {
        if (null != ctx.numberLiterals()) {
            return new NumberLiteralLimitValueSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), Long.valueOf(((NumberLiteralValue)this.visit((ParseTree)ctx.numberLiterals())).getValue().longValue()));
        }
        ParameterMarkerLimitValueSegment result = new ParameterMarkerLimitValueSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), ((ParameterMarkerValue)this.visit((ParseTree)ctx.parameterMarker())).getValue().intValue());
        this.parameterMarkerSegments.add((ParameterMarkerSegment)result);
        return result;
    }

    @Override
    public ASTNode visitCollateClause(MySQLStatementParser.CollateClauseContext ctx) {
        if (null != ctx.collationName()) {
            return new LiteralExpressionSegment(ctx.start.getStartIndex(), ctx.stop.getStopIndex(), (Object)ctx.collationName().textOrIdentifier().getText());
        }
        ParameterMarkerExpressionSegment segment = new ParameterMarkerExpressionSegment(ctx.start.getStartIndex(), ctx.stop.getStopIndex(), ((ParameterMarkerValue)this.visit((ParseTree)ctx.parameterMarker())).getValue().intValue());
        this.parameterMarkerSegments.add((ParameterMarkerSegment)segment);
        return segment;
    }

    @Override
    public ASTNode visitEngineRef(MySQLStatementParser.EngineRefContext ctx) {
        return new EngineSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), SQLUtils.getExactlyValue((String)ctx.textOrIdentifier().getText()));
    }

    private static String getFunctionName(MySQLStatementParser.SubstringFunctionContext ctx) {
        if (null == ctx.SUBSTR()) {
            return null == ctx.SUBSTRING() ? ctx.MID().getText() : ctx.SUBSTRING().getText();
        }
        return ctx.SUBSTR().getText();
    }

    protected String getOriginalText(ParserRuleContext ctx) {
        return null == ctx ? "" : ctx.start.getInputStream().getText(new Interval(ctx.start.getStartIndex(), ctx.stop.getStopIndex()));
    }

    @Generated
    public MySQLStatementVisitor(DatabaseType databaseType) {
        this.databaseType = databaseType;
    }

    @Generated
    protected DatabaseType getDatabaseType() {
        return this.databaseType;
    }

    @Generated
    protected Collection<ParameterMarkerSegment> getParameterMarkerSegments() {
        return this.parameterMarkerSegments;
    }
}

