/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.transaction.xa.spi;

import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import lombok.Generated;

public final class SingleXAResource
implements XAResource {
    private final String resourceName;
    private final String uniqueName;
    private final XAResource delegate;

    public SingleXAResource(String resourceName, XAResource delegate) {
        this.resourceName = resourceName;
        this.uniqueName = "";
        this.delegate = delegate;
    }

    @Override
    public void commit(Xid xid, boolean onePhase) throws XAException {
        try {
            this.delegate.commit(xid, onePhase);
        }
        catch (XAException ex) {
            throw this.mapXAException(ex);
        }
    }

    @Override
    public void end(Xid xid, int flags) throws XAException {
        try {
            this.delegate.end(xid, flags);
        }
        catch (XAException ex) {
            throw this.mapXAException(ex);
        }
    }

    @Override
    public void forget(Xid xid) throws XAException {
        try {
            this.delegate.forget(xid);
        }
        catch (XAException ex) {
            throw this.mapXAException(ex);
        }
    }

    @Override
    public int getTransactionTimeout() throws XAException {
        return this.delegate.getTransactionTimeout();
    }

    @Override
    public boolean isSameRM(XAResource xaResource) {
        SingleXAResource singleXAResource = (SingleXAResource)xaResource;
        return this.resourceName.equals(singleXAResource.resourceName) && this.uniqueName.equals(singleXAResource.uniqueName);
    }

    @Override
    public int prepare(Xid xid) throws XAException {
        try {
            return this.delegate.prepare(xid);
        }
        catch (XAException ex) {
            throw this.mapXAException(ex);
        }
    }

    @Override
    public Xid[] recover(int flags) throws XAException {
        try {
            return this.delegate.recover(flags);
        }
        catch (XAException ex) {
            throw this.mapXAException(ex);
        }
    }

    @Override
    public void rollback(Xid xid) throws XAException {
        try {
            this.delegate.rollback(xid);
        }
        catch (XAException ex) {
            throw this.mapXAException(ex);
        }
    }

    @Override
    public boolean setTransactionTimeout(int timeout) throws XAException {
        return this.delegate.setTransactionTimeout(timeout);
    }

    @Override
    public void start(Xid xid, int flags) throws XAException {
        try {
            this.delegate.start(xid, flags);
        }
        catch (XAException ex) {
            throw this.mapXAException(ex);
        }
    }

    private XAException mapXAException(XAException exception) {
        return exception;
    }

    @Generated
    public SingleXAResource(String resourceName, String uniqueName, XAResource delegate) {
        this.resourceName = resourceName;
        this.uniqueName = uniqueName;
        this.delegate = delegate;
    }

    @Generated
    public String getResourceName() {
        return this.resourceName;
    }

    @Generated
    public String getUniqueName() {
        return this.uniqueName;
    }

    @Generated
    public XAResource getDelegate() {
        return this.delegate;
    }
}

