/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.route.engine.tableless.type.unicast;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.ThreadLocalRandom;
import lombok.Generated;
import org.apache.shardingsphere.infra.metadata.database.rule.RuleMetaData;
import org.apache.shardingsphere.infra.route.context.RouteContext;
import org.apache.shardingsphere.infra.route.context.RouteMapper;
import org.apache.shardingsphere.infra.route.context.RouteUnit;
import org.apache.shardingsphere.infra.route.engine.tableless.TablelessRouteEngine;

public final class TablelessDataSourceUnicastRouteEngine
implements TablelessRouteEngine {
    @Override
    public RouteContext route(RuleMetaData globalRuleMetaData, Collection<String> aggregatedDataSources) {
        RouteContext result = new RouteContext();
        result.getRouteUnits().add(new RouteUnit(this.getDataSourceRouteMapper(aggregatedDataSources), Collections.emptyList()));
        return result;
    }

    private RouteMapper getDataSourceRouteMapper(Collection<String> dataSourceNames) {
        String dataSourceName = this.getRandomDataSourceName(dataSourceNames);
        return new RouteMapper(dataSourceName, dataSourceName);
    }

    private String getRandomDataSourceName(Collection<String> dataSourceNames) {
        return new ArrayList<String>(dataSourceNames).get(ThreadLocalRandom.current().nextInt(dataSourceNames.size()));
    }

    @Generated
    public TablelessDataSourceUnicastRouteEngine() {
    }
}

