/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.route.engine.tableless.router;

import java.util.Collection;
import java.util.Collections;
import org.apache.shardingsphere.infra.exception.ShardingSpherePreconditions;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.infra.metadata.database.rule.RuleMetaData;
import org.apache.shardingsphere.infra.route.context.RouteContext;
import org.apache.shardingsphere.infra.route.context.RouteMapper;
import org.apache.shardingsphere.infra.route.context.RouteUnit;
import org.apache.shardingsphere.infra.route.engine.tableless.TablelessRouteEngineFactory;
import org.apache.shardingsphere.infra.rule.attribute.datasource.aggregate.AggregatedDataSourceRuleAttribute;
import org.apache.shardingsphere.infra.session.query.QueryContext;

public final class TablelessSQLRouter {
    public RouteContext route(QueryContext queryContext, RuleMetaData globalRuleMetaData, ShardingSphereDatabase database, Collection<String> tableNames, RouteContext routeContext) {
        if (tableNames.isEmpty() && routeContext.getRouteUnits().isEmpty()) {
            Collection<String> aggregatedDataSources = this.getAggregatedDataSources(database);
            if (1 == aggregatedDataSources.size()) {
                return this.createSingleRouteContext(aggregatedDataSources.iterator().next());
            }
            return TablelessRouteEngineFactory.newInstance(queryContext, database).route(globalRuleMetaData, aggregatedDataSources);
        }
        return routeContext;
    }

    private RouteContext createSingleRouteContext(String aggregatedDataSource) {
        RouteContext result = new RouteContext();
        result.getRouteUnits().add(new RouteUnit(new RouteMapper(aggregatedDataSource, aggregatedDataSource), Collections.emptyList()));
        return result;
    }

    private Collection<String> getAggregatedDataSources(ShardingSphereDatabase database) {
        Collection attributes = database.getRuleMetaData().getAttributes(AggregatedDataSourceRuleAttribute.class);
        ShardingSpherePreconditions.checkNotEmpty((Collection)attributes, () -> new UnsupportedOperationException("Can not find aggregated data source"));
        return ((AggregatedDataSourceRuleAttribute)attributes.iterator().next()).getAggregatedDataSources().keySet();
    }
}

