/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sql.parser.engine.core.database.visitor;

import lombok.Generated;
import org.apache.shardingsphere.database.connector.core.spi.DatabaseTypedSPILoader;
import org.apache.shardingsphere.database.connector.core.type.DatabaseType;
import org.apache.shardingsphere.sql.parser.api.visitor.statement.SQLStatementVisitor;
import org.apache.shardingsphere.sql.parser.engine.core.database.visitor.SQLVisitorRule;
import org.apache.shardingsphere.sql.parser.engine.exception.SQLParsingException;
import org.apache.shardingsphere.sql.parser.spi.SQLStatementVisitorFacade;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.SQLStatementType;

public final class SQLStatementVisitorFactory {
    public static SQLStatementVisitor newInstance(DatabaseType databaseType, SQLVisitorRule visitorRule) {
        SQLStatementVisitorFacade facade = (SQLStatementVisitorFacade)DatabaseTypedSPILoader.getService(SQLStatementVisitorFacade.class, (DatabaseType)databaseType);
        return SQLStatementVisitorFactory.createParseTreeVisitor(databaseType, facade, visitorRule.getType());
    }

    private static SQLStatementVisitor createParseTreeVisitor(DatabaseType databaseType, SQLStatementVisitorFacade visitorFacade, SQLStatementType type) {
        switch (type) {
            case DML: {
                return (SQLStatementVisitor)visitorFacade.getDMLVisitorClass().getConstructor(DatabaseType.class).newInstance(databaseType);
            }
            case DDL: {
                return (SQLStatementVisitor)visitorFacade.getDDLVisitorClass().getConstructor(DatabaseType.class).newInstance(databaseType);
            }
            case TCL: {
                return (SQLStatementVisitor)visitorFacade.getTCLVisitorClass().getConstructor(DatabaseType.class).newInstance(databaseType);
            }
            case LCL: {
                return (SQLStatementVisitor)visitorFacade.getLCLVisitorClass().getConstructor(DatabaseType.class).newInstance(databaseType);
            }
            case DCL: {
                return (SQLStatementVisitor)visitorFacade.getDCLVisitorClass().getConstructor(DatabaseType.class).newInstance(databaseType);
            }
            case DAL: {
                return (SQLStatementVisitor)visitorFacade.getDALVisitorClass().getConstructor(DatabaseType.class).newInstance(databaseType);
            }
        }
        throw new SQLParsingException(type.name());
    }

    @Generated
    private SQLStatementVisitorFactory() {
    }
}

