/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sql.parser.engine.core.database.parser;

import lombok.Generated;
import org.antlr.v4.runtime.ANTLRErrorListener;
import org.antlr.v4.runtime.Parser;
import org.antlr.v4.runtime.atn.ParserATNSimulator;
import org.antlr.v4.runtime.atn.PredictionMode;
import org.antlr.v4.runtime.misc.ParseCancellationException;
import org.antlr.v4.runtime.tree.ErrorNode;
import org.apache.shardingsphere.database.connector.core.spi.DatabaseTypedSPILoader;
import org.apache.shardingsphere.database.connector.core.type.DatabaseType;
import org.apache.shardingsphere.sql.parser.api.parser.SQLParser;
import org.apache.shardingsphere.sql.parser.engine.core.ParseASTNode;
import org.apache.shardingsphere.sql.parser.engine.core.SQLParserFactory;
import org.apache.shardingsphere.sql.parser.engine.core.database.parser.SQLParserErrorListener;
import org.apache.shardingsphere.sql.parser.engine.exception.SQLParsingException;
import org.apache.shardingsphere.sql.parser.spi.DialectSQLParserFacade;

public final class SQLParserExecutor {
    private final DatabaseType databaseType;

    public ParseASTNode parse(String sql) {
        ParseASTNode result = this.twoPhaseParse(sql);
        if (result.getRootNode() instanceof ErrorNode) {
            throw new SQLParsingException(sql);
        }
        return result;
    }

    private ParseASTNode twoPhaseParse(String sql) {
        DialectSQLParserFacade sqlParserFacade = (DialectSQLParserFacade)DatabaseTypedSPILoader.getService(DialectSQLParserFacade.class, (DatabaseType)this.databaseType);
        SQLParser sqlParser = SQLParserFactory.newInstance(sql, sqlParserFacade.getLexerClass(), sqlParserFacade.getParserClass());
        try {
            ((ParserATNSimulator)((Parser)sqlParser).getInterpreter()).setPredictionMode(PredictionMode.SLL);
            return (ParseASTNode)sqlParser.parse();
        }
        catch (ParseCancellationException ex) {
            ((Parser)sqlParser).reset();
            ((ParserATNSimulator)((Parser)sqlParser).getInterpreter()).setPredictionMode(PredictionMode.LL);
            ((Parser)sqlParser).removeErrorListeners();
            ((Parser)sqlParser).addErrorListener((ANTLRErrorListener)SQLParserErrorListener.getInstance());
            try {
                return (ParseASTNode)sqlParser.parse();
            }
            catch (ParseCancellationException exception) {
                throw new SQLParsingException(sql + ", " + exception.getMessage());
            }
        }
    }

    @Generated
    public SQLParserExecutor(DatabaseType databaseType) {
        this.databaseType = databaseType;
    }
}

