/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sql.parser.engine.api;

import lombok.Generated;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.tree.ParseTreeVisitor;
import org.apache.shardingsphere.database.connector.core.type.DatabaseType;
import org.apache.shardingsphere.infra.spi.type.typed.TypedSPILoader;
import org.apache.shardingsphere.sql.parser.api.ASTNode;
import org.apache.shardingsphere.sql.parser.api.visitor.statement.SQLStatementVisitor;
import org.apache.shardingsphere.sql.parser.engine.core.ParseASTNode;
import org.apache.shardingsphere.sql.parser.engine.core.database.visitor.SQLStatementVisitorFactory;
import org.apache.shardingsphere.sql.parser.engine.core.database.visitor.SQLVisitorRule;
import org.apache.shardingsphere.sql.parser.statement.core.segment.generic.CommentSegment;
import org.apache.shardingsphere.sql.parser.statement.core.statement.SQLStatement;

public final class SQLStatementVisitorEngine {
    private final DatabaseType databaseType;

    public SQLStatementVisitorEngine(String databaseType) {
        this((DatabaseType)TypedSPILoader.getService(DatabaseType.class, (Object)databaseType));
    }

    public SQLStatement visit(ParseASTNode parseASTNode) {
        SQLStatementVisitor visitor = SQLStatementVisitorFactory.newInstance(this.databaseType, SQLVisitorRule.valueOf(parseASTNode.getRootNode().getClass()));
        ASTNode result = (ASTNode)parseASTNode.getRootNode().accept((ParseTreeVisitor)visitor);
        this.appendSQLComments(parseASTNode, result);
        return (SQLStatement)result;
    }

    private <T> void appendSQLComments(ParseASTNode parseASTNode, T visitResult) {
        if (visitResult instanceof SQLStatement) {
            for (Token each : parseASTNode.getHiddenTokens()) {
                ((SQLStatement)visitResult).getComments().add(new CommentSegment(each.getText(), each.getStartIndex(), each.getStopIndex()));
            }
        }
    }

    @Generated
    public SQLStatementVisitorEngine(DatabaseType databaseType) {
        this.databaseType = databaseType;
    }
}

