/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sql.parser.engine.hive.visitor.statement.type;

import java.util.Collections;
import java.util.LinkedList;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.misc.Interval;
import org.antlr.v4.runtime.tree.ParseTree;
import org.apache.shardingsphere.database.connector.core.type.DatabaseType;
import org.apache.shardingsphere.sql.parser.api.ASTNode;
import org.apache.shardingsphere.sql.parser.api.visitor.statement.type.DDLStatementVisitor;
import org.apache.shardingsphere.sql.parser.autogen.HiveStatementParser;
import org.apache.shardingsphere.sql.parser.engine.hive.visitor.statement.HiveStatementVisitor;
import org.apache.shardingsphere.sql.parser.engine.hive.visitor.statement.type.HiveDMLStatementVisitor;
import org.apache.shardingsphere.sql.parser.statement.core.segment.ddl.CreateDefinitionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.ddl.column.ColumnDefinitionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.ddl.column.alter.AddColumnDefinitionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.ddl.column.alter.ChangeColumnDefinitionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.ddl.column.alter.ReplaceColumnDefinitionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.ddl.column.position.ColumnAfterPositionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.ddl.column.position.ColumnFirstPositionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.ddl.column.position.ColumnPositionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.ddl.constraint.ConstraintDefinitionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.ddl.index.IndexNameSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.ddl.index.IndexSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.column.ColumnSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.generic.DataTypeSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.generic.OwnerSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.generic.table.SimpleTableSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.generic.table.TableNameSegment;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.ddl.TruncateStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.ddl.database.AlterDatabaseStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.ddl.database.CreateDatabaseStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.ddl.database.DropDatabaseStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.ddl.function.CreateFunctionStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.ddl.function.DropFunctionStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.ddl.function.ReloadFunctionStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.ddl.index.AlterIndexStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.ddl.index.CreateIndexStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.ddl.index.DropIndexStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.ddl.macro.CreateMacroStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.ddl.macro.DropMacroStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.ddl.table.AlterTableStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.ddl.table.CreateTableStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.ddl.table.DropTableStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.ddl.view.AlterMaterializedViewStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.ddl.view.AlterViewStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.ddl.view.CreateMaterializedViewStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.ddl.view.CreateViewStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.ddl.view.DropMaterializedViewStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.ddl.view.DropViewStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.dml.SelectStatement;
import org.apache.shardingsphere.sql.parser.statement.core.value.collection.CollectionValue;
import org.apache.shardingsphere.sql.parser.statement.core.value.identifier.IdentifierValue;

public final class HiveDDLStatementVisitor
extends HiveStatementVisitor
implements DDLStatementVisitor {
    public HiveDDLStatementVisitor(DatabaseType databaseType) {
        super(databaseType);
    }

    @Override
    public ASTNode visitCreateDatabase(HiveStatementParser.CreateDatabaseContext ctx) {
        return new CreateDatabaseStatement(this.getDatabaseType(), new IdentifierValue(ctx.identifier().getText()).getValue(), null != ctx.ifNotExists());
    }

    @Override
    public ASTNode visitDropDatabase(HiveStatementParser.DropDatabaseContext ctx) {
        return new DropDatabaseStatement(this.getDatabaseType(), new IdentifierValue(ctx.identifier().getText()).getValue(), null != ctx.ifExists());
    }

    @Override
    public ASTNode visitAlterDatabase(HiveStatementParser.AlterDatabaseContext ctx) {
        return new AlterDatabaseStatement(this.getDatabaseType());
    }

    @Override
    public ASTNode visitAlterTable(HiveStatementParser.AlterTableContext ctx) {
        AlterTableStatement result = new AlterTableStatement(this.getDatabaseType());
        result.setTable((SimpleTableSegment)this.visit((ParseTree)ctx.alterTableCommonClause().tableName()));
        if (null != ctx.changeColumn()) {
            ChangeColumnDefinitionSegment changeColumnSegment = (ChangeColumnDefinitionSegment)this.visit((ParseTree)ctx.changeColumn());
            result.getChangeColumnDefinitions().add(changeColumnSegment);
        }
        if (null != ctx.addColumns()) {
            AddColumnDefinitionSegment addSeg = (AddColumnDefinitionSegment)this.visit((ParseTree)ctx.addColumns());
            result.getAddColumnDefinitions().add(addSeg);
        }
        if (null != ctx.replaceColumns()) {
            ReplaceColumnDefinitionSegment repSeg = (ReplaceColumnDefinitionSegment)this.visit((ParseTree)ctx.replaceColumns());
            result.getReplaceColumnDefinitions().add(repSeg);
        }
        if (null != ctx.COMPACT()) {
            String compactionType = ctx.string_().getText().replace("'", "");
            if (!this.isValidCompactionType(compactionType)) {
                throw new IllegalArgumentException("Invalid compaction type. Must be 'MAJOR', 'MINOR' or 'REBALANCE'");
            }
            if (!(null == ctx.clusteredIntoClause() && null == ctx.orderByClause() || "REBALANCE".equalsIgnoreCase(compactionType))) {
                throw new IllegalArgumentException("[CLUSTERED INTO n BUCKETS] and [ORDER BY col_list] clauses can only be used with REBALANCE compaction");
            }
        }
        return result;
    }

    private boolean isValidCompactionType(String compactionType) {
        return "MAJOR".equalsIgnoreCase(compactionType) || "MINOR".equalsIgnoreCase(compactionType) || "REBALANCE".equalsIgnoreCase(compactionType);
    }

    @Override
    public ASTNode visitMsckStatement(HiveStatementParser.MsckStatementContext ctx) {
        AlterTableStatement result = new AlterTableStatement(this.getDatabaseType());
        result.setTable((SimpleTableSegment)this.visit((ParseTree)ctx.tableName()));
        return result;
    }

    @Override
    public ASTNode visitDropTable(HiveStatementParser.DropTableContext ctx) {
        DropTableStatement result = new DropTableStatement(this.getDatabaseType());
        result.setIfExists(null != ctx.ifExists());
        result.getTables().add((SimpleTableSegment)this.visit((ParseTree)ctx.tableNameWithDb()));
        return result;
    }

    @Override
    public ASTNode visitTruncateTable(HiveStatementParser.TruncateTableContext ctx) {
        return new TruncateStatement(this.getDatabaseType(), Collections.singleton((SimpleTableSegment)this.visit((ParseTree)ctx.tableNameWithDb())));
    }

    @Override
    public ASTNode visitCreateTable(HiveStatementParser.CreateTableContext ctx) {
        CreateTableStatement result = new CreateTableStatement(this.getDatabaseType());
        result.setTable((SimpleTableSegment)this.visit((ParseTree)ctx.createTableCommonClause().tableNameWithDb()));
        result.setIfNotExists(null != ctx.createTableCommonClause().ifNotExists());
        if (null != ctx.createDefinitionClause()) {
            CollectionValue createDefinitions = (CollectionValue)this.visit((ParseTree)ctx.createDefinitionClause());
            for (CreateDefinitionSegment each : createDefinitions.getValue()) {
                if (each instanceof ColumnDefinitionSegment) {
                    result.getColumnDefinitions().add((ColumnDefinitionSegment)each);
                    continue;
                }
                if (!(each instanceof ConstraintDefinitionSegment)) continue;
                result.getConstraintDefinitions().add((ConstraintDefinitionSegment)each);
            }
        }
        return result;
    }

    @Override
    public ASTNode visitCreateDefinitionClause(HiveStatementParser.CreateDefinitionClauseContext ctx) {
        CollectionValue result = new CollectionValue();
        for (HiveStatementParser.ColumnDefinitionContext columnDefinitionContext : ctx.columnDefinition()) {
            result.getValue().add((ColumnDefinitionSegment)this.visit((ParseTree)columnDefinitionContext));
        }
        for (HiveStatementParser.TableConstraintContext tableConstraintContext : ctx.tableConstraint()) {
            result.getValue().add((ConstraintDefinitionSegment)this.visit((ParseTree)tableConstraintContext));
        }
        return result;
    }

    @Override
    public ASTNode visitColumnDefinition(HiveStatementParser.ColumnDefinitionContext ctx) {
        ColumnSegment column = new ColumnSegment(ctx.columnName().getStart().getStartIndex(), ctx.columnName().getStop().getStopIndex(), new IdentifierValue(ctx.columnName().getText()));
        DataTypeSegment dataType = (DataTypeSegment)this.visit((ParseTree)ctx.dataTypeClause());
        return new ColumnDefinitionSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), column, dataType, false, false, this.getText(ctx));
    }

    @Override
    public ASTNode visitChangeColumn(HiveStatementParser.ChangeColumnContext ctx) {
        ColumnSegment oldColumn = new ColumnSegment(ctx.columnName(0).getStart().getStartIndex(), ctx.columnName(0).getStop().getStopIndex(), new IdentifierValue(ctx.columnName(0).getText()));
        ColumnSegment newColumn = new ColumnSegment(ctx.columnName(1).getStart().getStartIndex(), ctx.columnName(1).getStop().getStopIndex(), new IdentifierValue(ctx.columnName(1).getText()));
        DataTypeSegment dataType = (DataTypeSegment)this.visit((ParseTree)ctx.dataTypeClause());
        ColumnDefinitionSegment columnDefinition = new ColumnDefinitionSegment(ctx.columnName(1).getStart().getStartIndex(), ctx.dataTypeClause().getStop().getStopIndex(), newColumn, dataType, false, false, this.getText(ctx));
        ChangeColumnDefinitionSegment result = new ChangeColumnDefinitionSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), columnDefinition);
        result.setPreviousColumn(oldColumn);
        if (null != ctx.FIRST()) {
            ColumnFirstPositionSegment firstPos = new ColumnFirstPositionSegment(ctx.FIRST().getSymbol().getStartIndex(), ctx.FIRST().getSymbol().getStopIndex(), null);
            result.setColumnPosition((ColumnPositionSegment)firstPos);
        } else if (null != ctx.AFTER()) {
            HiveStatementParser.ColumnNameContext afterCtx = ctx.columnName(ctx.columnName().size() - 1);
            ColumnSegment afterColumn = new ColumnSegment(afterCtx.getStart().getStartIndex(), afterCtx.getStop().getStopIndex(), new IdentifierValue(afterCtx.getText()));
            ColumnAfterPositionSegment afterPos = new ColumnAfterPositionSegment(afterCtx.getStart().getStartIndex(), afterCtx.getStop().getStopIndex(), afterColumn);
            result.setColumnPosition((ColumnPositionSegment)afterPos);
        }
        return result;
    }

    @Override
    public ASTNode visitAddColumns(HiveStatementParser.AddColumnsContext ctx) {
        LinkedList<ColumnDefinitionSegment> cols = new LinkedList<ColumnDefinitionSegment>();
        for (HiveStatementParser.ColumnDefinitionContext each : ctx.columnDefinition()) {
            cols.add((ColumnDefinitionSegment)this.visit((ParseTree)each));
        }
        return new AddColumnDefinitionSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), cols);
    }

    @Override
    public ASTNode visitReplaceColumns(HiveStatementParser.ReplaceColumnsContext ctx) {
        LinkedList<ColumnDefinitionSegment> cols = new LinkedList<ColumnDefinitionSegment>();
        for (HiveStatementParser.ColumnDefinitionContext each : ctx.columnDefinition()) {
            cols.add((ColumnDefinitionSegment)this.visit((ParseTree)each));
        }
        return new ReplaceColumnDefinitionSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), cols);
    }

    private String getText(ParserRuleContext ctx) {
        return ctx.start.getInputStream().getText(new Interval(ctx.start.getStartIndex(), ctx.stop.getStopIndex()));
    }

    @Override
    public ASTNode visitDataTypeClause(HiveStatementParser.DataTypeClauseContext ctx) {
        DataTypeSegment result = new DataTypeSegment();
        result.setStartIndex(ctx.getStart().getStartIndex());
        result.setStopIndex(ctx.getStop().getStopIndex());
        if (null != ctx.primitiveType()) {
            result.setDataTypeName(ctx.primitiveType().getText());
        } else if (null != ctx.arrayType()) {
            result.setDataTypeName(ctx.arrayType().getText());
        } else if (null != ctx.mapType()) {
            result.setDataTypeName(ctx.mapType().getText());
        } else if (null != ctx.structType()) {
            result.setDataTypeName(ctx.structType().getText());
        } else if (null != ctx.unionType()) {
            result.setDataTypeName(ctx.unionType().getText());
        }
        return result;
    }

    @Override
    public ASTNode visitTableNameWithDb(HiveStatementParser.TableNameWithDbContext ctx) {
        if (1 == ctx.identifier().size()) {
            return new SimpleTableSegment(new TableNameSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), new IdentifierValue(ctx.identifier(0).getText())));
        }
        SimpleTableSegment result = new SimpleTableSegment(new TableNameSegment(ctx.identifier(1).getStart().getStartIndex(), ctx.identifier(1).getStop().getStopIndex(), new IdentifierValue(ctx.identifier(1).getText())));
        result.setOwner(new OwnerSegment(ctx.identifier(0).getStart().getStartIndex(), ctx.identifier(0).getStop().getStopIndex(), new IdentifierValue(ctx.identifier(0).getText())));
        return result;
    }

    @Override
    public ASTNode visitTableConstraint(HiveStatementParser.TableConstraintContext ctx) {
        return new ConstraintDefinitionSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex());
    }

    @Override
    public ASTNode visitCreateView(HiveStatementParser.CreateViewContext ctx) {
        HiveDMLStatementVisitor dmlVisitor;
        ASTNode selectNode;
        CreateViewStatement result = new CreateViewStatement(this.getDatabaseType());
        result.setView((SimpleTableSegment)this.visit((ParseTree)ctx.viewNameWithDb()));
        if (null != ctx.commentClause() && !ctx.commentClause().isEmpty()) {
            result.setViewDefinition(ctx.commentClause(ctx.commentClause().size() - 1).string_().getText().replace("'", ""));
        }
        if (null != ctx.tblProperties()) {
            result.setViewDefinition(this.getText(ctx.tblProperties()));
        }
        if ((selectNode = (ASTNode)(dmlVisitor = new HiveDMLStatementVisitor(this.getDatabaseType())).visit((ParseTree)ctx.select())) instanceof SelectStatement) {
            result.setSelect((SelectStatement)selectNode);
        }
        result.setViewDefinition(this.getText(ctx));
        return result;
    }

    @Override
    public ASTNode visitViewNameWithDb(HiveStatementParser.ViewNameWithDbContext ctx) {
        if (1 == ctx.identifier().size()) {
            return new SimpleTableSegment(new TableNameSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), new IdentifierValue(ctx.identifier(0).getText())));
        }
        SimpleTableSegment result = new SimpleTableSegment(new TableNameSegment(ctx.identifier(1).getStart().getStartIndex(), ctx.identifier(1).getStop().getStopIndex(), new IdentifierValue(ctx.identifier(1).getText())));
        result.setOwner(new OwnerSegment(ctx.identifier(0).getStart().getStartIndex(), ctx.identifier(0).getStop().getStopIndex(), new IdentifierValue(ctx.identifier(0).getText())));
        return result;
    }

    @Override
    public ASTNode visitDropView(HiveStatementParser.DropViewContext ctx) {
        DropViewStatement result = new DropViewStatement(this.getDatabaseType());
        result.setIfExists(null != ctx.ifExists());
        result.getViews().add((SimpleTableSegment)this.visit((ParseTree)ctx.viewNameWithDb()));
        return result;
    }

    @Override
    public ASTNode visitAlterView(HiveStatementParser.AlterViewContext ctx) {
        AlterViewStatement result = new AlterViewStatement(this.getDatabaseType());
        result.setView((SimpleTableSegment)this.visit((ParseTree)ctx.alterViewCommonClause().viewNameWithDb()));
        if (null != ctx.select()) {
            HiveDMLStatementVisitor dmlVisitor = new HiveDMLStatementVisitor(this.getDatabaseType());
            ASTNode selectNode = (ASTNode)dmlVisitor.visit((ParseTree)ctx.select());
            if (selectNode instanceof SelectStatement) {
                result.setSelect((SelectStatement)selectNode);
            }
            result.setViewDefinition(this.getText(ctx.select()));
        }
        return result;
    }

    @Override
    public ASTNode visitCreateMaterializedView(HiveStatementParser.CreateMaterializedViewContext ctx) {
        return new CreateMaterializedViewStatement(this.getDatabaseType());
    }

    @Override
    public ASTNode visitDropMaterializedView(HiveStatementParser.DropMaterializedViewContext ctx) {
        return new DropMaterializedViewStatement(this.getDatabaseType());
    }

    @Override
    public ASTNode visitAlterMaterializedView(HiveStatementParser.AlterMaterializedViewContext ctx) {
        return new AlterMaterializedViewStatement(this.getDatabaseType());
    }

    @Override
    public ASTNode visitCreateIndex(HiveStatementParser.CreateIndexContext ctx) {
        CreateIndexStatement result = new CreateIndexStatement(this.getDatabaseType());
        result.setIndex(new IndexSegment(ctx.indexName().getStart().getStartIndex(), ctx.indexName().getStop().getStopIndex(), new IndexNameSegment(ctx.indexName().getStart().getStartIndex(), ctx.indexName().getStop().getStopIndex(), new IdentifierValue(ctx.indexName().getText()))));
        result.setTable((SimpleTableSegment)this.visit((ParseTree)ctx.tableNameWithDb()));
        if (null != ctx.columnNamesCommonClause()) {
            for (HiveStatementParser.ColumnNameContext each : ctx.columnNamesCommonClause().columnNames().columnName()) {
                result.getColumns().add(new ColumnSegment(each.getStart().getStartIndex(), each.getStop().getStopIndex(), new IdentifierValue(each.getText())));
            }
        }
        return result;
    }

    @Override
    public ASTNode visitDropIndex(HiveStatementParser.DropIndexContext ctx) {
        DropIndexStatement result = new DropIndexStatement(this.getDatabaseType());
        result.setIfExists(null != ctx.ifExists());
        IndexNameSegment indexName = new IndexNameSegment(ctx.indexName().getStart().getStartIndex(), ctx.indexName().getStop().getStopIndex(), new IdentifierValue(ctx.indexName().getText()));
        result.getIndexes().add(new IndexSegment(ctx.indexName().getStart().getStartIndex(), ctx.indexName().getStop().getStopIndex(), indexName));
        result.setSimpleTable((SimpleTableSegment)this.visit((ParseTree)ctx.tableNameWithDb()));
        return result;
    }

    @Override
    public ASTNode visitAlterIndex(HiveStatementParser.AlterIndexContext ctx) {
        AlterIndexStatement result = new AlterIndexStatement(this.getDatabaseType());
        IndexNameSegment indexName = new IndexNameSegment(ctx.indexName().getStart().getStartIndex(), ctx.indexName().getStop().getStopIndex(), new IdentifierValue(ctx.indexName().getText()));
        result.setIndex(new IndexSegment(ctx.indexName().getStart().getStartIndex(), ctx.indexName().getStop().getStopIndex(), indexName));
        result.setSimpleTable((SimpleTableSegment)this.visit((ParseTree)ctx.tableNameWithDb()));
        return result;
    }

    @Override
    public ASTNode visitCreateMacro(HiveStatementParser.CreateMacroContext ctx) {
        return new CreateMacroStatement(this.getDatabaseType());
    }

    @Override
    public ASTNode visitDropMacro(HiveStatementParser.DropMacroContext ctx) {
        return new DropMacroStatement(this.getDatabaseType());
    }

    @Override
    public ASTNode visitCreateFunction(HiveStatementParser.CreateFunctionContext ctx) {
        return new CreateFunctionStatement(this.getDatabaseType());
    }

    @Override
    public ASTNode visitDropFunction(HiveStatementParser.DropFunctionContext ctx) {
        return new DropFunctionStatement(this.getDatabaseType());
    }

    @Override
    public ASTNode visitReloadFunction(HiveStatementParser.ReloadFunctionContext ctx) {
        return new ReloadFunctionStatement(this.getDatabaseType());
    }
}

