/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sql.parser.engine.hive.visitor.statement.type;

import org.antlr.v4.runtime.tree.ParseTree;
import org.apache.shardingsphere.database.connector.core.type.DatabaseType;
import org.apache.shardingsphere.sql.parser.api.ASTNode;
import org.apache.shardingsphere.sql.parser.api.visitor.statement.type.DALStatementVisitor;
import org.apache.shardingsphere.sql.parser.autogen.HiveStatementParser;
import org.apache.shardingsphere.sql.parser.engine.hive.visitor.statement.HiveStatementVisitor;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dal.FromDatabaseSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dal.ShowFilterSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dal.ShowLikeSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.column.ColumnSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.generic.DatabaseSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.generic.table.SimpleTableSegment;
import org.apache.shardingsphere.sql.parser.statement.core.value.identifier.IdentifierValue;
import org.apache.shardingsphere.sql.parser.statement.core.value.literal.impl.StringLiteralValue;
import org.apache.shardingsphere.sql.parser.statement.hive.dal.HiveDescribeStatement;
import org.apache.shardingsphere.sql.parser.statement.hive.dal.show.HiveShowCompactionsStatement;
import org.apache.shardingsphere.sql.parser.statement.hive.dal.show.HiveShowConfStatement;
import org.apache.shardingsphere.sql.parser.statement.hive.dal.show.HiveShowConnectorsStatement;
import org.apache.shardingsphere.sql.parser.statement.hive.dal.show.HiveShowFunctionsStatement;
import org.apache.shardingsphere.sql.parser.statement.hive.dal.show.HiveShowLocksStatement;
import org.apache.shardingsphere.sql.parser.statement.hive.dal.show.HiveShowMaterializedViewsStatement;
import org.apache.shardingsphere.sql.parser.statement.hive.dal.show.HiveShowPartitionsStatement;
import org.apache.shardingsphere.sql.parser.statement.hive.dal.show.HiveShowTablesExtendedStatement;
import org.apache.shardingsphere.sql.parser.statement.hive.dal.show.HiveShowTblpropertiesStatement;
import org.apache.shardingsphere.sql.parser.statement.hive.dal.show.HiveShowTransactionsStatement;
import org.apache.shardingsphere.sql.parser.statement.hive.dal.show.HiveShowViewsStatement;
import org.apache.shardingsphere.sql.parser.statement.mysql.dal.MySQLUseStatement;
import org.apache.shardingsphere.sql.parser.statement.mysql.dal.show.column.MySQLDescribeStatement;
import org.apache.shardingsphere.sql.parser.statement.mysql.dal.show.column.MySQLShowColumnsStatement;
import org.apache.shardingsphere.sql.parser.statement.mysql.dal.show.database.MySQLShowDatabasesStatement;
import org.apache.shardingsphere.sql.parser.statement.mysql.dal.show.index.MySQLShowIndexStatement;
import org.apache.shardingsphere.sql.parser.statement.mysql.dal.show.privilege.MySQLShowGrantsStatement;
import org.apache.shardingsphere.sql.parser.statement.mysql.dal.show.table.MySQLShowCreateTableStatement;
import org.apache.shardingsphere.sql.parser.statement.mysql.dal.show.table.MySQLShowTablesStatement;

public final class HiveDALStatementVisitor
extends HiveStatementVisitor
implements DALStatementVisitor {
    public HiveDALStatementVisitor(DatabaseType databaseType) {
        super(databaseType);
    }

    @Override
    public ASTNode visitUse(HiveStatementParser.UseContext ctx) {
        String database = null == ctx.DEFAULT() ? new IdentifierValue(ctx.identifier().getText()).getValue() : "default";
        return new MySQLUseStatement(this.getDatabaseType(), database);
    }

    @Override
    public ASTNode visitShowDatabases(HiveStatementParser.ShowDatabasesContext ctx) {
        ShowFilterSegment filter = null;
        if (null != ctx.showLike()) {
            filter = new ShowFilterSegment(ctx.showLike().getStart().getStartIndex(), ctx.showLike().getStop().getStopIndex());
            filter.setLike((ShowLikeSegment)this.visit((ParseTree)ctx.showLike()));
        }
        MySQLShowDatabasesStatement result = new MySQLShowDatabasesStatement(this.getDatabaseType(), filter);
        result.addParameterMarkers(this.getParameterMarkerSegments());
        return result;
    }

    @Override
    public ASTNode visitShowLike(HiveStatementParser.ShowLikeContext ctx) {
        StringLiteralValue literalValue = (StringLiteralValue)this.visit((ParseTree)ctx.stringLiterals());
        return new ShowLikeSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), literalValue.getValue());
    }

    @Override
    public ASTNode visitShowConnectors(HiveStatementParser.ShowConnectorsContext ctx) {
        return new HiveShowConnectorsStatement(this.getDatabaseType());
    }

    @Override
    public ASTNode visitShowTables(HiveStatementParser.ShowTablesContext ctx) {
        FromDatabaseSegment fromDatabase = null;
        if (null != ctx.databaseName()) {
            DatabaseSegment databaseSegment = (DatabaseSegment)this.visit((ParseTree)ctx.databaseName());
            fromDatabase = new FromDatabaseSegment(ctx.databaseName().getStart().getStartIndex(), databaseSegment);
        }
        ShowFilterSegment filter = null;
        if (null != ctx.stringLiterals()) {
            StringLiteralValue literalValue = (StringLiteralValue)this.visit((ParseTree)ctx.stringLiterals());
            ShowLikeSegment likeSegment = new ShowLikeSegment(ctx.stringLiterals().getStart().getStartIndex(), ctx.stringLiterals().getStop().getStopIndex(), literalValue.getValue());
            filter = new ShowFilterSegment(ctx.stringLiterals().getStart().getStartIndex(), ctx.stringLiterals().getStop().getStopIndex());
            filter.setLike(likeSegment);
        }
        MySQLShowTablesStatement result = new MySQLShowTablesStatement(this.getDatabaseType(), fromDatabase, filter, false);
        result.addParameterMarkers(this.getParameterMarkerSegments());
        return result;
    }

    @Override
    public ASTNode visitShowViews(HiveStatementParser.ShowViewsContext ctx) {
        return new HiveShowViewsStatement(this.getDatabaseType());
    }

    @Override
    public ASTNode visitShowMaterializedViews(HiveStatementParser.ShowMaterializedViewsContext ctx) {
        return new HiveShowMaterializedViewsStatement(this.getDatabaseType());
    }

    @Override
    public ASTNode visitShowPartitions(HiveStatementParser.ShowPartitionsContext ctx) {
        return new HiveShowPartitionsStatement(this.getDatabaseType());
    }

    @Override
    public ASTNode visitShowTablesExtended(HiveStatementParser.ShowTablesExtendedContext ctx) {
        return new HiveShowTablesExtendedStatement(this.getDatabaseType());
    }

    @Override
    public ASTNode visitShowTblproperties(HiveStatementParser.ShowTblpropertiesContext ctx) {
        return new HiveShowTblpropertiesStatement(this.getDatabaseType());
    }

    @Override
    public ASTNode visitShowCreateTable(HiveStatementParser.ShowCreateTableContext ctx) {
        return new MySQLShowCreateTableStatement(this.getDatabaseType(), (SimpleTableSegment)this.visit((ParseTree)ctx.tableName()));
    }

    @Override
    public ASTNode visitShowIndex(HiveStatementParser.ShowIndexContext ctx) {
        FromDatabaseSegment fromDatabase = null;
        if (null != ctx.showFrom()) {
            fromDatabase = this.createFromDatabaseSegment(ctx.showFrom());
        }
        return new MySQLShowIndexStatement(this.getDatabaseType(), (SimpleTableSegment)this.visit((ParseTree)ctx.tableName()), fromDatabase);
    }

    private FromDatabaseSegment createFromDatabaseSegment(HiveStatementParser.ShowFromContext showFromContext) {
        ASTNode showFromNode = (ASTNode)this.visit((ParseTree)showFromContext);
        if (showFromNode instanceof DatabaseSegment) {
            return new FromDatabaseSegment(showFromContext.getStart().getStartIndex(), (DatabaseSegment)showFromNode);
        }
        return null;
    }

    @Override
    public ASTNode visitShowColumns(HiveStatementParser.ShowColumnsContext ctx) {
        SimpleTableSegment table = null;
        if (null != ctx.tableName()) {
            table = (SimpleTableSegment)this.visit((ParseTree)ctx.tableName());
        }
        FromDatabaseSegment fromDatabase = null;
        if (null != ctx.showFrom()) {
            fromDatabase = this.createFromDatabaseSegment(ctx.showFrom());
        }
        ShowFilterSegment filter = null;
        if (null != ctx.showLike()) {
            filter = new ShowFilterSegment(ctx.showLike().getStart().getStartIndex(), ctx.showLike().getStop().getStopIndex());
            filter.setLike((ShowLikeSegment)this.visit((ParseTree)ctx.showLike()));
        }
        return new MySQLShowColumnsStatement(this.getDatabaseType(), table, fromDatabase, filter);
    }

    @Override
    public ASTNode visitShowFunctions(HiveStatementParser.ShowFunctionsContext ctx) {
        return new HiveShowFunctionsStatement(this.getDatabaseType());
    }

    @Override
    public ASTNode visitShowGrantedRolesAndPrivileges(HiveStatementParser.ShowGrantedRolesAndPrivilegesContext ctx) {
        return new MySQLShowGrantsStatement(this.getDatabaseType());
    }

    @Override
    public ASTNode visitShowLocks(HiveStatementParser.ShowLocksContext ctx) {
        return new HiveShowLocksStatement(this.getDatabaseType());
    }

    @Override
    public ASTNode visitShowConf(HiveStatementParser.ShowConfContext ctx) {
        return new HiveShowConfStatement(this.getDatabaseType());
    }

    @Override
    public ASTNode visitShowTransactions(HiveStatementParser.ShowTransactionsContext ctx) {
        return new HiveShowTransactionsStatement(this.getDatabaseType());
    }

    @Override
    public ASTNode visitShowCompactions(HiveStatementParser.ShowCompactionsContext ctx) {
        return new HiveShowCompactionsStatement(this.getDatabaseType());
    }

    @Override
    public ASTNode visitDescribeDatabase(HiveStatementParser.DescribeDatabaseContext ctx) {
        return new HiveDescribeStatement(this.getDatabaseType());
    }

    @Override
    public ASTNode visitDescribeConnector(HiveStatementParser.DescribeConnectorContext ctx) {
        return new HiveDescribeStatement(this.getDatabaseType());
    }

    @Override
    public ASTNode visitDescribeTable(HiveStatementParser.DescribeTableContext ctx) {
        SimpleTableSegment table = (SimpleTableSegment)this.visit((ParseTree)ctx.tableName());
        ColumnSegment columnWildcard = null;
        if (null != ctx.columnClause()) {
            columnWildcard = (ColumnSegment)this.visit((ParseTree)ctx.columnClause().columnName());
        }
        return new MySQLDescribeStatement(this.getDatabaseType(), table, columnWildcard);
    }
}

