/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.datasource.pool.creator;

import com.google.common.base.CaseFormat;
import java.lang.reflect.Method;
import java.time.Duration;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import javax.sql.DataSource;
import org.apache.shardingsphere.database.connector.core.jdbcurl.DialectDefaultQueryPropertiesProvider;
import org.apache.shardingsphere.database.connector.core.jdbcurl.parser.ConnectionProperties;
import org.apache.shardingsphere.database.connector.core.jdbcurl.parser.ConnectionPropertiesParser;
import org.apache.shardingsphere.database.connector.core.spi.DatabaseTypedSPILoader;
import org.apache.shardingsphere.database.connector.core.type.DatabaseType;
import org.apache.shardingsphere.database.connector.core.type.DatabaseTypeFactory;
import org.apache.shardingsphere.infra.datasource.pool.metadata.DataSourcePoolMetaData;
import org.apache.shardingsphere.infra.datasource.pool.metadata.DataSourcePoolMetaDataReflection;
import org.apache.shardingsphere.infra.datasource.pool.metadata.impl.DefaultDataSourcePoolFieldMetaData;
import org.apache.shardingsphere.infra.spi.type.typed.TypedSPILoader;

public final class DataSourcePoolReflection {
    private static final Collection<Class<?>> GENERAL_CLASS_TYPES = new HashSet<Class>(Arrays.asList(Boolean.TYPE, Boolean.class, Integer.TYPE, Integer.class, Long.TYPE, Long.class, String.class, Collection.class, List.class, Properties.class));
    private static final Collection<String> SKIPPED_PROPERTY_KEYS = new HashSet<String>(Collections.singletonList("loginTimeout"));
    private static final String IS_PREFIX = "is";
    private static final String GETTER_PREFIX = "get";
    private static final String SETTER_PREFIX = "set";
    private final DataSource dataSource;
    private final Method[] dataSourceMethods;

    public DataSourcePoolReflection(DataSource dataSource) {
        this.dataSource = dataSource;
        this.dataSourceMethods = dataSource.getClass().getMethods();
    }

    public Map<String, Object> convertToProperties() {
        Map<String, Object> getterProps = this.convertToProperties(GETTER_PREFIX);
        Map<String, Object> isProps = this.convertToProperties(IS_PREFIX);
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>(getterProps.size() + isProps.size(), 1.0f);
        result.putAll(getterProps);
        result.putAll(isProps);
        return result;
    }

    private Map<String, Object> convertToProperties(String prefix) {
        Collection<Method> getterMethods = this.findAllGetterMethods(prefix);
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>(getterMethods.size(), 1.0f);
        for (Method each : getterMethods) {
            Object fieldValue;
            String fieldName = this.getGetterFieldName(each, prefix);
            if (!GENERAL_CLASS_TYPES.contains(each.getReturnType()) || SKIPPED_PROPERTY_KEYS.contains(fieldName) || null == (fieldValue = each.invoke((Object)this.dataSource, new Object[0]))) continue;
            result.put(fieldName, fieldValue);
        }
        return result;
    }

    private Collection<Method> findAllGetterMethods(String methodPrefix) {
        HashSet<Method> result = new HashSet<Method>(this.dataSourceMethods.length, 1.0f);
        for (Method each : this.dataSourceMethods) {
            if (!each.getName().startsWith(methodPrefix) || 0 != each.getParameterTypes().length) continue;
            result.add(each);
        }
        return result;
    }

    private String getGetterFieldName(Method method, String methodPrefix) {
        return CaseFormat.UPPER_CAMEL.to(CaseFormat.LOWER_CAMEL, method.getName().substring(methodPrefix.length()));
    }

    public void setField(String fieldName, Object fieldValue) {
        if (null != fieldValue && !this.isSkippedProperty(fieldName)) {
            this.findSetterMethod(fieldName).ifPresent(optional -> this.setField((Method)optional, fieldValue));
        }
    }

    private void setField(Method method, Object fieldValue) {
        Class<?> paramType = method.getParameterTypes()[0];
        if (String.class == paramType && Properties.class.isAssignableFrom(fieldValue.getClass())) {
            return;
        }
        if (Integer.TYPE == paramType || Integer.class == paramType) {
            method.invoke((Object)this.dataSource, Integer.parseInt(fieldValue.toString()));
        } else if (Long.TYPE == paramType || Long.class == paramType) {
            method.invoke((Object)this.dataSource, Long.parseLong(fieldValue.toString()));
        } else if (Boolean.TYPE == paramType || Boolean.class == paramType) {
            method.invoke((Object)this.dataSource, Boolean.parseBoolean(fieldValue.toString()));
        } else if (String.class == paramType) {
            method.invoke((Object)this.dataSource, fieldValue.toString());
        } else if (Properties.class == paramType) {
            Properties props = new Properties();
            props.putAll((Map<?, ?>)((Map)fieldValue));
            method.invoke((Object)this.dataSource, props);
        } else if (Duration.class == paramType) {
            method.invoke((Object)this.dataSource, Duration.ofSeconds(Long.parseLong(fieldValue.toString())));
        } else {
            method.invoke((Object)this.dataSource, fieldValue);
        }
    }

    private boolean isSkippedProperty(String key) {
        return SKIPPED_PROPERTY_KEYS.contains(key);
    }

    private Optional<Method> findSetterMethod(String fieldName) {
        String setterMethodName = SETTER_PREFIX + CaseFormat.LOWER_CAMEL.to(CaseFormat.UPPER_CAMEL, fieldName);
        return Arrays.stream(this.dataSourceMethods).filter(each -> each.getName().equals(setterMethodName) && 1 == each.getParameterTypes().length).findFirst();
    }

    public void addDefaultDataSourcePoolProperties(DataSourcePoolMetaData metaData) {
        DataSourcePoolMetaDataReflection dataSourcePoolMetaDataReflection = new DataSourcePoolMetaDataReflection(this.dataSource, TypedSPILoader.findService(DataSourcePoolMetaData.class, (Object)this.dataSource.getClass().getName()).map(DataSourcePoolMetaData::getFieldMetaData).orElseGet(DefaultDataSourcePoolFieldMetaData::new));
        Optional<String> jdbcUrl = dataSourcePoolMetaDataReflection.getJdbcUrl();
        Optional<Properties> jdbcConnectionProps = dataSourcePoolMetaDataReflection.getJdbcConnectionProperties();
        if (!jdbcUrl.isPresent() || !jdbcConnectionProps.isPresent()) {
            return;
        }
        DatabaseType databaseType = DatabaseTypeFactory.get((String)jdbcUrl.get());
        ConnectionProperties connectionProps = ((ConnectionPropertiesParser)DatabaseTypedSPILoader.getService(ConnectionPropertiesParser.class, (DatabaseType)databaseType)).parse(jdbcUrl.get(), null, null);
        Properties queryProps = connectionProps.getQueryProperties();
        Properties jdbcProps = jdbcConnectionProps.get();
        Optional defaultQueryPropertiesProvider = DatabaseTypedSPILoader.findService(DialectDefaultQueryPropertiesProvider.class, (DatabaseType)databaseType);
        if (defaultQueryPropertiesProvider.isPresent()) {
            for (Map.Entry<Object, Object> entry : ((DialectDefaultQueryPropertiesProvider)defaultQueryPropertiesProvider.get()).getDefaultQueryProperties().entrySet()) {
                String defaultPropertyKey = entry.getKey().toString();
                String defaultPropertyValue = entry.getValue().toString();
                if (this.containsDefaultProperty(defaultPropertyKey, jdbcProps, queryProps)) continue;
                jdbcProps.setProperty(defaultPropertyKey, defaultPropertyValue);
            }
        }
        this.setField(metaData.getFieldMetaData().getJdbcUrlPropertiesFieldName(), (Object)jdbcProps);
    }

    private boolean containsDefaultProperty(String defaultPropKey, Properties targetProps, Properties queryProps) {
        return targetProps.containsKey(defaultPropKey) || queryProps.containsKey(defaultPropKey);
    }
}

