/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.datasource.pool.creator;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import javax.sql.DataSource;
import lombok.Generated;
import org.apache.shardingsphere.database.connector.core.GlobalDataSourceRegistry;
import org.apache.shardingsphere.infra.datasource.pool.creator.DataSourcePoolReflection;
import org.apache.shardingsphere.infra.datasource.pool.destroyer.DataSourcePoolDestroyer;
import org.apache.shardingsphere.infra.datasource.pool.metadata.DataSourcePoolMetaData;
import org.apache.shardingsphere.infra.datasource.pool.metadata.DataSourcePoolMetaDataReflection;
import org.apache.shardingsphere.infra.datasource.pool.props.domain.DataSourcePoolProperties;
import org.apache.shardingsphere.infra.datasource.pool.props.domain.custom.CustomDataSourcePoolProperties;
import org.apache.shardingsphere.infra.spi.type.typed.TypedSPILoader;

public final class DataSourcePoolCreator {
    public static Map<String, DataSource> create(Map<String, DataSourcePoolProperties> propsMap, boolean cacheEnabled) {
        LinkedHashMap<String, DataSource> result = new LinkedHashMap<String, DataSource>(propsMap.size(), 1.0f);
        for (Map.Entry<String, DataSourcePoolProperties> entry : propsMap.entrySet()) {
            result.put(entry.getKey(), DataSourcePoolCreator.create(entry.getKey(), entry.getValue(), cacheEnabled, result.values()));
        }
        return result;
    }

    public static DataSource create(DataSourcePoolProperties props) {
        DataSource result = DataSourcePoolCreator.create(props.getPoolClassName());
        Optional poolMetaData = TypedSPILoader.findService(DataSourcePoolMetaData.class, (Object)props.getPoolClassName());
        DataSourcePoolReflection dataSourcePoolReflection = new DataSourcePoolReflection(result);
        if (poolMetaData.isPresent()) {
            DataSourcePoolCreator.setDefaultFields(dataSourcePoolReflection, (DataSourcePoolMetaData)poolMetaData.get());
            DataSourcePoolCreator.setConfiguredFields(props, dataSourcePoolReflection, (DataSourcePoolMetaData)poolMetaData.get());
            DataSourcePoolCreator.appendJdbcUrlProperties(props.getCustomProperties(), result, (DataSourcePoolMetaData)poolMetaData.get(), dataSourcePoolReflection);
            dataSourcePoolReflection.addDefaultDataSourcePoolProperties((DataSourcePoolMetaData)poolMetaData.get());
        } else {
            DataSourcePoolCreator.setConfiguredFields(props, dataSourcePoolReflection);
        }
        return result;
    }

    public static DataSource create(String dataSourceName, DataSourcePoolProperties props, boolean cacheEnabled) {
        DataSource result = DataSourcePoolCreator.create(props);
        if (cacheEnabled && !GlobalDataSourceRegistry.getInstance().getCachedDataSources().containsKey(dataSourceName)) {
            GlobalDataSourceRegistry.getInstance().getCachedDataSources().put(dataSourceName, result);
        }
        return result;
    }

    public static DataSource create(String dataSourceName, DataSourcePoolProperties props, boolean cacheEnabled, Collection<DataSource> storageNodes) {
        try {
            return DataSourcePoolCreator.create(dataSourceName, props, cacheEnabled);
        }
        catch (RuntimeException ex) {
            if (!cacheEnabled) {
                storageNodes.stream().map(DataSourcePoolDestroyer::new).forEach(DataSourcePoolDestroyer::asyncDestroy);
            }
            throw ex;
        }
    }

    private static DataSource create(String dataSourceClassName) {
        return (DataSource)Class.forName(dataSourceClassName).getConstructor(new Class[0]).newInstance(new Object[0]);
    }

    private static void setDefaultFields(DataSourcePoolReflection dataSourcePoolReflection, DataSourcePoolMetaData poolMetaData) {
        for (Map.Entry<String, Object> entry : poolMetaData.getDefaultProperties().entrySet()) {
            dataSourcePoolReflection.setField(entry.getKey(), entry.getValue());
        }
    }

    private static void setConfiguredFields(DataSourcePoolProperties props, DataSourcePoolReflection dataSourcePoolReflection) {
        for (Map.Entry<String, Object> entry : props.getAllLocalProperties().entrySet()) {
            dataSourcePoolReflection.setField(entry.getKey(), entry.getValue());
        }
    }

    private static void setConfiguredFields(DataSourcePoolProperties props, DataSourcePoolReflection dataSourcePoolReflection, DataSourcePoolMetaData poolMetaData) {
        for (Map.Entry<String, Object> entry : props.getAllLocalProperties().entrySet()) {
            Object fieldValue;
            String fieldName = entry.getKey();
            if (!DataSourcePoolCreator.isValidProperty(fieldName, fieldValue = entry.getValue(), poolMetaData) || fieldName.equals(poolMetaData.getFieldMetaData().getJdbcUrlPropertiesFieldName())) continue;
            dataSourcePoolReflection.setField(fieldName, fieldValue);
        }
    }

    private static boolean isValidProperty(String key, Object value, DataSourcePoolMetaData poolMetaData) {
        return !poolMetaData.getSkippedProperties().containsKey(key) || null == value || !value.equals(poolMetaData.getSkippedProperties().get(key));
    }

    private static void appendJdbcUrlProperties(CustomDataSourcePoolProperties customPoolProps, DataSource targetDataSource, DataSourcePoolMetaData poolMetaData, DataSourcePoolReflection dataSourcePoolReflection) {
        String jdbcUrlPropertiesFieldName = poolMetaData.getFieldMetaData().getJdbcUrlPropertiesFieldName();
        if (null != jdbcUrlPropertiesFieldName && customPoolProps.getProperties().containsKey(jdbcUrlPropertiesFieldName)) {
            Map jdbcUrlProps = (Map)customPoolProps.getProperties().get(jdbcUrlPropertiesFieldName);
            DataSourcePoolMetaDataReflection dataSourcePoolMetaDataReflection = new DataSourcePoolMetaDataReflection(targetDataSource, poolMetaData.getFieldMetaData());
            dataSourcePoolMetaDataReflection.getJdbcConnectionProperties().ifPresent(optional -> DataSourcePoolCreator.setJdbcUrlProperties(dataSourcePoolReflection, optional, jdbcUrlProps, jdbcUrlPropertiesFieldName));
        }
    }

    private static void setJdbcUrlProperties(DataSourcePoolReflection dataSourcePoolReflection, Properties jdbcConnectionProps, Map<String, Object> customProps, String jdbcUrlPropertiesFieldName) {
        for (Map.Entry<String, Object> entry : customProps.entrySet()) {
            jdbcConnectionProps.setProperty(entry.getKey(), entry.getValue().toString());
        }
        dataSourcePoolReflection.setField(jdbcUrlPropertiesFieldName, (Object)jdbcConnectionProps);
    }

    @Generated
    private DataSourcePoolCreator() {
    }
}

